/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.config;

import electric.util.encoding.XMLEncodings;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.IConfig;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.IEXMLLoggingConstants;
import electric.xml.config.IEXMLConfigConstants;

public final class EncodingsConfig
implements IConfig,
IEXMLLoggingConstants,
IEXMLConfigConstants {
    public void config(Element config) throws Throwable {
        Element encodingsElement = config.getElement("xmlEncodings");
        if (encodingsElement == null) {
            return;
        }
        Elements encodings = encodingsElement.getElements("encoding");
        String[] suggestedEnc = new String[encodings.size()];
        int i = 0;
        while (i < suggestedEnc.length) {
            suggestedEnc[i] = encodings.next().getString();
            ++i;
        }
        String[] unsupportedEncodings = XMLEncodings.initSuggestedEncodings(suggestedEnc);
        if (Log.isLogging(ILoggingConstants.COMMENT_EVENT)) {
            int i2 = 0;
            while (i2 < unsupportedEncodings.length) {
                Log.log(ILoggingConstants.COMMENT_EVENT, (Object)("encoding " + unsupportedEncodings[i2] + " not supported on this machine."));
                ++i2;
            }
        }
        Elements encodingMappings = encodingsElement.getElements("mapping");
        while (encodingMappings.hasMoreElements()) {
            Element element = encodingMappings.next();
            String java = element.getString("java");
            String xml = element.getString("xml");
            XMLEncodings.addBidirectionalEncoding(xml, java);
        }
    }
}

