/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.xml.CharacterData;
import electric.xml.IXMLConstants;
import electric.xml.NamespaceException;
import electric.xml.NodeReader;
import electric.xml.NodeWriter;
import electric.xml.Parent;
import java.io.IOException;

public class Text
extends CharacterData
implements org.w3c.dom.Text {
    protected boolean raw;

    public Text(String string) {
        super(string);
    }

    public Text(Text text) {
        super(text.string);
    }

    public Text(Parent parent) {
        super(parent);
    }

    public Object clone() {
        return new Text(this);
    }

    public String getString() {
        return this.string;
    }

    public void setString(String string) {
        this.string = string;
    }

    public void setRaw(boolean flag) {
        this.raw = flag;
    }

    public boolean getRaw() {
        return this.raw;
    }

    public void read(NodeReader reader) throws IOException, NamespaceException {
        String token = reader.readToPattern("<", 72);
        StringBuffer whitespace = reader.getLastWhitespace();
        this.string = whitespace == null ? token : whitespace.append(token).toString();
    }

    public void write(NodeWriter writer) throws IOException {
        writer.writeIndent();
        if (this.raw) {
            writer.write(this.string);
        } else {
            Text.writeWithSubstitution(writer, this.string);
        }
    }

    public static void writeWithSubstitution(NodeWriter writer, String string) throws IOException {
        int lastSubstituteIndex = -1;
        char[] characters = string.toCharArray();
        int length = characters.length;
        int i = 0;
        while (i < length) {
            int index = Text.getSpecialIndex(characters[i]);
            if (index != -1) {
                writer.write(string.substring(lastSubstituteIndex + 1, i));
                writer.write(IXMLConstants.SUBSTITUTES[index]);
                lastSubstituteIndex = i;
            }
            ++i;
        }
        if (lastSubstituteIndex == -1) {
            writer.write(string);
        } else if (lastSubstituteIndex < length - 1) {
            writer.write(string.substring(lastSubstituteIndex + 1, length));
        }
    }

    private static int getSpecialIndex(char character) {
        int j = 0;
        while (j < IXMLConstants.SPECIALS.length) {
            if (character == IXMLConstants.SPECIALS[j]) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    public short getNodeType() {
        return 3;
    }

    public String getNodeName() {
        return "#text";
    }

    public org.w3c.dom.Text splitText(int offset) {
        String tail = this.string.substring(offset);
        this.string = this.string.substring(0, offset);
        Text text = new Text(tail);
        this.setNextSiblingChild(text);
        return text;
    }
}

