/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.util.named.IQNamed;
import electric.xml.Attribute;
import electric.xml.Attributes;
import electric.xml.CData;
import electric.xml.Comment;
import electric.xml.Elements;
import electric.xml.INamespaceContext;
import electric.xml.IXPath;
import electric.xml.Instruction;
import electric.xml.NamespaceException;
import electric.xml.Node;
import electric.xml.NodeList;
import electric.xml.NodeReader;
import electric.xml.NodeWriter;
import electric.xml.Parent;
import electric.xml.Selection;
import electric.xml.Text;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;

public class Element
extends Parent
implements IQNamed,
INamespaceContext,
org.w3c.dom.Element {
    String prefix;
    String namespace;
    String name;
    private NodeList attributes = new NodeList();

    public Element() {
        this.name = "UNDEFINED";
    }

    public Element(String name) {
        this.name = name;
    }

    public Element(String prefix, String name, String namespace) {
        this.prefix = prefix;
        this.name = name;
        this.namespace = namespace;
    }

    public Element(Element element) {
        super(element);
        this.namespace = element.namespace;
        this.name = element.name;
        Attribute attribute = (Attribute)element.attributes.first;
        while (attribute != null) {
            this.attributes.append(new Attribute(attribute));
            attribute = (Attribute)attribute.next;
        }
        if (this.namespace != null) {
            this.prefix = this.getPrefix(this.namespace, element.prefix);
        }
    }

    public Object clone() {
        return new Element(this);
    }

    public Element getRoot() {
        return this.parent == null ? this : this.parent.getRoot();
    }

    public Element getParentElement() {
        return (Element)this.getParent();
    }

    public String getName() {
        return this.name;
    }

    public String getQName() {
        if (this.namespace == null) {
            return this.name;
        }
        if (this.namespace.endsWith(":")) {
            return this.namespace + this.name;
        }
        return this.namespace + ":" + this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPrefix(String namespace) {
        return this.getPrefix(namespace, null);
    }

    public String getPrefix(String namespace, String preferredPrefix) {
        if (namespace == null) {
            return null;
        }
        String defaultNamespace = this.getDefaultNamespace();
        if (defaultNamespace == null && namespace.equals("")) {
            return "";
        }
        if (namespace.equals(defaultNamespace)) {
            return "";
        }
        String existingPrefix = this.getNamespacePrefix(namespace);
        if (existingPrefix != null) {
            return existingPrefix;
        }
        Element root = this.getRoot();
        if (preferredPrefix == null || this.getNamespace(preferredPrefix) != null) {
            preferredPrefix = "n" + root.getAttributeObjects().size();
        }
        root.setNamespace(preferredPrefix, namespace);
        return preferredPrefix;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Element setName(String name) {
        this.name = name;
        this.namespace = this.getDefaultNamespace();
        return this;
    }

    public Element setName(String prefix, String name) throws NamespaceException {
        this.prefix = prefix;
        this.name = name;
        if (prefix == null || prefix == "") {
            this.namespace = this.getDefaultNamespace();
        } else {
            this.namespace = this.getNamespace(prefix);
            if (this.namespace == null) {
                throw new NamespaceException("could not find namespace with prefix " + prefix);
            }
        }
        return this;
    }

    public void setName(String prefix, String name, String namespace) {
        this.prefix = prefix;
        this.name = name;
        this.namespace = namespace;
    }

    public String getQName(String string) throws NamespaceException {
        int index = string.indexOf(58);
        String ns = null;
        if (index != -1) {
            String prefix = string.substring(0, index);
            string = string.substring(index + 1);
            ns = this.getNamespace(prefix);
            if (ns == null) {
                throw new NamespaceException("could not resolve " + prefix + ":" + string);
            }
        } else {
            ns = this.getDefaultNamespace();
        }
        if (ns == null) {
            return string;
        }
        if (ns.endsWith(":")) {
            return ns + string;
        }
        return ns + ":" + string;
    }

    public boolean hasName(String namespace, String name) {
        if (!this.name.equals(name)) {
            return false;
        }
        if (namespace == null) {
            return true;
        }
        if (this.namespace == null) {
            return false;
        }
        return this.namespace.equals(namespace);
    }

    public boolean hasName(String name) {
        return this.name.equals(name);
    }

    public boolean hasText() {
        return this.getText() != null;
    }

    public Text getText() {
        Node node = this.children.first;
        while (node != null) {
            if (node instanceof Text) {
                return (Text)node;
            }
            node = node.next;
        }
        return null;
    }

    public Text getText(String name) {
        Element element = this.getElement(name);
        return element == null ? null : element.getText();
    }

    public Text getText(String namespace, String name) {
        Element element = this.getElement(namespace, name);
        return element == null ? null : element.getText();
    }

    public Text getText(IXPath xpath) {
        Element element = this.getElement(xpath);
        return element == null ? null : element.getText();
    }

    public String getTextString() {
        Text text = this.getText();
        return text == null ? null : text.string;
    }

    public String getTextString(String name) {
        Text text = this.getText(name);
        return text == null ? null : text.string;
    }

    public String getTextString(String namespace, String name) {
        Text text = this.getText(namespace, name);
        return text == null ? null : text.string;
    }

    public String getTextString(IXPath xpath) {
        Text text = this.getText(xpath);
        return text == null ? null : text.string;
    }

    public String getTrimTextString() {
        Text text = this.getText();
        return text == null ? null : text.string.trim();
    }

    public String getTrimTextString(String name) {
        Text text = this.getText(name);
        return text == null ? null : text.string.trim();
    }

    public String getTrimTextString(String namespace, String name) {
        Text text = this.getText(namespace, name);
        return text == null ? null : text.string.trim();
    }

    public String getTrimTextString(IXPath xpath) {
        Text text = this.getText(xpath);
        return text == null ? null : text.string.trim();
    }

    public Element setText(String text) {
        return this.setText(text == null ? null : new Text(text));
    }

    public void setText(String name, String text) {
        this.setElement(name).setText(text);
    }

    public void setText(String prefix, String name, String text) {
        this.setElement(prefix, name).setText(text);
    }

    public Element setText(Text text) {
        Text oldText = this.getText();
        if (text == null) {
            if (oldText != null) {
                oldText.remove();
            }
        } else if (oldText == null) {
            this.addChild(text);
        } else {
            oldText.replaceWith(text);
        }
        return this;
    }

    public Element addText(String text) {
        return this.addText(new Text(text));
    }

    public Element addText(Text text) {
        this.addChild(text);
        return this;
    }

    public Element insertText(String text) {
        return this.insertText(new Text(text));
    }

    public Element insertText(Text text) {
        this.insertChild(text);
        return this;
    }

    public String getString() {
        Text text = this.getText();
        return text == null ? null : text.string.trim();
    }

    public String getString(String name) {
        Text text = this.getText(name);
        return text == null ? null : text.string.trim();
    }

    public String getString(String namespace, String name) {
        Text text = this.getText(namespace, name);
        return text == null ? null : text.string.trim();
    }

    public void setString(String value) {
        this.setText(value);
    }

    public void setString(String name, String value) {
        this.setElement(name).setText(value);
    }

    public void setString(String prefix, String name, String value) {
        this.setElement(prefix, name).setText(value);
    }

    public boolean getBoolean() throws NumberFormatException {
        String text = this.getString();
        if (text == null) {
            throw new NumberFormatException("missing boolean value");
        }
        if (text.equalsIgnoreCase("true") || text.equals("1") || text.equals("yes")) {
            return true;
        }
        if (text.equalsIgnoreCase("false") || text.equals("0") || text.equals("no")) {
            return false;
        }
        throw new NumberFormatException("invalid value for the boolean argument. expected \"true\" or \"false\", but received - " + text);
    }

    public boolean getBoolean(String name) throws NumberFormatException {
        return this.needElement(name).getBoolean();
    }

    public boolean getBoolean(String namespace, String name) throws NumberFormatException {
        return this.needElement(namespace, name).getBoolean();
    }

    public void setBoolean(boolean value) {
        this.setText(value ? "true" : "false");
    }

    public void setBoolean(String name, boolean value) {
        this.setElement(name).setBoolean(value);
    }

    public void setBoolean(String prefix, String name, boolean value) {
        this.setElement(prefix, name).setBoolean(value);
    }

    public byte getByte() throws NumberFormatException {
        String text = this.getString();
        if (text == null) {
            throw new NumberFormatException("missing byte value");
        }
        return Byte.parseByte(text);
    }

    public byte getByte(String name) throws NumberFormatException {
        return this.needElement(name).getByte();
    }

    public byte getByte(String namespace, String name) throws NumberFormatException {
        return this.needElement(namespace, name).getByte();
    }

    public void setByte(byte value) {
        this.setText(Byte.toString(value));
    }

    public void setByte(String name, byte value) {
        this.setElement(name).setByte(value);
    }

    public void setByte(String prefix, String name, byte value) {
        this.setElement(prefix, name).setByte(value);
    }

    public char getChar() throws NumberFormatException {
        return (char)this.getShort();
    }

    public char getChar(String name) throws NumberFormatException {
        return (char)this.getShort(name);
    }

    public char getChar(String namespace, String name) throws NumberFormatException {
        return (char)this.getShort(namespace, name);
    }

    public void setChar(char value) {
        this.setShort((short)value);
    }

    public void setChar(String name, char value) {
        this.setShort(name, (short)value);
    }

    public void setChar(String prefix, String name, char value) {
        this.setShort(prefix, name, (short)value);
    }

    public short getShort() throws NumberFormatException {
        String text = this.getString();
        if (text == null) {
            throw new NumberFormatException("missing short value");
        }
        return Short.parseShort(text);
    }

    public short getShort(String name) throws NumberFormatException {
        return this.needElement(name).getShort();
    }

    public short getShort(String namespace, String name) throws NumberFormatException {
        return this.needElement(namespace, name).getShort();
    }

    public void setShort(short value) {
        this.setText(Short.toString(value));
    }

    public void setShort(String name, short value) {
        this.setElement(name).setShort(value);
    }

    public void setShort(String prefix, String name, short value) {
        this.setElement(prefix, name).setShort(value);
    }

    public int getInt() throws NumberFormatException {
        String text = this.getString();
        if (text == null) {
            throw new NumberFormatException("missing int value");
        }
        return Integer.parseInt(text);
    }

    public int getInt(String name) throws NumberFormatException {
        return this.needElement(name).getInt();
    }

    public int getInt(String namespace, String name) throws NumberFormatException {
        return this.needElement(namespace, name).getInt();
    }

    public void setInt(int value) {
        this.setText(Integer.toString(value));
    }

    public void setInt(String name, int value) {
        this.setElement(name).setInt(value);
    }

    public void setInt(String prefix, String name, int value) {
        this.setElement(prefix, name).setInt(value);
    }

    public long getLong() throws NumberFormatException {
        String text = this.getString();
        if (text == null) {
            throw new NumberFormatException("missing long value");
        }
        return Long.parseLong(text);
    }

    public long getLong(String name) throws NumberFormatException {
        return this.needElement(name).getLong();
    }

    public long getLong(String namespace, String name) throws NumberFormatException {
        return this.needElement(namespace, name).getLong();
    }

    public void setLong(long value) {
        this.setText(Long.toString(value));
    }

    public void setLong(String name, long value) {
        this.setElement(name).setLong(value);
    }

    public void setLong(String prefix, String name, long value) {
        this.setElement(prefix, name).setLong(value);
    }

    public float getFloat() throws NumberFormatException {
        String text = this.getString();
        if (text == null) {
            throw new NumberFormatException("missing float value");
        }
        if ("NaN".equals(text)) {
            return Float.NaN;
        }
        if ("INF".equals(text)) {
            return Float.POSITIVE_INFINITY;
        }
        if ("-INF".equals(text)) {
            return Float.NEGATIVE_INFINITY;
        }
        return new Float(text).floatValue();
    }

    public float getFloat(String name) throws NumberFormatException {
        return this.needElement(name).getFloat();
    }

    public float getFloat(String namespace, String name) throws NumberFormatException {
        return this.needElement(namespace, name).getFloat();
    }

    public void setFloat(float value) {
        if (value == Float.POSITIVE_INFINITY) {
            this.setText("INF");
        } else if (value == Float.NEGATIVE_INFINITY) {
            this.setText("-INF");
        } else {
            this.setText(Float.toString(value));
        }
    }

    public void setFloat(String name, float value) {
        this.setElement(name).setFloat(value);
    }

    public void setFloat(String prefix, String name, float value) {
        this.setElement(prefix, name).setFloat(value);
    }

    public double getDouble() throws NumberFormatException {
        String text = this.getString();
        if (text == null) {
            throw new NumberFormatException("missing double value");
        }
        if ("NaN".equals(text)) {
            return Double.NaN;
        }
        if ("INF".equals(text)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("-INF".equals(text)) {
            return Double.NEGATIVE_INFINITY;
        }
        return new Double(text);
    }

    public double getDouble(String name) throws NumberFormatException {
        return this.needElement(name).getDouble();
    }

    public double getDouble(String namespace, String name) throws NumberFormatException {
        return this.needElement(namespace, name).getDouble();
    }

    public void setDouble(double value) {
        if (value == Double.POSITIVE_INFINITY) {
            this.setText("INF");
        } else if (value == Double.NEGATIVE_INFINITY) {
            this.setText("-INF");
        } else {
            this.setText(Double.toString(value));
        }
    }

    public void setDouble(String name, double value) {
        this.setElement(name).setDouble(value);
    }

    public void setDouble(String prefix, String name, double value) {
        this.setElement(prefix, name).setDouble(value);
    }

    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    public Attributes getAttributeObjects() {
        return new Attributes(this.attributes);
    }

    public Attribute getAttributeObject(String name) {
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            if (attribute.name.equals(name)) {
                return attribute;
            }
            attribute = (Attribute)attribute.next;
        }
        return null;
    }

    public Attribute getAttributeObject(String namespace, String name) {
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            if (attribute.hasName(namespace, name)) {
                return attribute;
            }
            attribute = (Attribute)attribute.next;
        }
        return null;
    }

    public Attribute getAttributeObject(IXPath xpath) {
        return xpath.getAttribute(this);
    }

    public Attributes getAttributes(IXPath xpath) {
        return xpath.getAttributes(this);
    }

    public String getAttributeValue(String name) {
        Attribute attribute = this.getAttributeObject(name);
        return attribute == null ? null : attribute.value;
    }

    public String getAttributeValue(String namespace, String name) {
        Attribute attribute = this.getAttributeObject(namespace, name);
        return attribute == null ? null : attribute.value;
    }

    public String getAttributeValue(IXPath xpath) {
        Attribute attribute = this.getAttributeObject(xpath);
        return attribute == null ? null : attribute.value;
    }

    public void setAttribute(String name, String value) {
        this.setAttribute(new Attribute(name, value));
    }

    public Element setAttribute(String prefix, String name, String value) {
        this.setAttribute(new Attribute(prefix, name, value));
        return this;
    }

    public Element setAttribute(Attribute attribute) throws NamespaceException {
        attribute.resolve(this);
        Attribute node = (Attribute)this.attributes.first;
        while (node != null) {
            if (node.hasName(attribute.namespace, attribute.name)) {
                this.attributes.replace(node, attribute);
                return this;
            }
            node = (Attribute)node.next;
        }
        this.attributes.append(attribute);
        return this;
    }

    public void removeAttribute(String name) {
        Attribute attribute = this.getAttributeObject(name);
        if (attribute != null) {
            attribute.remove();
        }
    }

    public Attribute removeAttribute(String namespace, String name) {
        Attribute attribute = this.getAttributeObject(namespace, name);
        if (attribute != null) {
            attribute.remove();
        }
        return attribute;
    }

    public Attribute removeAttribute(IXPath xpath) {
        Attribute attribute = this.getAttributeObject(xpath);
        if (attribute != null) {
            attribute.remove();
        }
        return attribute;
    }

    public Attributes removeAttributes(IXPath xpath) {
        Attributes attributes = this.getAttributes(xpath);
        attributes.remove();
        attributes.reset();
        return attributes;
    }

    public Element setNextSibling(String name) {
        Element sibling = new Element();
        sibling.setParent(this.parent);
        sibling.setName(name);
        this.setNextSiblingChild(sibling);
        return sibling;
    }

    public Element setNextSibling(String prefix, String name) {
        Element sibling = new Element();
        sibling.setParent(this.parent);
        sibling.setName(prefix, name);
        this.setNextSiblingChild(sibling);
        return sibling;
    }

    public Element setNextSibling(Element element) {
        element.setParent(this.parent);
        this.setNextSiblingChild(element);
        return element;
    }

    public Element setPreviousSibling(String name) {
        Element sibling = new Element();
        sibling.setParent(this.parent);
        sibling.setName(name);
        this.setPreviousSiblingChild(sibling);
        return sibling;
    }

    public Element setPreviousSibling(String prefix, String name) {
        Element sibling = new Element();
        sibling.setParent(this.parent);
        sibling.setName(prefix, name);
        this.setPreviousSiblingChild(sibling);
        return sibling;
    }

    public Element setPreviousSibling(Element element) {
        element.setParent(this.parent);
        this.setPreviousSiblingChild(element);
        return element;
    }

    public Dictionary getNamespaces() {
        Hashtable<String, String> namespaces = new Hashtable<String, String>();
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            if (attribute.isNamespace) {
                namespaces.put(attribute.name, attribute.value);
            }
            attribute = (Attribute)attribute.next;
        }
        return namespaces;
    }

    public String getNamespace(String prefix) {
        if (prefix.length() == 0) {
            prefix = "xmlns";
        }
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            if (attribute.isNamespace && attribute.name.equals(prefix)) {
                String value = attribute.value;
                return value.length() > 0 ? value : null;
            }
            attribute = (Attribute)attribute.next;
        }
        return this.parent == null ? null : this.parent.getNamespace(prefix);
    }

    public String getDefaultNamespace() {
        return this.getNamespace("xmlns");
    }

    public String getNamespacePrefix(String namespace) {
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            if (attribute.isNamespace && attribute.value.equals(namespace)) {
                return attribute.name;
            }
            attribute = (Attribute)attribute.next;
        }
        if (this.parent != null) {
            return this.parent.getNamespacePrefix(namespace);
        }
        return null;
    }

    public String[] getNamespacePrefixes(String namespace) {
        Vector prefixes = new Vector();
        Vector matches = new Vector();
        this.addNamespacePrefixes(namespace, prefixes, matches);
        Object[] results = new String[matches.size()];
        matches.copyInto(results);
        return results;
    }

    protected void addNamespacePrefixes(String namespace, Vector prefixes, Vector matches) {
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            if (attribute.isNamespace) {
                if (attribute.value.equals(namespace) && !prefixes.contains(attribute.name)) {
                    matches.addElement(attribute.name);
                }
                prefixes.addElement(attribute.name);
            }
            attribute = (Attribute)attribute.next;
        }
        if (this.parent != null) {
            this.parent.addNamespacePrefixes(namespace, prefixes, matches);
        }
    }

    public void setNamespace(String prefix, String value) throws NamespaceException {
        this.setAttribute(new Attribute(prefix, value, true));
    }

    public boolean removeNamespace(String prefix) {
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            if (attribute.isNamespace && attribute.name.equals(prefix)) {
                attribute.remove();
                return true;
            }
            attribute = (Attribute)attribute.next;
        }
        return false;
    }

    public synchronized Element getElementWithId(String value) {
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            if (attribute.isId && attribute.value.equals(value)) {
                return this;
            }
            attribute = (Attribute)attribute.next;
        }
        return super.getElementWithId(value);
    }

    public Hashtable getIds() {
        Hashtable idToElement = new Hashtable();
        this.addIds(idToElement);
        return idToElement;
    }

    synchronized void addIds(Hashtable idToElement) {
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            if (attribute.isId) {
                idToElement.put(attribute.value, this);
            }
            attribute = (Attribute)attribute.next;
        }
        super.addIds(idToElement);
    }

    public int size() {
        int size = 0;
        Node node = this.attributes.first;
        while (node != null) {
            size += 1 + node.size();
            node = node.next;
        }
        if (this.children.isEmpty()) {
            size = this.prefix == null ? (size += 3 + this.name.length()) : (size += 3 + this.prefix.length() + 1 + this.name.length());
        } else {
            size = this.prefix == null ? (size += this.name.length() * 2 + 5) : (size += (this.prefix.length() + 1 + this.name.length()) * 2 + 5);
            Node node2 = this.children.first;
            while (node2 != null) {
                size += node2.size();
                node2 = node2.next;
            }
        }
        return size;
    }

    public void read(NodeReader reader) throws IOException, NamespaceException {
        reader.read();
        this.name = reader.readToken();
        if (reader.peek() == 58) {
            this.prefix = this.name;
            reader.read();
            this.name = reader.readToken();
        }
        reader.skipWhitespace();
        int peek = reader.peek();
        if (peek != 62 && peek != 47) {
            this.readAttributes(reader);
        }
        if (this.prefix == null) {
            this.namespace = this.getDefaultNamespace();
        } else {
            this.namespace = this.getNamespace(this.prefix);
            if (this.namespace == null) {
                throw new NamespaceException("could not find namespace with prefix " + this.prefix);
            }
        }
        int ch = reader.read();
        if (ch == 47) {
            reader.readChar(62);
        } else {
            if (ch != 62) {
                throw new IOException("expected > or /");
            }
            this.readChildren(reader);
            reader.readChar(60);
            reader.readChar(47);
            if (this.prefix != null) {
                String endPrefix = reader.readToken();
                if (!this.prefix.equals(endPrefix)) {
                    throw new IOException("<" + this.prefix + ":...> does not match </" + endPrefix + ":...>");
                }
                reader.readChar(58);
            }
            String endName = reader.readToken();
            reader.readChar(62);
            if (!this.name.equals(endName)) {
                throw new IOException("<..." + this.name + "> does not match </..." + endName + ">");
            }
        }
    }

    public void readAttributes(NodeReader reader) throws IOException, NamespaceException {
        Attribute attribute;
        int peek = 0;
        do {
            attribute = new Attribute();
            reader.read(attribute);
            this.attributes.append(attribute);
            reader.skipWhitespace();
        } while ((peek = reader.peek()) != 62 && peek != 47);
        attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            attribute.resolve(this);
            attribute = (Attribute)attribute.next;
        }
    }

    public void readChildren(NodeReader reader) throws IOException, NamespaceException {
        while (true) {
            StringBuffer whitespace = reader.readWhitespace();
            reader.mark(2);
            int ch1 = reader.peekRead();
            int ch2 = reader.peekRead();
            reader.reset();
            if (ch1 == -1) break;
            if (ch1 != 60) {
                reader.read(new Text(this));
                continue;
            }
            if (ch2 == 47) {
                if (whitespace == null || reader.isStrip() && !this.children.isEmpty()) break;
                reader.read(new Text(this));
                break;
            }
            if (whitespace != null && !reader.isStrip()) {
                new Text(this).setString(whitespace.toString());
            }
            if (ch2 == 33 && reader.peekString("<![CDATA[")) {
                reader.read(new CData(this));
                continue;
            }
            if (ch2 == 33 && reader.peekString("<!--")) {
                reader.read(new Comment(this));
                continue;
            }
            if (ch2 == 63) {
                reader.read(new Instruction(this));
                continue;
            }
            Element child = new Element();
            this.addChild(child);
            reader.read(child);
        }
    }

    public void write(NodeWriter writer) throws IOException {
        writer.writeIndent();
        writer.write('<');
        if (this.prefix != null && !this.prefix.equals("")) {
            writer.write(this.prefix);
            writer.write(':');
        }
        writer.write(this.name);
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            writer.write(' ');
            writer.write(attribute);
            attribute = (Attribute)attribute.next;
        }
        if (this.children.isEmpty()) {
            if (writer.getExpandEmptyElements()) {
                writer.write("></");
                if (this.prefix != null && !this.prefix.equals("")) {
                    writer.write(this.prefix);
                    writer.write(':');
                }
                writer.write(this.name);
                writer.write('>');
            } else {
                writer.write("/>");
            }
        } else {
            writer.write('>');
            this.writeChildren(writer);
            writer.write("</");
            if (this.prefix != null && !this.prefix.equals("")) {
                writer.write(this.prefix);
                writer.write(':');
            }
            writer.write(this.name);
            writer.write('>');
        }
    }

    public void writeChildren(NodeWriter writer) throws IOException {
        if (this.children.first == this.children.last && this.children.first instanceof Text) {
            int originalIndent = writer.getIndent();
            writer.setIndent(-1);
            writer.write(this.children.first);
            writer.setIndent(originalIndent);
        } else if (writer.getIndent() == -1) {
            Node child = this.children.first;
            while (child != null) {
                writer.write(child);
                child = child.next;
            }
        } else {
            writer.increaseIndent();
            Node node = this.children.first;
            while (node != null) {
                writer.writeEOL();
                writer.write(node);
                node = node.next;
            }
            writer.writeEOL();
            writer.decreaseIndent();
            writer.writeIndent();
        }
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeName() {
        return this.getTagName();
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getTagName() {
        return this.prefix == null ? this.name : this.prefix + ':' + this.name;
    }

    public String getLocalName() {
        return this.name;
    }

    public String getNamespaceURI() {
        return this.namespace;
    }

    public NamedNodeMap getAttributes() {
        return this.attributes;
    }

    public boolean hasAttribute(String name) {
        return this.getAttributeObject(name) != null;
    }

    public String getAttribute(String name) {
        return this.getAttributeValue(name);
    }

    public Attr getAttributeNode(String name) {
        return this.getAttributeObject(name);
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return this.getAttributeObject(namespaceURI, localName);
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.getAttributeObject(namespaceURI, localName) != null;
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        return this.getAttributeValue(namespaceURI, localName);
    }

    public org.w3c.dom.NodeList getElementsByTagName(String name) {
        NodeList nodes = new NodeList();
        Elements elements = this.getElements();
        while (elements.hasMoreElements()) {
            elements.next().addElementsByTagName(name, nodes);
        }
        return nodes;
    }

    void addElementsByTagName(String name, NodeList nodes) {
        if ("*".equals(name) || this.name.equals(name)) {
            nodes.append(new Selection(this));
        }
        Elements elements = this.getElements();
        while (elements.hasMoreElements()) {
            elements.next().addElementsByTagName(name, nodes);
        }
    }

    public org.w3c.dom.NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        NodeList nodes = new NodeList();
        if ("*".equals(namespaceURI)) {
            Elements elements = this.getElements();
            while (elements.hasMoreElements()) {
                elements.next().addElementsByTagName(localName, nodes);
            }
        } else {
            Elements elements = this.getElements();
            while (elements.hasMoreElements()) {
                elements.next().addElementsByTagNameNS(namespaceURI, localName, nodes);
            }
        }
        return nodes;
    }

    void addElementsByTagNameNS(String namespaceURI, String localName, NodeList nodes) {
        if ("*".equals(localName) || this.name.equals(localName)) {
            if (namespaceURI == null && this.namespace == null) {
                nodes.append(new Selection(this));
            } else if (namespaceURI != null && namespaceURI.equals(this.namespace)) {
                nodes.append(new Selection(this));
            }
        }
        Elements elements = this.getElements();
        while (elements.hasMoreElements()) {
            elements.next().addElementsByTagNameNS(namespaceURI, localName, nodes);
        }
    }

    public void removeAttributeNS(String namespaceURI, String localName) {
        this.removeAttribute(namespaceURI, localName);
    }

    public Attr removeAttributeNode(Attr oldAttr) {
        ((Attribute)oldAttr).remove();
        return oldAttr;
    }

    public Attr setAttributeNodeNS(Attr newAttr) {
        Attribute attribute = (Attribute)newAttr;
        attribute.resolve(this);
        Attribute node = (Attribute)this.attributes.first;
        while (node != null) {
            if (node.hasName(attribute.namespace, attribute.name)) {
                this.attributes.replace(node, attribute);
                return node;
            }
            node = (Attribute)node.next;
        }
        this.attributes.append(attribute);
        return null;
    }

    public Attr setAttributeNode(Attr newAttr) {
        return this.setAttributeNodeNS(newAttr);
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        String[] parts = Element.getParts(qualifiedName);
        Attribute attribute = this.getAttributeObject(namespaceURI, parts[1]);
        if (attribute == null) {
            this.setAttribute(parts[0], parts[1], value);
        } else {
            attribute.setPrefix(parts[0]);
            attribute.setValue(value);
        }
    }

    public static String[] getParts(String qualifiedName) {
        int colon = qualifiedName.indexOf(58);
        if (colon != -1) {
            return new String[]{qualifiedName.substring(0, colon), qualifiedName.substring(colon + 1)};
        }
        return new String[]{null, qualifiedName};
    }
}

