/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.xml.AttlistDecl;
import electric.xml.Comment;
import electric.xml.ElementDecl;
import electric.xml.EntityDecl;
import electric.xml.Instruction;
import electric.xml.NamespaceException;
import electric.xml.Node;
import electric.xml.NodeReader;
import electric.xml.NodeWriter;
import electric.xml.NotationDecl;
import electric.xml.Parent;
import java.io.IOException;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;

public final class DocType
extends Parent
implements DocumentType {
    private String name;
    private String systemId;
    private String publicId;

    public DocType(String name) {
        this.name = name;
    }

    public DocType(DocType docType) {
        super(docType);
        this.name = docType.name;
        this.systemId = docType.systemId;
        this.publicId = docType.publicId;
    }

    public DocType(Parent parent) {
        parent.addChild(this);
    }

    public Object clone() {
        return new DocType(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public void setIds(String publicId, String systemId) {
        this.publicId = publicId;
        this.systemId = systemId;
    }

    public void read(NodeReader reader) throws IOException, NamespaceException {
        reader.readChar(60);
        reader.readToken("<!DOCTYPE".substring(1));
        this.name = reader.readToDelimiter("[>");
        if (this.name.equals("[") || this.name.equals(">")) {
            throw new IOException("DOCTYPE is missing a name");
        }
        String next = reader.readToken();
        if (next.equals("SYSTEM")) {
            this.systemId = reader.readToDelimiter("[>", 49);
            next = reader.readToDelimiter("[>");
        } else if (next.equals("PUBLIC")) {
            this.publicId = reader.readToDelimiter("[>", 49);
            this.systemId = reader.readToDelimiter("[>", 49);
            next = reader.readToDelimiter("[>");
        }
        if (next.equals("[")) {
            block14: {
                while (true) {
                    reader.skipWhitespace();
                    int[] chars = new int[2];
                    reader.peek(chars);
                    int ch1 = chars[0];
                    int ch2 = chars[1];
                    if (ch1 == 93) break block14;
                    if (ch1 == -1) {
                        throw new IOException("could not find matching ']' in DOCTYPE");
                    }
                    if (ch1 == 37) {
                        reader.readToPattern(";", 6);
                        continue;
                    }
                    if (ch2 == 33 && reader.peekString("<!ATTLIST")) {
                        reader.read(new AttlistDecl(this));
                        continue;
                    }
                    if (ch2 == 33 && reader.peekString("<!ELEMENT")) {
                        reader.read(new ElementDecl(this));
                        continue;
                    }
                    if (ch2 == 33 && reader.peekString("<!ENTITY")) {
                        reader.read(new EntityDecl(this));
                        continue;
                    }
                    if (ch2 == 33 && reader.peekString("<!NOTATION")) {
                        reader.read(new NotationDecl(this));
                        continue;
                    }
                    if (ch2 == 33 && reader.peekString("<!--")) {
                        reader.read(new Comment(this));
                        continue;
                    }
                    if (ch2 != 63) break;
                    reader.read(new Instruction(this));
                }
                throw new IOException("illegal entry in DOCTYPE");
            }
            next = reader.readToken();
            next = reader.readToken();
        }
        if (!next.equals(">")) {
            throw new IOException("could not find matching '>' in DOCTYPE");
        }
    }

    public void write(NodeWriter writer) throws IOException {
        writer.writeIndent();
        writer.write("<!DOCTYPE");
        writer.write(' ');
        writer.write(this.name);
        if (this.publicId != null) {
            writer.write(' ');
            writer.write("PUBLIC");
            writer.write(" '");
            writer.write(this.publicId);
            writer.write("' '");
            writer.write(this.systemId);
            writer.write("'");
        } else if (this.systemId != null) {
            writer.write(' ');
            writer.write("SYSTEM");
            writer.write(" '");
            writer.write(this.systemId);
            writer.write("'");
        }
        if (!this.children.isEmpty()) {
            writer.writeEOL();
            writer.increaseIndent();
            writer.writeIndent();
            writer.write('[');
            Node node = this.children.first;
            while (node != null) {
                writer.writeEOL();
                writer.write(node);
                node = node.next;
            }
            writer.writeEOL();
            writer.writeIndent();
            writer.decreaseIndent();
            writer.write(']');
            writer.writeEOL();
        }
        writer.write(">");
    }

    public short getNodeType() {
        return 10;
    }

    public String getNodeName() {
        return this.name;
    }

    public String getInternalSubset() {
        return null;
    }

    public NamedNodeMap getEntities() {
        return null;
    }

    public NamedNodeMap getNotations() {
        return null;
    }
}

