/*
 * Decompiled with CFR 0.152.
 */
package electric.xdb.store.memory;

import electric.util.Context;
import electric.util.array.ArrayUtil;
import electric.util.list.LinkedList;
import electric.util.list.ListNode;
import electric.util.log.Log;
import electric.util.time.TimeUtil;
import electric.xdb.Data;
import electric.xdb.IDataAction;
import electric.xdb.IXDBConstants;
import electric.xdb.Id;
import electric.xdb.store.Delta;
import electric.xdb.store.IDataSelector;
import electric.xdb.store.ISource;
import electric.xdb.store.IStore;
import electric.xdb.store.IStoreListener;
import electric.xdb.store.memory.DataReaper;
import electric.xml.Element;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MemoryStore
implements IStore,
IXDBConstants {
    private int size;
    private Hashtable keyToDataArray = new Hashtable();
    private Hashtable keyToReapNode = new Hashtable();
    private LinkedList reapNodes = new LinkedList();
    private long history;
    private Hashtable tagToData = new Hashtable();
    private Hashtable dataToTag = new Hashtable();
    private int lastTag;
    private IStoreListener[] listeners = new IStoreListener[0];
    private DataReaper reaper = new DataReaper(this);
    private Context context = new Context();

    public MemoryStore() {
        this.setReaping(true);
    }

    public MemoryStore(ISource source) {
        source.loadData(this);
        this.addListener(source);
        this.setReaping(true);
    }

    public String toString() {
        return "MemoryStore( size=" + this.size + " )";
    }

    public Context getContext() {
        return this.context;
    }

    public long getHistory() {
        return this.history;
    }

    public void setHistory(long history) {
        this.history = history;
    }

    public synchronized void addListener(IStoreListener listener) {
        this.listeners = (IStoreListener[])ArrayUtil.addElement(this.listeners, listener);
    }

    public synchronized void removeListener(IStoreListener listener) {
        this.listeners = (IStoreListener[])ArrayUtil.removeElement(this.listeners, listener);
    }

    public synchronized void addDataArray(Data[] data) {
        int i = 0;
        while (i < data.length) {
            this.addData(data[i]);
            ++i;
        }
    }

    public synchronized boolean addData(Data data) {
        return this.addDataWithTag(data, 0);
    }

    public synchronized boolean addDataWithTag(Data data, int tag) {
        if (Log.isLogging(IXDBConstants.STORE_EVENT)) {
            Log.log(IXDBConstants.STORE_EVENT, (Object)(this + ": add data " + data + ", tag=" + tag));
        }
        data.flushObject();
        Data[] dataArray = (Data[])this.keyToDataArray.get(data.getKey());
        if (dataArray == null) {
            if (data.getDieAt() > 0L) {
                this.addToReapNodes(data);
            }
            dataArray = new Data[]{data};
        } else {
            Data firstData;
            long timestamp = data.getTimestamp();
            if (timestamp + this.history < (firstData = dataArray[0]).getTimestamp()) {
                return false;
            }
            if (timestamp > firstData.getTimestamp()) {
                if (firstData.getDieAt() > 0L) {
                    this.removeFromReapNodes(firstData);
                }
                if (data.getDieAt() > 0L) {
                    this.addToReapNodes(data);
                }
                int index = 0;
                while (index < dataArray.length) {
                    if (timestamp > dataArray[index].getTimestamp() + this.history) {
                        int i = index;
                        while (i < dataArray.length) {
                            this.removedData(dataArray[i]);
                            ++i;
                        }
                        break;
                    }
                    ++index;
                }
                Data[] newData = new Data[index + 1];
                newData[0] = data;
                if (index > 0) {
                    System.arraycopy(dataArray, 0, newData, 1, index);
                }
                dataArray = newData;
            } else {
                int index = 0;
                while (index < dataArray.length) {
                    long dataTimestamp = dataArray[index].getTimestamp();
                    if (timestamp == dataTimestamp) {
                        return false;
                    }
                    if (timestamp >= dataTimestamp) break;
                    ++index;
                }
                dataArray = (Data[])ArrayUtil.insertElementAt(dataArray, data, index);
            }
        }
        this.keyToDataArray.put(data.getKey(), dataArray);
        this.addedData(data, tag);
        return true;
    }

    private void addedData(Data data, int tag) {
        ++this.size;
        if (tag == 0) {
            tag = ++this.lastTag;
        } else if (tag > this.lastTag) {
            this.lastTag = tag;
        }
        Integer tagInteger = new Integer(tag);
        this.dataToTag.put(data, tagInteger);
        this.tagToData.put(tagInteger, data);
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].addedData(data, tag);
            ++i;
        }
    }

    public synchronized void removeDataForKeys(String[] keys) {
        Data[] dataArray = new Data[keys.length];
        int i = 0;
        while (i < keys.length) {
            dataArray[i] = Data.getRemoveDataWithKeyData(keys[i]);
            ++i;
        }
        this.addDataArray(dataArray);
    }

    public synchronized void removeDataForSelector(IDataSelector selector) {
        Data[] matches = this.getDataForSelector(selector);
        Data[] dataArray = new Data[matches.length];
        int i = 0;
        while (i < dataArray.length) {
            dataArray[i] = Data.getRemoveDataWithKeyData(matches[i].getKey());
            ++i;
        }
        this.addDataArray(dataArray);
    }

    public synchronized void removeAllData() {
        this.removeDataForKeys(this.getKeysForSelector(null));
    }

    private void removedData(Data data) {
        --this.size;
        Integer tagInteger = (Integer)this.dataToTag.remove(data);
        this.tagToData.remove(tagInteger);
        int j = 0;
        while (j < this.listeners.length) {
            this.listeners[j].removedData(data, tagInteger);
            ++j;
        }
    }

    public synchronized void flushDataForKeys(String[] keys) {
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            Data[] dataArray = (Data[])this.keyToDataArray.get(key);
            if (dataArray != null) {
                Data firstData = dataArray[0];
                if (firstData.getDieAt() > 0L) {
                    this.removeFromReapNodes(firstData);
                }
                int j = 0;
                while (j < dataArray.length) {
                    this.removedData(dataArray[j]);
                    ++j;
                }
                this.keyToDataArray.remove(key);
            }
            ++i;
        }
    }

    public synchronized void flushDataForSelector(IDataSelector selector) {
        Data[] data = this.getDataForSelector(selector);
        String[] keys = new String[data.length];
        int i = 0;
        while (i < data.length) {
            keys[i] = data[i].getKey();
            ++i;
        }
        this.flushDataForKeys(keys);
    }

    public synchronized void flushAllData() {
        Enumeration enumeration = this.keyToDataArray.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            Data[] dataArray = (Data[])this.keyToDataArray.get(key);
            Data firstData = dataArray[0];
            if (firstData.getDieAt() > 0L) {
                this.removeFromReapNodes(firstData);
            }
            int j = 0;
            while (j < dataArray.length) {
                this.removedData(dataArray[j]);
                ++j;
            }
        }
        this.keyToDataArray.clear();
    }

    public synchronized Data[] getAllData() {
        Vector<Data> vector = new Vector<Data>();
        Enumeration enumeration = this.keyToDataArray.elements();
        while (enumeration.hasMoreElements()) {
            Data[] dataArray = (Data[])enumeration.nextElement();
            Data latestData = dataArray[0];
            if (latestData.isRemoved()) continue;
            vector.addElement(latestData);
        }
        Object[] matches = new Data[vector.size()];
        vector.copyInto(matches);
        return matches;
    }

    protected Data getDataForId(Id id) {
        Data[] dataArray = (Data[])this.keyToDataArray.get(id.getKey());
        if (dataArray == null) {
            return null;
        }
        long timestamp = id.getTimestamp();
        int i = 0;
        while (i < dataArray.length) {
            if (dataArray[i].getTimestamp() >= timestamp) {
                return dataArray[i];
            }
            ++i;
        }
        return null;
    }

    public synchronized Data getDataForKey(String key) {
        Data[] dataArray = (Data[])this.keyToDataArray.get(key);
        if (dataArray == null) {
            return null;
        }
        Data latestData = dataArray[0];
        return latestData.isRemoved() ? null : latestData;
    }

    public synchronized Data[] getAllDataForKey(String key) {
        return (Data[])this.keyToDataArray.get(key);
    }

    public synchronized Data[] getDataForKeys(String[] keys) {
        Vector<Data> vector = new Vector<Data>();
        int i = 0;
        while (i < keys.length) {
            Data data = this.getDataForKey(keys[i]);
            if (data != null) {
                vector.addElement(data);
            }
            ++i;
        }
        Object[] dataArray = new Data[vector.size()];
        vector.copyInto(dataArray);
        return dataArray;
    }

    public synchronized Data[] getDataForIds(Id[] ids) {
        Vector<Data> vector = new Vector<Data>();
        int i = 0;
        while (i < ids.length) {
            Data data = this.getDataForId(ids[i]);
            if (data != null) {
                vector.addElement(data);
            }
            ++i;
        }
        Object[] dataArray = new Data[vector.size()];
        vector.copyInto(dataArray);
        return dataArray;
    }

    public synchronized Data[] getDataForSelector(IDataSelector selector) {
        if (Log.isLogging(IXDBConstants.STORE_EVENT)) {
            Log.log(IXDBConstants.STORE_EVENT, (Object)(this + ": find data matching " + selector));
        }
        Vector<Data> vector = new Vector<Data>();
        Enumeration enumeration = this.keyToDataArray.elements();
        while (enumeration.hasMoreElements()) {
            Data[] dataArray = (Data[])enumeration.nextElement();
            Data latestData = dataArray[0];
            if (latestData.isRemoved() || !selector.selects(latestData)) continue;
            vector.addElement(latestData);
        }
        Object[] matches = new Data[vector.size()];
        vector.copyInto(matches);
        return matches;
    }

    public int getDataCount() {
        return this.size;
    }

    public synchronized int getDataCountForSelector(IDataSelector selector) {
        int count = 0;
        Enumeration enumeration = this.keyToDataArray.elements();
        while (enumeration.hasMoreElements()) {
            Data[] dataArray = (Data[])enumeration.nextElement();
            Data latestData = dataArray[0];
            if (latestData.isRemoved() || !selector.selects(latestData)) continue;
            ++count;
        }
        return count;
    }

    public int getLastTag() {
        return this.lastTag;
    }

    public String[] getAllKeys() {
        return this.getKeysForSelector(null);
    }

    public synchronized String[] getKeysForSelector(IDataSelector selector) {
        Vector<String> keys = new Vector<String>();
        Enumeration enumeration = this.keyToDataArray.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            Data[] dataArray = (Data[])this.keyToDataArray.get(key);
            Data latestData = dataArray[0];
            if (latestData.isRemoved() || selector != null && !selector.selects(latestData)) continue;
            keys.addElement(key);
        }
        Object[] array = new String[keys.size()];
        keys.copyInto(array);
        return array;
    }

    public synchronized void dieUpdate(String[] keys, long dieAt) {
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            Data before = this.getDataForKey(key);
            if (before != null) {
                Element envelope = before.getEnvelopeCopy();
                envelope.getElement("Header").setLong("dieAt", dieAt);
                Data after = new Data(envelope);
                this.addData(after);
            }
            ++i;
        }
    }

    public synchronized void perform(IDataAction action) {
        Enumeration enumeration = this.keyToDataArray.elements();
        while (enumeration.hasMoreElements()) {
            Data[] dataArray = (Data[])enumeration.nextElement();
            Data latestData = dataArray[0];
            if (latestData.isRemoved()) continue;
            action.perform(latestData);
        }
    }

    public synchronized Delta getDelta(int startTag, IDataSelector selector) {
        Vector<Id> ids = new Vector<Id>();
        int i = startTag;
        while (i <= this.lastTag) {
            Data data = (Data)this.tagToData.get(new Integer(i));
            if (data != null && (selector == null || selector.selects(data))) {
                ids.addElement(data.getId());
            }
            ++i;
        }
        if (ids.isEmpty()) {
            return new Delta(null, this.lastTag);
        }
        Object[] idsArray = new Id[ids.size()];
        ids.copyInto(idsArray);
        return new Delta((Id[])idsArray, this.lastTag);
    }

    public synchronized Id[] getIdsForSelector(IDataSelector selector) {
        Vector<Id> ids = new Vector<Id>();
        Enumeration enumeration = this.keyToDataArray.elements();
        while (enumeration.hasMoreElements()) {
            Data[] dataArray = (Data[])enumeration.nextElement();
            Data latestData = dataArray[0];
            if (latestData.isRemoved() || !selector.selects(latestData)) continue;
            ids.addElement(latestData.getId());
        }
        Object[] idsArray = new Id[ids.size()];
        ids.copyInto(idsArray);
        return idsArray;
    }

    public synchronized Id[] getMissingIds(Id[] ids) {
        Vector<Id> vector = new Vector<Id>();
        int i = 0;
        while (i < ids.length) {
            Data[] dataArray;
            Id id = ids[i];
            if (this.getDataForId(id) == null && ((dataArray = (Data[])this.keyToDataArray.get(id.getKey())) == null || id.getTimestamp() + this.history >= dataArray[0].getTimestamp())) {
                vector.addElement(id);
            }
            ++i;
        }
        if (vector.isEmpty()) {
            return null;
        }
        Object[] missing = new Id[vector.size()];
        vector.copyInto(missing);
        return missing;
    }

    public void setReaping(boolean flag) {
        this.reaper.setReaping(flag);
    }

    public boolean isReaping() {
        return this.reaper.isReaping();
    }

    private void addToReapNodes(Data newData) {
        long dieAt = newData.getDieAt();
        ListNode newNode = new ListNode(newData);
        this.keyToReapNode.put(newData.getKey(), newNode);
        boolean first = true;
        ListNode node = this.reapNodes.getFirst();
        while (node != null) {
            Data data = (Data)node.getObject();
            if (dieAt < data.getDieAt()) {
                node.setPrevious(newNode);
                this.reaper.update();
                return;
            }
            node = node.getNext();
            first = false;
        }
        this.reapNodes.add(newNode);
        if (first) {
            this.reaper.update();
        }
    }

    private void removeFromReapNodes(Data data) {
        ListNode node = (ListNode)this.keyToReapNode.remove(data.getKey());
        if (node != null) {
            node.remove();
        }
    }

    public synchronized long reap() {
        if (Log.isLogging(IXDBConstants.STORE_EVENT)) {
            Log.log(IXDBConstants.STORE_EVENT, (Object)(this + ": reap"));
        }
        long now = TimeUtil.now();
        ListNode node = this.reapNodes.getFirst();
        while (node != null) {
            Data data = (Data)node.getObject();
            if (data.getDieAt() > now) {
                return data.getDieAt();
            }
            String key = data.getKey();
            this.keyToReapNode.remove(key);
            node.remove();
            Data[] dataArray = (Data[])this.keyToDataArray.remove(key);
            int i = 0;
            while (i < dataArray.length) {
                this.removedData(dataArray[i]);
                ++i;
            }
            node = node.getNext();
        }
        return -1L;
    }

    public synchronized void write(PrintStream writer) {
        writer.println("****************************************************");
        writer.println();
        writer.println("size= " + this.size);
        writer.println();
        int index = 0;
        Enumeration enumeration = this.keyToDataArray.elements();
        while (enumeration.hasMoreElements()) {
            Data[] dataArray = (Data[])enumeration.nextElement();
            int i = 0;
            while (i < dataArray.length) {
                writer.println(index++ + ":" + dataArray[i]);
                writer.println();
                ++i;
            }
        }
        writer.println("****************************************************");
        writer.println();
    }
}

