/*
 * Decompiled with CFR 0.152.
 */
package electric.xdb.store.factory.file;

import electric.glue.IGLUELoggingConstants;
import electric.util.file.FileUtil;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.xdb.server.XDBServer;
import electric.xdb.store.IStore;
import electric.xdb.store.factory.IStoreFactory;
import electric.xdb.store.filesource.FileSource;
import electric.xdb.store.memory.MemoryStore;
import java.io.File;

public class FileStoreFactory
implements IStoreFactory,
IGLUELoggingConstants {
    private String root;
    private boolean delete;

    public FileStoreFactory(String root, boolean delete) {
        this.root = root;
        this.delete = delete;
        File directory = new File(root);
        if (delete) {
            if (directory.exists()) {
                FileUtil.delete(directory, true);
            }
            directory.mkdirs();
        } else if (directory.exists()) {
            File[] groupDirectories = FileUtil.listFiles(directory);
            int i = 0;
            while (i < groupDirectories.length) {
                FileStoreFactory.loadDataFrom(groupDirectories[i]);
                ++i;
            }
        } else {
            directory.mkdirs();
        }
    }

    public IStore newStore(String name, String group) {
        String path = this.root + File.separator + group;
        FileSource dataSource = new FileSource(path, this.delete);
        return new MemoryStore(dataSource);
    }

    private static void loadDataFrom(File directory) {
        FileSource dataSource = new FileSource(directory.getAbsolutePath(), false);
        MemoryStore dataStore = new MemoryStore(dataSource);
        if (Log.isLogging(ILoggingConstants.STARTUP_EVENT)) {
            Log.log(ILoggingConstants.STARTUP_EVENT, (Object)("loaded " + dataStore.getDataCount() + " records from " + directory));
        }
        XDBServer server = new XDBServer(dataStore);
        if (Log.isLogging(ILoggingConstants.STARTUP_EVENT)) {
            Log.log(ILoggingConstants.STARTUP_EVENT, (Object)("restart " + server));
        }
        server.restart();
    }
}

