/*
 * Decompiled with CFR 0.152.
 */
package electric.xdb;

import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.xdb.server.Member;

public class ServerInfo {
    private String name;
    private String url;
    private int dataCount;
    private int lastTag;
    private long history;
    private boolean leader;
    private Member[] members = new Member[0];
    private transient boolean modified;
    private transient boolean membersChanged = true;
    private transient String host;

    public String toString() {
        return "ServerInfo( name=" + this.name + ", url=" + this.url + ", dataCount=" + this.dataCount + ", lastTag=" + this.lastTag + ", history=" + this.history + ", leader=" + this.leader + ", members=" + this.getMembersString() + " )";
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ServerInfo)) {
            return false;
        }
        return ((ServerInfo)object).name.equals(this.name);
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        if (url.equals(this.url)) {
            return;
        }
        this.url = url;
        this.modified();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name.equals(this.name)) {
            return;
        }
        this.name = name;
        this.modified();
    }

    public void setLeader(boolean leader) {
        if (this.leader == leader) {
            return;
        }
        this.leader = leader;
        this.modified();
    }

    public boolean isLeader() {
        return this.leader;
    }

    public int getDataCount() {
        return this.dataCount;
    }

    public void setDataCount(int dataCount) {
        if (dataCount == this.dataCount) {
            return;
        }
        this.dataCount = dataCount;
        this.modified();
    }

    public int getLastTag() {
        return this.lastTag;
    }

    public void setLastTag(int lastTag) {
        if (lastTag == this.lastTag) {
            return;
        }
        this.lastTag = lastTag;
        this.modified();
    }

    public long getHistory() {
        return this.history;
    }

    public void setHistory(long history) {
        if (history == this.history) {
            return;
        }
        this.history = history;
        this.modified();
    }

    public synchronized Member getMemberWithName(String name) {
        int i = 0;
        while (i < this.members.length) {
            if (this.members[i].getName().equals(name)) {
                return this.members[i];
            }
            ++i;
        }
        return null;
    }

    public synchronized Member getMemberWithURL(String url) {
        int i = 0;
        while (i < this.members.length) {
            if (this.members[i].getURL().equals(url)) {
                return this.members[i];
            }
            ++i;
        }
        return null;
    }

    public synchronized Member addMember(String name, String url) {
        Member member = this.getMemberWithName(name);
        if (member != null) {
            member.setURL(url);
        } else {
            member = new Member(name, url);
            this.addMember(member);
        }
        return member;
    }

    private synchronized void addMember(Member member) {
        this.members = (Member[])ArrayUtil.addElement(this.members, member);
        this.modified();
        this.membersChanged = true;
    }

    public Member[] getMembers() {
        return this.members;
    }

    public boolean hasMembers() {
        return this.members.length > 0;
    }

    public boolean hasOnlineMembers() {
        int i = 0;
        while (i < this.members.length) {
            if (this.members[i].isOnline()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized int getGroupSize() {
        int count = 1;
        int i = 0;
        while (i < this.members.length) {
            if (this.members[i].isOnline()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public synchronized String getMembersString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        int i = 0;
        while (i < this.members.length) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.members[i].toString());
            ++i;
        }
        buffer.append("}");
        return buffer.toString();
    }

    public synchronized boolean isGroupChanged() {
        if (this.membersChanged) {
            return true;
        }
        int i = 0;
        while (i < this.members.length) {
            if (this.members[i].isStateChanged()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized void resetGroupChanged() {
        this.membersChanged = false;
        int i = 0;
        while (i < this.members.length) {
            this.members[i].resetStateChanged();
            ++i;
        }
    }

    public synchronized String getHost() {
        if (this.host != null) {
            return this.host;
        }
        try {
            this.host = new XURL(this.url).getHostAndPortXURL().toString();
        }
        catch (Exception exception) {}
        return this.host;
    }

    private void modified() {
        this.modified = true;
    }

    public void resetModified() {
        this.modified = false;
        int i = 0;
        while (i < this.members.length) {
            this.members[i].resetModified();
            ++i;
        }
    }

    public boolean isModified() {
        if (this.modified) {
            return true;
        }
        int i = 0;
        while (i < this.members.length) {
            if (this.members[i].isModified()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

