/*
 * Decompiled with CFR 0.152.
 */
package electric.wsdl.util;

import electric.glue.IGLUEContextConstants;
import electric.soap.ISOAPConstants;
import electric.soap.wsdl.SOAPBinding;
import electric.util.Context;
import electric.wsdl.IWSDLConstants;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.IXPath;
import electric.xml.xpath.TMEXPath;

public class EncodingStyleUtil
implements ISOAPConstants,
IWSDLConstants,
IGLUEContextConstants {
    private static final String SOAP12_PATH = "wsdl:definitions/wsdl:binding/wsdl:operation/*/soap12:body";
    private static final String SOAP11_PATH = "wsdl:definitions/wsdl:binding/wsdl:operation/*/soap:body";

    public static String findEncodingStyle(Context context, Document wsdlDocument) {
        String encodingStyle = context.getStringProperty("soapEncodingStyle");
        if (encodingStyle != null) {
            return encodingStyle;
        }
        TMEXPath encodingStyle12Path = new TMEXPath(SOAP12_PATH);
        encodingStyle = EncodingStyleUtil.findEncodingStyle(encodingStyle12Path, wsdlDocument);
        if (encodingStyle != null) {
            return encodingStyle;
        }
        TMEXPath encoding11Style11Path = new TMEXPath(SOAP11_PATH);
        encodingStyle = EncodingStyleUtil.findEncodingStyle(encoding11Style11Path, wsdlDocument);
        if (encodingStyle == null) {
            encodingStyle = "";
        }
        return encodingStyle;
    }

    public static String findEncodingStyle(IXPath encodingStylePath, Document wsdlDocument) {
        encodingStylePath.setNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        encodingStylePath.setNamespace("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
        encodingStylePath.setNamespace("soap12", "http://schemas.xmlsoap.org/wsdl/soap12/");
        Elements soapBodies = encodingStylePath.getElements(wsdlDocument);
        String encodingStyle = null;
        while (soapBodies.hasMoreElements()) {
            String useAttribute;
            Element body = (Element)soapBodies.nextElement();
            if (body == null || (useAttribute = body.getAttribute("use")) == null) continue;
            if (useAttribute.equals("literal")) {
                encodingStyle = "";
                break;
            }
            if (!useAttribute.equals("encoded")) continue;
            String encodingStyleAttribute = body.getAttribute("encodingStyle");
            if (encodingStyleAttribute == null) {
                encodingStyleAttribute = body.getNamespace().equals("http://schemas.xmlsoap.org/wsdl/soap12/") ? "http://www.w3.org/2003/05/soap-encoding" : "http://schemas.xmlsoap.org/soap/encoding/";
            }
            if (encodingStyleAttribute.equals("http://www.w3.org/2003/05/soap-encoding")) {
                encodingStyle = "http://www.w3.org/2003/05/soap-encoding";
                break;
            }
            if (!encodingStyleAttribute.equals("http://schemas.xmlsoap.org/soap/encoding/")) continue;
            encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
            break;
        }
        return encodingStyle;
    }

    public static String calculateEncodingStyle(Context context) {
        String soapVersion = context.getStringProperty("soapVersion", "http://schemas.xmlsoap.org/soap/envelope/");
        String use = context.getStringProperty("use");
        if (use == null) {
            String style = context.getStringProperty("style");
            if (style == null) {
                style = SOAPBinding.getDefaultStyle();
            }
            use = style.equalsIgnoreCase("rpc") ? "encoded" : "literal";
        }
        if (use.equals("literal")) {
            return "";
        }
        if (soapVersion != null && soapVersion.equals("http://www.w3.org/2003/05/soap-envelope")) {
            return "http://www.w3.org/2003/05/soap-encoding";
        }
        return "http://schemas.xmlsoap.org/soap/encoding/";
    }
}

