/*
 * Decompiled with CFR 0.152.
 */
package electric.wsdl.generator;

import electric.service.descriptor.MethodDescriptor;
import electric.util.Context;
import electric.util.XURL;
import electric.util.reflect.Reflect;
import electric.wsdl.Service;
import electric.wsdl.WSDL;
import electric.wsdl.WSDLException;
import electric.wsdl.personality.IWSDLPersonality;
import electric.wsdl.personality.explicit.ExplicitWSDLPersonality;
import electric.wsdl.personality.tme.TMEWSDLPersonality;
import electric.wsdl.util.EncodingStyleUtil;
import electric.xml.io.Namespaces;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaProperties;
import java.lang.reflect.Method;

public class WSDLGenerator {
    private static IWSDLPersonality defaultPersonality = new TMEWSDLPersonality();

    public static WSDL getWSDL(XURL[] endpoints, String documentation, Context context, Class javaClass, Class[] interfaces) throws SchemaException, WSDLException {
        WSDL wsdl = new WSDL();
        IWSDLPersonality personality = (IWSDLPersonality)Context.getProperty(context, "wsdlPersonality");
        if (personality == null) {
            personality = defaultPersonality;
        }
        if (!(personality instanceof ExplicitWSDLPersonality)) {
            personality = new ExplicitWSDLPersonality(personality);
        }
        wsdl.setPersonality(personality);
        if (javaClass == null) {
            wsdl.setName(personality.getWSDLName(interfaces[0], context));
            wsdl.setTargetNamespace(personality.getTargetNamespace(interfaces[0], context));
        } else {
            wsdl.setName(personality.getWSDLName(javaClass, context));
            wsdl.setTargetNamespace(personality.getTargetNamespace(javaClass, context));
        }
        String encodingStyle = EncodingStyleUtil.calculateEncodingStyle(context);
        wsdl.setEncodingStyle(encodingStyle);
        wsdl.setNamespaces(new Namespaces(SchemaProperties.getDefaultSchema(), encodingStyle));
        Service service = WSDLGenerator.getService(wsdl, endpoints, documentation);
        Method[] javaClassMethods = null;
        if (javaClass != null) {
            javaClassMethods = javaClass.getMethods();
            interfaces = Reflect.filter(Reflect.getInterfaces(javaClass), interfaces);
        }
        int i = 0;
        while (i < interfaces.length) {
            Method[] methods = null;
            methods = javaClass != null ? Reflect.getMethodsImplementedBy(javaClassMethods, new Class[]{interfaces[i]}) : interfaces[i].getMethods();
            MethodDescriptor[] descriptors = new MethodDescriptor[methods.length];
            int j = 0;
            while (j < methods.length) {
                descriptors[j] = new MethodDescriptor(methods[j]);
                ++j;
            }
            String portTypeName = personality.getPortTypeName(interfaces[i], context);
            wsdl.addPortType(portTypeName, descriptors, service, endpoints, context);
            ++i;
        }
        return wsdl;
    }

    public static WSDL getWSDL(XURL[] endpoints, String documentation, Context context, MethodDescriptor[] methods, Class javaClass) throws SchemaException, WSDLException {
        WSDL wsdl = new WSDL();
        IWSDLPersonality personality = (IWSDLPersonality)Context.getProperty(context, "wsdlPersonality");
        if (personality == null) {
            personality = defaultPersonality;
        }
        if (!(personality instanceof ExplicitWSDLPersonality)) {
            personality = new ExplicitWSDLPersonality(personality);
        }
        wsdl.setPersonality(personality);
        wsdl.setName(personality.getWSDLName(javaClass, context));
        wsdl.setTargetNamespace(personality.getTargetNamespace(javaClass, context));
        String encodingStyle = EncodingStyleUtil.calculateEncodingStyle(context);
        wsdl.setEncodingStyle(encodingStyle);
        wsdl.setNamespaces(new Namespaces(SchemaProperties.getDefaultSchema(), encodingStyle));
        Service service = WSDLGenerator.getService(wsdl, endpoints, documentation);
        String portTypeName = personality.getPortTypeName(javaClass, context);
        wsdl.addPortType(portTypeName, methods, service, endpoints, context);
        return wsdl;
    }

    public static IWSDLPersonality getDefaultPersonality() {
        return defaultPersonality;
    }

    public static void setDefaultPersonality(IWSDLPersonality personality) {
        defaultPersonality = personality;
    }

    private static Service getService(WSDL wsdl, XURL[] endpoints, String documentation) {
        if (endpoints.length == 0) {
            return null;
        }
        wsdl.setPath(endpoints[0].toString() + ".wsdl");
        Service service = new Service(wsdl, wsdl.getTargetNamespace(), documentation);
        wsdl.getNamespaces().addItem(service);
        return service;
    }
}

