/*
 * Decompiled with CFR 0.152.
 */
package electric.wsdl;

import electric.util.array.ArrayUtil;
import electric.util.named.IQNamed;
import electric.wsdl.IWSDLConstants;
import electric.wsdl.Operation;
import electric.wsdl.WSDL;
import electric.wsdl.WSDLException;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.io.Type;
import electric.xml.io.schema.SchemaException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class PortType
implements IQNamed,
IWSDLConstants {
    private String targetNamespace;
    private String name;
    private Operation[] operations = new Operation[0];

    public PortType(WSDL wsdl, String targetNamespace, Element portType) throws WSDLException, SchemaException {
        this.targetNamespace = targetNamespace;
        this.name = portType.getAttributeValue("name");
        if (this.name == null) {
            throw new WSDLException("<portType> is missing name attribute");
        }
        Elements operations = portType.getElements("operation");
        while (operations.hasMoreElements()) {
            this.addOperation(new Operation(wsdl, operations.next()));
        }
    }

    public PortType(String targetNamespace, String name) {
        this.targetNamespace = targetNamespace;
        this.name = name;
    }

    public String toString() {
        return "PortType( " + this.targetNamespace + ":" + this.name + " )";
    }

    public String getNamespace() {
        return this.targetNamespace;
    }

    public String getName() {
        return this.name;
    }

    public Operation[] getOperations() {
        return this.operations;
    }

    public void addOperation(Operation operation) {
        this.operations = (Operation[])ArrayUtil.addElement(this.operations, operation);
    }

    public Operation[] getOperationsWithName(String name) {
        Operation[] array = new Operation[]{};
        int i = 0;
        while (i < this.operations.length) {
            if (name.equals(this.operations[i].getName())) {
                array = (Operation[])ArrayUtil.addElement(array, this.operations[i]);
            }
            ++i;
        }
        return array;
    }

    public Enumeration getTypes() throws SchemaException {
        Vector dependencies = new Vector();
        int i = 0;
        while (i < this.operations.length) {
            this.operations[i].addDependencies(dependencies);
            ++i;
        }
        Hashtable closure = new Hashtable();
        int i2 = 0;
        while (i2 < dependencies.size()) {
            this.addDependencies(closure, (Type)dependencies.elementAt(i2));
            ++i2;
        }
        return closure.elements();
    }

    private void addDependencies(Hashtable closure, Type type) throws SchemaException {
        if (closure.get(type) != null) {
            return;
        }
        closure.put(type, type);
        Vector dependencies = new Vector();
        type.addDependencies(dependencies);
        Enumeration enumeration = dependencies.elements();
        while (enumeration.hasMoreElements()) {
            this.addDependencies(closure, (Type)enumeration.nextElement());
        }
    }

    public void writeWSDL(Element definitions) {
        String wsdlPrefix = definitions.getNamespacePrefix("http://schemas.xmlsoap.org/wsdl/");
        Element portType = definitions.addElement(wsdlPrefix, "portType");
        portType.setAttribute("name", this.name);
        int i = 0;
        while (i < this.operations.length) {
            this.operations[i].writeWSDL(portType);
            ++i;
        }
    }
}

