/*
 * Decompiled with CFR 0.152.
 */
package electric.wsdl;

import electric.wsdl.IWSDLConstants;
import electric.wsdl.Message;
import electric.wsdl.WSDLException;
import electric.xml.Element;
import electric.xml.io.Type;
import electric.xml.io.complex.ComplexType;
import electric.xml.io.schema.SchemaElement;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.simple.AnyType;

public final class Part
implements IWSDLConstants {
    private Message message;
    private String name;
    private SchemaElement element;
    private Type type;
    private String documentation;

    public Part(Message message, Element part) throws WSDLException, SchemaException {
        this.message = message;
        this.name = part.getAttributeValue("name");
        if (this.name == null) {
            throw new WSDLException("<part> is missing name attribute");
        }
        this.documentation = part.getTextString("documentation");
        String typeName = part.getAttributeValue("type");
        String elementName = part.getAttributeValue("element");
        if (typeName != null) {
            this.setType(part, message, typeName);
        } else if (elementName != null) {
            this.setElement(part, message, elementName);
        } else {
            this.type = new AnyType();
        }
    }

    public Part(String name, Type type, String documentation) throws SchemaException {
        this.name = name;
        if (type.useSchemaElement()) {
            this.element = type.getSchemaElement();
        }
        this.type = type;
        this.documentation = documentation;
    }

    public Part(String name, SchemaElement element, String documentation) throws SchemaException {
        this.name = name;
        this.element = element;
        this.type = element.getType();
        this.documentation = documentation;
    }

    public String toString() {
        if (this.element != null) {
            return "Part( name=" + this.name + ", element=" + this.element + " )";
        }
        return "Part( name=" + this.name + ", type=" + this.type + " )";
    }

    public String getName() {
        return this.name;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public Type getType() {
        return this.type;
    }

    public Type getImplicitType() throws SchemaException {
        if (this.type != null) {
            return this.type;
        }
        if (this.element != null) {
            return this.element.getType();
        }
        return null;
    }

    public void setType(Type type) {
        this.type = type;
    }

    private void setType(Element part, Message message, String typeName) throws SchemaException {
        typeName = part.getQName(typeName);
        this.type = message.getWSDL().getType(typeName);
    }

    public SchemaElement getSchemaElement() {
        return this.element;
    }

    private void setElement(Element part, Message message, String elementName) throws SchemaException {
        elementName = part.getQName(elementName);
        this.element = message.getWSDL().getElement(elementName);
        this.type = this.element.getType();
        if (this.type instanceof ComplexType && this.type.isAnonymous()) {
            this.type.setInhibit(true);
        }
    }

    public void writeWSDL(Element message) {
        String wsdlPrefix = message.getNamespacePrefix("http://schemas.xmlsoap.org/wsdl/");
        Element part = message.addElement(wsdlPrefix, "part");
        part.setAttribute("name", this.name);
        if (this.documentation != null) {
            part.setString(wsdlPrefix, "documentation", this.documentation);
        }
        if (this.element != null) {
            part.setAttribute("element", this.element.getName(part));
        } else {
            part.setAttribute("type", this.type.getName(part));
        }
    }
}

