/*
 * Decompiled with CFR 0.152.
 */
package electric.wsdl;

import electric.holder.Holders;
import electric.service.descriptor.MethodDescriptor;
import electric.soap.wsdl.SOAPBinding;
import electric.util.array.ArrayUtil;
import electric.util.async.Async;
import electric.util.reflect.JavaComment;
import electric.util.reflect.JavaMethod;
import electric.util.reflect.MethodFinder;
import electric.wsdl.IWSDLConstants;
import electric.wsdl.Message;
import electric.wsdl.MessageDecl;
import electric.wsdl.Part;
import electric.wsdl.WSDL;
import electric.wsdl.WSDLException;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.io.Type;
import electric.xml.io.complex.ComplexContent;
import electric.xml.io.complex.ComplexType;
import electric.xml.io.exceptions.ThrowableType;
import electric.xml.io.model.IModel;
import electric.xml.io.model.Sequence;
import electric.xml.io.schema.Schema;
import electric.xml.io.schema.SchemaElement;
import electric.xml.io.schema.SchemaException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Operation
implements IWSDLConstants {
    private static boolean oldStyleFaults = false;
    private static boolean processFaults = true;
    private WSDL wsdl;
    private String name;
    private String[] argNames;
    private String documentation;
    private MessageDecl input;
    private MessageDecl output;
    private MessageDecl[] faults;
    static /* synthetic */ Class class$electric$soap$SOAPException;
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$electric$wsdl$Message;

    public Operation(WSDL wsdl, Element operation) throws WSDLException, SchemaException {
        this.wsdl = wsdl;
        this.name = operation.getAttributeValue("name");
        if (this.name == null) {
            throw new WSDLException("<operation> is missing name attribute");
        }
        this.documentation = operation.getTextString("documentation");
        String parameterOrder = operation.getAttributeValue("parameterOrder");
        if (parameterOrder != null) {
            this.setArgNames(parameterOrder);
        }
        this.input = this.getParam(operation, "input");
        this.output = this.getParam(operation, "output");
        if (processFaults) {
            this.faults = this.getFaults(operation);
        }
    }

    public Operation(WSDL wsdl, String namespace, Method method, int index, String suffix, String resultPartName, boolean rpc) throws WSDLException, SchemaException {
        this(wsdl, namespace, method, index, suffix, resultPartName, rpc, method.getName());
    }

    public Operation(WSDL wsdl, String namespace, MethodDescriptor descriptor, int index, String suffix, String resultPartName, boolean rpc) throws WSDLException, SchemaException {
        this(wsdl, namespace, descriptor.getMethod(), index, suffix, resultPartName, rpc, descriptor.getName());
    }

    public Operation(WSDL wsdl, String namespace, Method method, int index, String suffix, String resultPartName, boolean rpc, String name) throws WSDLException, SchemaException {
        int i;
        this.wsdl = wsdl;
        this.name = name;
        Class[] parameterClasses = method.getParameterTypes();
        String[] argDocs = new String[parameterClasses.length];
        JavaMethod javaMethod = MethodFinder.getMethod(method);
        if (javaMethod != null) {
            JavaComment comment = javaMethod.getComment();
            this.documentation = comment.getText();
            this.argNames = javaMethod.getArgNames();
            i = 0;
            while (i < this.argNames.length) {
                argDocs[i] = comment.get("param " + this.argNames[i]);
                ++i;
            }
        } else {
            this.argNames = new String[parameterClasses.length];
            int i2 = 0;
            while (i2 < parameterClasses.length) {
                this.argNames[i2] = "arg" + i2;
                ++i2;
            }
        }
        boolean isAsync = Async.isAsyncSignature(parameterClasses);
        if (isAsync) {
            parameterClasses = (Class[])ArrayUtil.removeElementAt(parameterClasses, parameterClasses.length - 1);
            argDocs = (String[])ArrayUtil.removeElementAt(argDocs, argDocs.length - 1);
            this.argNames = (String[])ArrayUtil.removeElementAt(this.argNames, this.argNames.length - 1);
            if (method.getReturnType() != Void.TYPE) {
                throw new WSDLException("invalid method signature in " + name + ". it is illegal to return a value from the async operations");
            }
            i = 0;
            while (i < parameterClasses.length) {
                if (Holders.isHolder(parameterClasses[i])) {
                    throw new WSDLException("invalid arguments in method " + name + ". one way methods must not contain Out or InOut holders");
                }
                ++i;
            }
        }
        if (rpc) {
            this.addRpcStyle(method, javaMethod, parameterClasses, argDocs, namespace, index, suffix, resultPartName, isAsync);
        } else {
            this.addDocumentStyle(method, javaMethod, parameterClasses, argDocs, namespace, index, suffix, resultPartName, isAsync);
        }
    }

    public String toString() {
        return "Operation( " + this.name + ", in= " + this.input + ", out= " + this.output + " )";
    }

    private void addRpcStyle(Method method, JavaMethod javaMethod, Class[] parameterClasses, String[] argDocs, String namespace, int index, String suffix, String resultPartName, boolean isAsync) throws SchemaException {
        Part[] inputs = new Part[]{};
        int i = 0;
        while (i < parameterClasses.length) {
            if (!Holders.isOut(parameterClasses[i])) {
                Type argType = this.wsdl.getTypeForJavaClass(parameterClasses[i]);
                Part part = new Part(this.argNames[i], argType, argDocs[i]);
                inputs = (Part[])ArrayUtil.addElement(inputs, part);
            }
            ++i;
        }
        Message inputMessage = new Message(this.wsdl, namespace, this.name + index + suffix + "In", inputs);
        this.input = new MessageDecl(inputMessage, inputMessage.getName(), "input");
        this.wsdl.add(inputMessage);
        Part[] outputs = new Part[]{};
        if (method.getReturnType() != Void.TYPE) {
            String returnDoc = javaMethod == null ? null : javaMethod.getComment().get("return");
            Type returnType = this.wsdl.getTypeForJavaClass(method.getReturnType());
            Part part = new Part(resultPartName, returnType, returnDoc);
            outputs = (Part[])ArrayUtil.addElement(outputs, part);
        }
        if (processFaults) {
            this.addExceptions(method, index, namespace);
        }
        int i2 = 0;
        while (i2 < parameterClasses.length) {
            Class javaClass = parameterClasses[i2];
            if (Holders.isHolder(javaClass)) {
                Type argType = this.wsdl.getTypeForJavaClass(javaClass);
                Part part = new Part(this.argNames[i2], argType, argDocs[i2]);
                outputs = (Part[])ArrayUtil.addElement(outputs, part);
            }
            ++i2;
        }
        if (!isAsync) {
            Message outputMessage = new Message(this.wsdl, namespace, this.name + index + suffix + "Out", outputs);
            this.output = new MessageDecl(outputMessage, outputMessage.getName(), "output");
            this.wsdl.add(outputMessage);
        } else {
            this.output = MessageDecl.getVoid();
        }
    }

    public void addExceptions(Method method, int index, String namespace) throws SchemaException {
        Class<?>[] exceptions = method.getExceptionTypes();
        this.faults = new MessageDecl[0];
        int i = 0;
        while (i < exceptions.length) {
            this.addException(exceptions[i], index, i, namespace);
            ++i;
        }
    }

    private void addException(Class javaClass, int index, int i, String namespace) throws SchemaException {
        if (oldStyleFaults && (class$electric$soap$SOAPException == null ? (class$electric$soap$SOAPException = Operation.class$("electric.soap.SOAPException")) : class$electric$soap$SOAPException).isAssignableFrom(javaClass)) {
            return;
        }
        Type exceptionType = this.wsdl.getTypeForJavaClass(javaClass);
        if (exceptionType instanceof ComplexType) {
            ComplexContent exceptionContent;
            ComplexType exceptionComplex = (ComplexType)exceptionType;
            if (exceptionComplex.getModel() instanceof ComplexContent && (exceptionContent = (ComplexContent)exceptionComplex.getModel()).getBaseType().getJavaClass() == (class$java$lang$Exception == null ? (class$java$lang$Exception = Operation.class$("java.lang.Exception")) : class$java$lang$Exception)) {
                IModel contentModel = exceptionContent.getModel();
                exceptionComplex.replaceModel(contentModel);
            }
        } else if (exceptionType instanceof ThrowableType) {
            ((ThrowableType)exceptionType).setGenerateSchema(true);
        }
        Part part = new Part(exceptionType.getName(), exceptionType, null);
        Part[] faultParts = new Part[]{};
        faultParts = (Part[])ArrayUtil.addElement(faultParts, part);
        String messageName = this.name + index + "Fault" + i;
        messageName = exceptionType.getName();
        Message faultMessage = null;
        try {
            faultMessage = (Message)this.wsdl.getNamespaces().getItem(namespace, messageName, class$electric$wsdl$Message == null ? (class$electric$wsdl$Message = Operation.class$("electric.wsdl.Message")) : class$electric$wsdl$Message);
        }
        catch (SchemaException exception) {
            // empty catch block
        }
        if (faultMessage == null) {
            faultMessage = new Message(this.wsdl, namespace, messageName, faultParts);
            this.wsdl.add(faultMessage);
        }
        MessageDecl faultMessageDecl = new MessageDecl(faultMessage, faultMessage.getName(), "fault");
        this.faults = (MessageDecl[])ArrayUtil.addElement(this.faults, faultMessageDecl);
    }

    private void addDocumentStyle(Method method, JavaMethod javaMethod, Class[] parameterClasses, String[] argDocs, String namespace, int index, String suffix, String result, boolean isAsync) throws SchemaException {
        Schema schema = this.wsdl.getNamespaces().findSchema(namespace);
        schema.setQualifyElements(true);
        ComplexType inputType = new ComplexType(schema);
        inputType.setName(javaMethod.getName());
        Sequence inputSequence = new Sequence(inputType);
        int i = 0;
        while (i < parameterClasses.length) {
            Class javaClass = parameterClasses[i];
            if (!Holders.isOut(javaClass)) {
                Type argType = this.wsdl.getTypeForJavaClass(javaClass);
                SchemaElement schemaElement = new SchemaElement(this.wsdl.getNamespaces(), namespace, this.argNames[i], argType);
                inputSequence.addElement(schemaElement);
            }
            ++i;
        }
        inputType.setModel(inputSequence);
        SchemaElement inputElement = new SchemaElement(this.wsdl.getNamespaces(), namespace, javaMethod.getName(), inputType);
        inputElement.setUseAnonymous(true);
        this.wsdl.add(inputElement);
        Part inputPart = new Part("parameters", inputElement, null);
        Message inputMessage = new Message(this.wsdl, namespace, this.name + index + suffix + "In", new Part[]{inputPart});
        this.input = new MessageDecl(inputMessage, inputMessage.getName(), "input");
        this.wsdl.add(inputMessage);
        ComplexType outputType = new ComplexType(schema);
        outputType.setName(javaMethod.getName() + "Response");
        Sequence outputSequence = new Sequence(outputType);
        outputType.setModel(outputSequence);
        Class<?> returnType = method.getReturnType();
        if (returnType != Void.TYPE) {
            Type argType = this.wsdl.getTypeForJavaClass(returnType);
            String resultName = SOAPBinding.getSOAPResultName(this.name);
            SchemaElement schemaElement = new SchemaElement(this.wsdl.getNamespaces(), namespace, resultName, argType);
            outputSequence.addElement(schemaElement);
        }
        if (processFaults) {
            this.addExceptions(method, index, namespace);
        }
        int i2 = 0;
        while (i2 < parameterClasses.length) {
            Class javaClass = parameterClasses[i2];
            if (Holders.isHolder(javaClass)) {
                Type argType = this.wsdl.getTypeForJavaClass(javaClass);
                SchemaElement schemaElement = new SchemaElement(this.wsdl.getNamespaces(), namespace, this.argNames[i2], argType);
                outputSequence.addElement(schemaElement);
            }
            ++i2;
        }
        SchemaElement outputElement = new SchemaElement(this.wsdl.getNamespaces(), namespace, javaMethod.getName() + "Response", outputType);
        outputElement.setUseAnonymous(true);
        this.wsdl.add(outputElement);
        Part outputPart = new Part("parameters", outputElement, null);
        Message outputMessage = new Message(this.wsdl, namespace, this.name + index + suffix + "Out", new Part[]{outputPart});
        this.output = new MessageDecl(outputMessage, outputMessage.getName(), "output");
        this.wsdl.add(outputMessage);
    }

    public WSDL getWSDL() {
        return this.wsdl;
    }

    public String getName() {
        return this.name;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public String[] getArgNames() {
        return this.argNames;
    }

    public MessageDecl getInput() {
        return this.input;
    }

    public MessageDecl getOutput() {
        return this.output;
    }

    private MessageDecl getParam(Element operation, String name) throws WSDLException, SchemaException {
        Element messageReference = operation.getElement(name);
        if (messageReference != null) {
            return new MessageDecl(this, messageReference, name);
        }
        return MessageDecl.getVoid();
    }

    private MessageDecl[] getFaults(Element operation) throws WSDLException, SchemaException {
        Elements faults = operation.getElements("fault");
        if (faults.size() == 0) {
            return null;
        }
        MessageDecl[] faultArray = new MessageDecl[]{};
        while (faults.hasMoreElements()) {
            faultArray = (MessageDecl[])ArrayUtil.addElement(faultArray, new MessageDecl(this, faults.next(), "fault"));
        }
        return faultArray;
    }

    public MessageDecl[] getFaults() {
        return this.faults;
    }

    public Part getPart(String name) {
        Part part = this.input.getMessage().getPart(name);
        if (part != null) {
            return part;
        }
        part = this.output.getMessage().getPart(name);
        if (part != null) {
            return part;
        }
        if (this.faults != null) {
            int i = 0;
            while (i < this.faults.length) {
                part = this.faults[i].getMessage().getPart(name);
                if (part != null) {
                    return part;
                }
                ++i;
            }
        }
        return null;
    }

    public boolean hasParameterWithName(String name) {
        int i = 0;
        while (i < this.argNames.length) {
            if (this.argNames[i].equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void setArgNames(String parameterOrder) {
        this.argNames = new String[0];
        StringTokenizer tokenizer = new StringTokenizer(parameterOrder);
        while (tokenizer.hasMoreElements()) {
            this.argNames = (String[])ArrayUtil.addElement(this.argNames, tokenizer.nextElement());
        }
    }

    public String getParameterOrder() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.argNames.length) {
            if (i > 0) {
                buffer.append(' ');
            }
            buffer.append(this.argNames[i]);
            ++i;
        }
        return buffer.toString();
    }

    public void addDependencies(Vector dependencies) {
        this.input.addDependencies(dependencies);
        this.output.addDependencies(dependencies);
        if (this.faults != null) {
            int i = 0;
            while (i < this.faults.length) {
                this.faults[i].addDependencies(dependencies);
                ++i;
            }
        }
    }

    public void writeWSDL(Element portType) {
        String wsdlPrefix = portType.getNamespacePrefix("http://schemas.xmlsoap.org/wsdl/");
        Element operation = portType.addElement(wsdlPrefix, "operation");
        operation.setAttribute("name", this.name);
        if (this.documentation != null) {
            operation.setString(wsdlPrefix, "documentation", this.documentation);
        }
        if (this.argNames != null) {
            operation.setAttribute("parameterOrder", this.getParameterOrder());
        }
        this.input.writeWSDL(operation);
        this.output.writeWSDL(operation);
        if (this.faults != null) {
            int i = 0;
            while (i < this.faults.length) {
                this.faults[i].writeWSDL(operation);
                ++i;
            }
        }
    }

    public static boolean useOldStyleFaults() {
        return oldStyleFaults;
    }

    public static void setOldStyleFaults(boolean oldStyleFaults) {
        Operation.oldStyleFaults = oldStyleFaults;
    }

    public static boolean processFaults() {
        return processFaults;
    }

    public static void setProcessFaults(boolean processFaults) {
        Operation.processFaults = processFaults;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

