/*
 * Decompiled with CFR 0.152.
 */
package electric.util.time;

import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.string.Strings;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class XSDDateFormat
implements ILoggingConstants {
    private SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSz");
    private SimpleDateFormat format3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private SimpleDateFormat format4 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");

    public XSDDateFormat() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        this.format1.setTimeZone(timeZone);
        this.format2.setTimeZone(timeZone);
        this.format3.setTimeZone(timeZone);
        this.format4.setTimeZone(timeZone);
    }

    public synchronized String format(Date date) {
        String dateTime = this.format2.format(date);
        if (dateTime.endsWith("GMT")) {
            return Strings.replace(dateTime, "GMT", "Z");
        }
        return Strings.replace(dateTime, "GMT", "");
    }

    public synchronized Date parse(String string) {
        int colon = (string = string.trim()).indexOf(58);
        if (colon == -1) {
            return null;
        }
        if ((colon = string.indexOf(58, colon + 1)) == -1) {
            return null;
        }
        int end = colon + 1;
        boolean hasPrecision = false;
        boolean resetTimezone = false;
        while (end < string.length() - 1 && Character.isDigit(string.charAt(end))) {
            ++end;
        }
        if (string.charAt(end) == '.') {
            hasPrecision = true;
            int dot = end += 4;
            while (end < string.length() && Character.isDigit(string.charAt(end))) {
                ++end;
            }
            if (end > dot) {
                if (Log.isLogging(ILoggingConstants.COMMENT_EVENT)) {
                    Log.log(ILoggingConstants.COMMENT_EVENT, (Object)("Formatting date resulted in a loss of precision.  Date was " + string + ".  Precision lost was " + string.substring(dot, end) + "."));
                }
                string = string.substring(0, dot) + string.substring(end);
                end -= end - dot;
            }
        } else if (Character.isDigit(string.charAt(end))) {
            ++end;
        }
        if (end == string.length()) {
            if (hasPrecision) {
                return this.format1.parse(string, new ParsePosition(0));
            }
            return this.format3.parse(string, new ParsePosition(0));
        }
        if (string.charAt(end) == '-' || string.charAt(end) == '+') {
            colon = string.indexOf(58, end);
            if (colon != -1) {
                resetTimezone = true;
                TimeZone timeZone = TimeZone.getTimeZone("GMT" + string.substring(end, colon + 3));
                this.format1.setTimeZone(timeZone);
                this.format3.setTimeZone(timeZone);
            }
            string = string.substring(0, end);
        }
        if (resetTimezone) {
            Date returnValue = hasPrecision ? this.format1.parse(string, new ParsePosition(0)) : this.format3.parse(string, new ParsePosition(0));
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            this.format1.setTimeZone(timeZone);
            this.format3.setTimeZone(timeZone);
            return returnValue;
        }
        if (string.charAt(end) == 'Z') {
            string = string.substring(0, end) + "GMT";
        }
        if (hasPrecision) {
            return this.format2.parse(string, new ParsePosition(0));
        }
        return this.format4.parse(string, new ParsePosition(0));
    }
}

