/*
 * Decompiled with CFR 0.152.
 */
package electric.util.thread;

import electric.util.array.ArrayUtil;
import java.util.Vector;

public final class ThreadPool
implements Runnable {
    private static int DEFAULT_MAX_THREADS = 50;
    private static ThreadPool SHARED;
    private boolean stop;
    private boolean daemons;
    private int allocated;
    private int running;
    private int waiting;
    private int overflow;
    private Vector tasks = new Vector();
    private Thread[] threads;

    public ThreadPool(int max, boolean daemons) {
        this.threads = new Thread[max];
        this.daemons = daemons;
    }

    public static void setDefaultMaxThreads(int maxThreads) {
        DEFAULT_MAX_THREADS = maxThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxThreads() {
        Vector vector = this.tasks;
        synchronized (vector) {
            return this.threads.length - this.overflow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxThreads(int max) {
        if (max <= 0) {
            throw new IllegalArgumentException("invalid thread pool size");
        }
        Vector vector = this.tasks;
        synchronized (vector) {
            if (max > this.threads.length) {
                this.threads = (Thread[])ArrayUtil.grow(this.threads, max);
            } else if (max < this.threads.length) {
                int newSize = max;
                if (max < this.allocated) {
                    this.overflow += this.allocated - max;
                    newSize = this.allocated;
                }
                this.threads = (Thread[])ArrayUtil.shrink(this.threads, newSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAllocated() {
        Vector vector = this.tasks;
        synchronized (vector) {
            return this.allocated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRunning() {
        Vector vector = this.tasks;
        synchronized (vector) {
            return this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWaiting() {
        Vector vector = this.tasks;
        synchronized (vector) {
            return this.waiting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOverflow() {
        Vector vector = this.tasks;
        synchronized (vector) {
            return this.overflow;
        }
    }

    public int getTaskQueueSize() {
        return this.tasks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Runnable runnable) {
        Vector vector = this.tasks;
        synchronized (vector) {
            if (!this.stop && this.waiting <= this.tasks.size() && this.allocated < this.threads.length) {
                Thread thread = new Thread(this);
                thread.setContextClassLoader(Thread.currentThread().getContextClassLoader());
                thread.setName("ThreadPoolWorker: " + thread.getName());
                thread.setDaemon(this.daemons);
                this.threads[this.allocated++] = thread;
                thread.start();
            }
            this.tasks.addElement(runnable);
            this.tasks.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Runnable task = null;
            Vector vector = this.tasks;
            synchronized (vector) {
                if (this.stop) {
                    return;
                }
                if (this.overflow > 0) {
                    this.removeCurrentThread();
                    return;
                }
                ++this.waiting;
                while (!this.stop && this.tasks.isEmpty()) {
                    try {
                        this.tasks.wait();
                    }
                    catch (InterruptedException exception) {
                        // empty catch block
                    }
                }
                if (this.stop || this.tasks.isEmpty()) {
                    if (this.overflow > 0) {
                        this.removeCurrentThread();
                    }
                    --this.waiting;
                    return;
                }
                task = (Runnable)this.tasks.elementAt(0);
                this.tasks.removeElementAt(0);
                --this.waiting;
                ++this.running;
            }
            try {
                task.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Vector vector2 = this.tasks;
            synchronized (vector2) {
                --this.running;
            }
        }
    }

    private void removeCurrentThread() {
        this.threads = (Thread[])ArrayUtil.removeElementIdentity(this.threads, Thread.currentThread());
        --this.overflow;
        --this.allocated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Vector vector = this.tasks;
        synchronized (vector) {
            this.stop = true;
            int i = 0;
            while (i < this.threads.length) {
                if (this.threads[i] != null) {
                    this.threads[i].interrupt();
                }
                ++i;
            }
        }
    }

    private static void initSharedThreadPool() {
        SHARED = new ThreadPool(DEFAULT_MAX_THREADS, true);
    }

    public static ThreadPool getShared() {
        return SHARED;
    }

    static {
        ThreadPool.initSharedThreadPool();
    }
}

