/*
 * Decompiled with CFR 0.152.
 */
package electric.util.servlet.upload;

import electric.util.array.ArrayUtil;
import electric.util.io.Streams;
import electric.util.servlet.upload.UploadedFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileUpload {
    protected byte[] requestBytes;
    protected HttpServletRequest servletRequest;
    protected HttpServletResponse servletResponse;
    private String sessionId;
    private long length = 0L;
    private int totalBytes = 0;
    private int currentIndex = 0;
    private int startDataIndex = 0;
    private int endDataIndex = 0;
    private String boundary = new String();
    private long totalMaxFileSize = 0L;
    private long maxFileSize = 0L;
    private Vector deniedFilesList = new Vector();
    private Vector allowedFilesList = new Vector();

    public FileUpload(String sessionId, HttpServletRequest httpservletrequest, HttpServletResponse httpservletresponse) throws ServletException {
        this.sessionId = sessionId;
        this.servletRequest = httpservletrequest;
        this.servletResponse = httpservletresponse;
    }

    public File[] upload() throws ServletException, IOException {
        String dataHeader = new String();
        boolean hasFileName = false;
        this.totalBytes = this.servletRequest.getContentLength();
        this.requestBytes = Streams.readFully((InputStream)this.servletRequest.getInputStream(), this.totalBytes);
        boolean done = false;
        while (!done && this.currentIndex < this.totalBytes) {
            if (this.requestBytes[this.currentIndex] == 13) {
                done = true;
            } else {
                this.boundary = this.boundary + (char)this.requestBytes[this.currentIndex];
            }
            ++this.currentIndex;
        }
        if (this.currentIndex == 1) {
            return null;
        }
        File[] files = new File[]{};
        ++this.currentIndex;
        while (this.currentIndex < this.totalBytes) {
            dataHeader = this.getDataHeader();
            this.currentIndex += 2;
            hasFileName = dataHeader.indexOf("filename") > 0;
            UploadedFile file = new UploadedFile();
            if (hasFileName) {
                file.setFilePathName(this.getDataFieldValue(dataHeader, "filename"));
                file.setContentType(this.getContentType(dataHeader));
            }
            this.getDataSection();
            this.runLimitChecks(hasFileName, file);
            if (hasFileName) {
                if (file.getContentType().indexOf("application/x-macbinary") > 0) {
                    this.startDataIndex += 128;
                }
                file.setSize(this.endDataIndex - this.startDataIndex + 1);
                file.setStartData(this.startDataIndex);
                files = (File[])ArrayUtil.addElement(files, this.save(file));
            }
            if ((char)this.requestBytes[this.currentIndex + 1] == '-') break;
            this.currentIndex += 2;
        }
        return files;
    }

    private void runLimitChecks(boolean hasFileName, UploadedFile file) {
        if (hasFileName && file.getFileName().length() > 0) {
            if (this.deniedFilesList.contains(file.getFileExt())) {
                throw new SecurityException("The extension of the file is denied to be uploaded (1015).");
            }
            if (!this.allowedFilesList.isEmpty() && !this.allowedFilesList.contains(file.getFileExt())) {
                throw new SecurityException("The extension of the file is not allowed to be uploaded (1010).");
            }
            if (this.maxFileSize > 0L && (long)(this.endDataIndex - this.startDataIndex + 1) > this.maxFileSize) {
                throw new SecurityException("Size exceeded for this file : " + file.getFileName() + " (1105).");
            }
            this.length += (long)(this.endDataIndex - this.startDataIndex + 1);
            if (this.totalMaxFileSize > 0L && this.length > this.totalMaxFileSize) {
                throw new SecurityException("Total UploadedFile Size exceeded (1110).");
            }
        }
    }

    private File save(UploadedFile file) throws IOException {
        File sessionDir = new File(this.sessionId);
        sessionDir.mkdirs();
        File fileObj = new File(sessionDir, file.getFileName());
        FileOutputStream fileoutputstream = new FileOutputStream(fileObj);
        fileoutputstream.write(this.requestBytes, file.getStartData(), file.getSize());
        fileoutputstream.close();
        return fileObj;
    }

    private String getDataFieldValue(String dataHeader, String headerName) {
        String headerValue = "";
        String headerNameValueStart = headerName + "=" + '\"';
        int headerIndex = dataHeader.indexOf(headerNameValueStart);
        if (headerIndex > 0) {
            int headerEndIndex;
            int savedHeaderEndIndex = headerEndIndex = headerIndex + headerNameValueStart.length();
            String headerNameValueEnd = "\"";
            int headerValueEndIndex = dataHeader.indexOf(headerNameValueEnd, headerEndIndex);
            if (savedHeaderEndIndex > 0 && headerValueEndIndex > 0) {
                headerValue = dataHeader.substring(savedHeaderEndIndex, headerValueEndIndex);
            }
        }
        return headerValue;
    }

    private String getContentType(String string) {
        String contentType = new String();
        int length = "Content-Type:".length();
        if (string.toLowerCase().indexOf("content-type:") != -1) {
            contentType = string.substring(length, string.length());
        }
        return contentType;
    }

    private void getDataSection() {
        int curIndex = this.currentIndex;
        int boundaryCounter = 0;
        int boundaryLength = this.boundary.length();
        this.startDataIndex = this.currentIndex;
        this.endDataIndex = 0;
        while (curIndex < this.totalBytes) {
            if (this.requestBytes[curIndex] == (byte)this.boundary.charAt(boundaryCounter)) {
                if (boundaryCounter == boundaryLength - 1) {
                    this.endDataIndex = curIndex - boundaryLength + 1 - 3;
                    break;
                }
                ++boundaryCounter;
            } else {
                boundaryCounter = 0;
            }
            ++curIndex;
        }
        this.currentIndex = this.endDataIndex + boundaryLength + 3;
    }

    private String getDataHeader() {
        int i = this.currentIndex;
        int offset = 0;
        boolean done = false;
        while (!done) {
            if (this.requestBytes[this.currentIndex] == 13 && this.requestBytes[this.currentIndex + 2] == 13) {
                done = true;
                offset = this.currentIndex - 1;
                ++this.currentIndex;
            }
            ++this.currentIndex;
        }
        return new String(this.requestBytes, i, offset - i + 1);
    }

    public void setTotalMaxFileSize(long l) {
        this.totalMaxFileSize = l;
    }

    public void setMaxFileSize(long l) {
        this.maxFileSize = l;
    }
}

