/*
 * Decompiled with CFR 0.152.
 */
package electric.util.reflect;

import electric.util.array.ArrayUtil;
import electric.util.reflect.MethodAmbiguityException;
import electric.util.reflect.Reflect;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class MethodLookup {
    private static final Hashtable classToMethods = new Hashtable();
    static /* synthetic */ Class class$java$lang$Object;

    public static Method[] getMethodsWithSignature(Class type, String signature) throws NoSuchMethodException, ClassNotFoundException {
        int openParen = signature.indexOf(40);
        if (openParen == -1) {
            return MethodLookup.getMethods(type, signature);
        }
        String methodName = signature.substring(0, openParen);
        int closeParen = signature.indexOf(41);
        StringTokenizer tokenizer = new StringTokenizer(signature.substring(openParen + 1, closeParen), ",");
        Class[] argClasses = new Class[tokenizer.countTokens()];
        int i = 0;
        while (i < argClasses.length) {
            argClasses[i] = Reflect.getClass(tokenizer.nextToken().trim());
            ++i;
        }
        return new Method[]{type.getMethod(methodName, argClasses)};
    }

    public static Method getMethod(Class type, String methodName, Class[] argClasses) throws NoSuchMethodException {
        Method[] methods = MethodLookup.getMethods(type, methodName);
        if (methods == null) {
            throw new NoSuchMethodException(methodName);
        }
        int match = -1;
        int matchCount = 0;
        boolean[] matches = new boolean[methods.length];
        int i = 0;
        while (i < methods.length) {
            if (Reflect.matches(methods[i].getParameterTypes(), argClasses, true)) {
                match = i;
                ++matchCount;
                matches[i] = true;
            }
            ++i;
        }
        if (matchCount == 1) {
            return methods[match];
        }
        if (matchCount == 0) {
            throw new NoSuchMethodException(methodName);
        }
        int i2 = 0;
        while (i2 < methods.length) {
            if (matches[i2]) {
                boolean dominant = true;
                int j = 0;
                while (j < methods.length) {
                    if (i2 != j && matches[j] && !Reflect.dominates(methods[i2].getParameterTypes(), methods[j].getParameterTypes())) {
                        dominant = false;
                        break;
                    }
                    ++j;
                }
                if (dominant) {
                    return methods[i2];
                }
            }
            ++i2;
        }
        throw new MethodAmbiguityException("more than one match for " + methodName);
    }

    public static Constructor getConstructor(Class type, Class[] argClasses) throws NoSuchMethodException {
        Constructor<?>[] constructors = type.getConstructors();
        if (constructors == null) {
            throw new NoSuchMethodException("no constructor for " + type.getName());
        }
        int match = -1;
        int matchCount = 0;
        boolean[] matches = new boolean[constructors.length];
        int i = 0;
        while (i < constructors.length) {
            if (Reflect.matches(constructors[i].getParameterTypes(), argClasses, true)) {
                match = i;
                ++matchCount;
                matches[i] = true;
            }
            ++i;
        }
        if (matchCount == 1) {
            return constructors[match];
        }
        if (matchCount == 0) {
            throw new NoSuchMethodException("no constructor for " + type.getName() + " with " + argClasses.length + " arguments");
        }
        int i2 = 0;
        while (i2 < constructors.length) {
            if (matches[i2]) {
                boolean dominant = true;
                int j = 0;
                while (j < constructors.length) {
                    if (i2 != j && matches[j] && !Reflect.dominates(constructors[i2].getParameterTypes(), constructors[j].getParameterTypes())) {
                        dominant = false;
                        break;
                    }
                    ++j;
                }
                if (dominant) {
                    return constructors[i2];
                }
            }
            ++i2;
        }
        throw new MethodAmbiguityException("more than one match for constructor");
    }

    public static Method getMethod(Class type, String methodName, int argCount) throws NoSuchMethodException {
        Method[] methods = MethodLookup.getMethods(type, methodName);
        if (methods == null) {
            throw new NoSuchMethodException(type.getName() + "." + methodName);
        }
        int match = -1;
        int matchCount = 0;
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getParameterTypes().length == argCount) {
                match = i;
                ++matchCount;
            }
            ++i;
        }
        if (matchCount == 1) {
            return methods[match];
        }
        if (matchCount == 0) {
            throw new NoSuchMethodException(type.getName() + "." + methodName);
        }
        throw new MethodAmbiguityException("more than one match for " + methodName);
    }

    public static Constructor getConstructor(Class type, int argCount) throws NoSuchMethodException {
        Constructor<?>[] constructors = type.getConstructors();
        int match = -1;
        int matchCount = 0;
        int i = 0;
        while (i < constructors.length) {
            if (constructors[i].getParameterTypes().length == argCount) {
                match = i;
                ++matchCount;
            }
            ++i;
        }
        if (matchCount == 1) {
            return constructors[match];
        }
        if (matchCount == 0) {
            throw new NoSuchMethodException("no constructor match for " + type.getName());
        }
        throw new MethodAmbiguityException("more than one constructor match for " + type.getName());
    }

    public static Method[] getMethods(Class type, String methodName) {
        return (Method[])MethodLookup.getMethodHashtable(type).get(methodName);
    }

    private static synchronized Hashtable getMethodHashtable(Class type) {
        Hashtable table = (Hashtable)classToMethods.get(type);
        if (table == null) {
            table = MethodLookup.getMethodTable(type);
            classToMethods.put(type, table);
        }
        return table;
    }

    private static Hashtable getMethodTable(Class type) {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        Method[] array = type.getMethods();
        int i = 0;
        while (i < array.length) {
            Method method = array[i];
            if (method.getDeclaringClass() != (class$java$lang$Object == null ? MethodLookup.class$("java.lang.Object") : class$java$lang$Object)) {
                Method[] methods = (Method[])table.get(method.getName());
                if (methods == null) {
                    table.put(method.getName(), new Method[]{method});
                } else {
                    table.put(method.getName(), ArrayUtil.addElement(methods, method));
                }
            }
            ++i;
        }
        return table;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

