/*
 * Decompiled with CFR 0.152.
 */
package electric.util.license;

import electric.util.Context;
import electric.util.java.VMOptions;
import electric.util.license.ILicenseConstants;
import electric.util.license.LicensingException;
import electric.util.product.ProductInfo;
import electric.util.string.Strings;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;

public class NodeLockVerifier
implements ILicenseConstants {
    static /* synthetic */ Class class$java$lang$Runtime;

    public static void verify(ProductInfo productInfo, Hashtable nodeLockInfo) throws LicensingException {
        if (nodeLockInfo == null) {
            return;
        }
        int licenseType = (Integer)nodeLockInfo.get("licenseType");
        int cpuCount = (Integer)nodeLockInfo.get("cpuCount");
        String ipAddress = (String)nodeLockInfo.get("ipAddress");
        String productVersion = (String)nodeLockInfo.get("version");
        String hostName = (String)nodeLockInfo.get("hostName");
        String os = (String)nodeLockInfo.get("os");
        NodeLockVerifier.verifyOS(os);
        NodeLockVerifier.verifyIPAddress(ipAddress);
        NodeLockVerifier.verifyCpuCount(cpuCount);
        NodeLockVerifier.verifyHostName(hostName);
    }

    private static void verifyHostName(String hostName) {
        try {
            InetAddress actualHost = InetAddress.getByName(hostName);
            InetAddress localHost = InetAddress.getLocalHost();
            if (!actualHost.equals(localHost)) {
                throw new LicensingException("host name does not match. contact account manager or TME Sales");
            }
        }
        catch (SecurityException exception) {
        }
        catch (UnknownHostException exception) {
            throw new LicensingException("host name does not match. contact account manager or TME Sales");
        }
    }

    private static void verifyIPAddress(String ipAddress) throws LicensingException {
        String zeroCheck = Strings.stripChar(ipAddress, '.');
        try {
            if (Integer.parseInt(zeroCheck) == 0) {
                return;
            }
        }
        catch (NumberFormatException exception) {
            return;
        }
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            InetAddress ipFromLicenseKey = InetAddress.getByName(ipAddress);
            if (!localHost.equals(ipFromLicenseKey)) {
                throw new LicensingException("ipAddress does not match. contact account manager or TME Sales");
            }
        }
        catch (UnknownHostException exception) {
            throw new LicensingException("unable to verify ip address");
        }
    }

    private static void verifyOS(String os) {
        if (Context.getSystemProperty("os.name").toLowerCase().indexOf(os.toLowerCase()) == -1) {
            throw new LicensingException("operating system doesn't match. contact account manager or TME Sales");
        }
    }

    private static void verifyCpuCount(int cpuCount) {
        if (!VMOptions.supportsRuntimeAvailableProcessors()) {
            return;
        }
        try {
            Method availableProcessors = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = NodeLockVerifier.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("availableProcessors", new Class[0]);
            Integer systemCpuCount = (Integer)availableProcessors.invoke((Object)Runtime.getRuntime(), null);
            if (systemCpuCount != cpuCount) {
                throw new LicensingException("CPU count does not match. expected " + cpuCount + " received " + systemCpuCount);
            }
        }
        catch (LicensingException exception) {
            throw exception;
        }
        catch (Exception exception) {
        }
    }

    private static LicensingException newLicenseException() {
        return new LicensingException("This version of Glue professional is not licensed to run on this operating system.  If you feel this message has been received in error, contact sales@themindelectric.com for more details.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

