/*
 * Decompiled with CFR 0.152.
 */
package electric.util.jms;

import electric.util.io.Streams;
import electric.util.jms.MessageInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.BytesMessage;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public final class JMSUtil {
    private static InitialContext jndiContext;

    public static QueueConnectionFactory lookupQConnFactory(String name, Hashtable properties) throws NamingException {
        return (QueueConnectionFactory)JMSUtil.jndiLookup(name, properties);
    }

    public static Queue lookupQ(String name, Hashtable properties) throws NamingException {
        return (Queue)JMSUtil.jndiLookup(name, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object jndiLookup(String name, Hashtable properties) throws NamingException {
        if (jndiContext == null) {
            jndiContext = properties == null ? new InitialContext() : new InitialContext(properties);
        }
        InitialContext initialContext = jndiContext;
        synchronized (initialContext) {
            return jndiContext.lookup(name);
        }
    }

    public static byte[] getMessageBytes(BytesMessage message) throws IOException {
        return Streams.readFully(new MessageInputStream(message));
    }

    public static void mergeProps(Hashtable source, Hashtable destination) {
        if (source == null) {
            return;
        }
        Enumeration enumeration = source.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            destination.put(key, source.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup() throws NamingException {
        if (jndiContext != null) {
            InitialContext initialContext = jndiContext;
            synchronized (initialContext) {
                jndiContext.close();
                jndiContext = null;
            }
        }
    }
}

