/*
 * Decompiled with CFR 0.152.
 */
package electric.util.java;

import electric.util.array.ArrayUtil;
import electric.util.java.JavaField;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class JavaSource {
    private String packageName;
    private String className;
    private String superclass;
    private String[] interfaces = new String[0];
    private Hashtable namesToFields = new Hashtable();
    private Vector fields = new Vector();
    private String[] methods = new String[0];
    private boolean generateAccessors;

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setClass(String className) {
        this.className = className;
    }

    public void setSuperclass(String superclass) {
        this.superclass = superclass;
    }

    public void addInterface(String interfaceName) {
        this.interfaces = (String[])ArrayUtil.addElement(this.interfaces, interfaceName);
    }

    public void setGenerateAccessors(boolean generateAccessors) {
        this.generateAccessors = generateAccessors;
    }

    public boolean isGenerateAccessors() {
        return this.generateAccessors;
    }

    public void addField(JavaField field) {
        if (this.namesToFields.containsKey(field.name)) {
            throw new IllegalArgumentException("Duplicate field name detected in class " + this.className + ".");
        }
        this.namesToFields.put(field.name, field);
        this.fields.addElement(field);
    }

    public void addMethod(String text) {
        this.methods = (String[])ArrayUtil.addElement(this.methods, text);
    }

    public void write(PrintWriter writer) {
        if (this.packageName != null) {
            writer.println("package " + this.packageName + ";");
            writer.println();
        }
        writer.print(this.className);
        if (this.superclass != null) {
            writer.print(" extends " + this.superclass);
        }
        if (this.interfaces.length > 0) {
            writer.print(" implements ");
            int i = 0;
            while (i < this.interfaces.length) {
                if (i > 0) {
                    writer.print(", ");
                }
                writer.print(this.interfaces[i]);
                ++i;
            }
        }
        writer.println();
        writer.println("  {");
        Enumeration fieldsEnumeration = this.fields.elements();
        while (fieldsEnumeration.hasMoreElements()) {
            JavaField field = (JavaField)fieldsEnumeration.nextElement();
            field.writeJava(writer);
        }
        if (!this.fields.isEmpty() && (this.methods.length > 0 || this.isGenerateAccessors())) {
            writer.println();
        }
        int i = 0;
        while (i < this.methods.length) {
            if (i > 0) {
                writer.println();
            }
            writer.println(this.methods[i]);
            ++i;
        }
        writer.println("  }");
    }
}

