/*
 * Decompiled with CFR 0.152.
 */
package electric.util.jar;

import electric.util.file.FileUtil;
import electric.util.io.Streams;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class Jar {
    private static final String PREFIX = "MAP";
    private static final String SUFFIX = "TMP";
    private static final String TMP_FILENAME = "MAP.TMP";

    public static void saveFile(String jarFilePath, String filepath, String content) throws IOException {
        File fileInput = null;
        File fileOutput = null;
        ZipInputStream jarInput = null;
        ZipOutputStream jarOutput = null;
        try {
            fileInput = new File(jarFilePath);
            fileOutput = new File(TMP_FILENAME);
            FileOutputStream fout = new FileOutputStream(fileOutput);
            jarOutput = new ZipOutputStream(fout);
            if (fileInput.exists()) {
                ZipEntry entry = null;
                FileInputStream fin = new FileInputStream(fileInput);
                jarInput = new ZipInputStream(fin);
                while ((entry = jarInput.getNextEntry()) != null) {
                    if (entry.getName().equals(filepath)) continue;
                    byte[] bytes = Jar.readEntry(jarInput);
                    Jar.writeEntry(jarOutput, entry.getName(), bytes);
                }
                jarInput.close();
                jarInput = null;
                fileInput.delete();
            }
            Jar.writeEntry(jarOutput, filepath, content.getBytes());
            jarOutput.close();
            jarOutput = null;
            String dir = jarFilePath.substring(0, jarFilePath.length() - fileInput.getName().length());
            File dirFile = new File(dir);
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
            fileOutput.renameTo(fileInput);
        }
        catch (FileNotFoundException exception) {
            throw new IOException(exception.getMessage());
        }
        finally {
            if (jarInput != null) {
                jarInput.close();
            }
            if (jarOutput != null) {
                jarOutput.close();
            }
        }
    }

    public static void jarDirectory(String absolutePath, String relativePath, File jarFile) throws IOException {
        ZipOutputStream zipStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(jarFile)));
        Jar.jarDirectory(absolutePath, relativePath, zipStream);
        zipStream.close();
    }

    private static void jarDirectory(String absolutePath, String relativePath, ZipOutputStream zipStream) throws IOException {
        File jarPath = new File(absolutePath);
        if (!jarPath.exists()) {
            throw new FileNotFoundException();
        }
        if (!jarPath.isDirectory()) {
            throw new IllegalArgumentException(absolutePath + " must be a directory");
        }
        if (!relativePath.endsWith(File.separator)) {
            relativePath = relativePath + File.separator;
        }
        File[] files = FileUtil.listFiles(jarPath);
        Calendar calendar = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
        if (files.length == 0) {
            ZipEntry entry = new ZipEntry(absolutePath.substring(relativePath.length()) + "/");
            zipStream.putNextEntry(entry);
            zipStream.closeEntry();
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            String fileAbsolutePath = file.getAbsolutePath();
            if (file.isDirectory()) {
                Jar.jarDirectory(fileAbsolutePath, relativePath, zipStream);
            } else {
                String entryName = fileAbsolutePath.substring(relativePath.length());
                ZipEntry entry = new ZipEntry(entryName);
                calendar.setTime(new Date(file.lastModified()));
                entry.setTime(calendar.getTime().getTime());
                zipStream.putNextEntry(entry);
                FileInputStream input = new FileInputStream(file);
                Streams.copy((InputStream)input, (OutputStream)zipStream, (int)file.length(), 10240);
                ((InputStream)input).close();
                zipStream.closeEntry();
            }
            ++i;
        }
    }

    public static void unjarFile(File destination, ZipInputStream zipStream) throws IOException {
        destination.mkdir();
        try {
            try {
                ZipEntry entry;
                while ((entry = zipStream.getNextEntry()) != null) {
                    File directory;
                    String entryName = entry.getName();
                    if (!Jar.hasFileSeparator(entryName)) {
                        FileOutputStream output = new FileOutputStream(new File(destination, entryName));
                        Streams.copy((InputStream)zipStream, (OutputStream)output, (int)entry.getCompressedSize(), 10240);
                        ((OutputStream)output).close();
                        zipStream.closeEntry();
                        continue;
                    }
                    if (entry.isDirectory()) {
                        int index = entryName.endsWith(File.separator) ? entryName.lastIndexOf(File.separator) : (entryName.endsWith("/") ? entryName.lastIndexOf("/") : entryName.length());
                        File newDir = new File(destination, entryName.substring(0, index));
                        newDir.mkdirs();
                        zipStream.closeEntry();
                        continue;
                    }
                    String directoryName = "";
                    if (Jar.hasFileSeparator(entryName)) {
                        int index = Jar.lastIndexOfFileSeparator(entryName);
                        directoryName = destination.getCanonicalPath() + File.separator + entryName.substring(0, index);
                        entryName = entryName.substring(index + 1);
                    }
                    if (!(directory = new File(directoryName)).exists()) {
                        directory.mkdirs();
                    }
                    File outputFile = new File(directoryName, entryName);
                    FileOutputStream output = new FileOutputStream(outputFile);
                    Streams.copy((InputStream)zipStream, (OutputStream)output, (int)entry.getCompressedSize(), 10240);
                    ((OutputStream)output).close();
                    zipStream.closeEntry();
                }
                Object var9_12 = null;
            }
            catch (IOException exception) {
                exception.printStackTrace();
                FileUtil.delete(destination);
                throw new IOException("unable to extract file from JAR. exception - " + exception.toString());
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            zipStream.close();
            throw throwable;
        }
        zipStream.close();
    }

    private static void writeEntry(ZipOutputStream stream, String name, byte[] bytes) throws IOException {
        ZipEntry entry = new ZipEntry(name);
        stream.putNextEntry(entry);
        stream.write(bytes, 0, bytes.length);
        stream.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readEntry(ZipInputStream stream) throws IOException {
        byte[] bytes = null;
        try {
            bytes = Streams.readFully(stream);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            stream.closeEntry();
            throw throwable;
        }
        stream.closeEntry();
        return bytes;
    }

    private static boolean hasFileSeparator(String path) {
        return path.indexOf("/") > -1 || path.indexOf("\\") > -1;
    }

    private static int lastIndexOfFileSeparator(String path) {
        int index = path.lastIndexOf("/");
        if (index == -1) {
            index = path.lastIndexOf("\\");
        }
        return index;
    }
}

