/*
 * Decompiled with CFR 0.152.
 */
package electric.util.io;

import java.io.IOException;
import java.io.InputStream;

public class MonitoringInputStream
extends InputStream {
    private long totalBytesRead;
    private InputStream in;

    public MonitoringInputStream(InputStream in) {
        this.in = in;
    }

    public int read() throws IOException {
        int byteRead = this.in.read();
        this.totalBytesRead += (long)(byteRead == -1 ? 0 : 1);
        return byteRead;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.in.read(b, off, len);
        this.totalBytesRead += (long)(bytesRead == -1 ? 0 : bytesRead);
        return bytesRead;
    }

    public long getBytesRead() {
        return this.totalBytesRead;
    }
}

