/*
 * Decompiled with CFR 0.152.
 */
package electric.util.interceptor;

import electric.glue.context.ThreadContext;
import electric.soap.ISOAPInterceptor;
import electric.soap.SOAPMessage;
import electric.util.Context;
import electric.xml.Element;
import electric.xml.io.encoded.EncodedReader;
import electric.xml.io.literal.LiteralReader;
import electric.xml.io.schema.ISchemaConstants;
import java.io.IOException;

public class ReceiveThreadContext
implements ISOAPInterceptor {
    private String name;
    private boolean encoded;

    public ReceiveThreadContext(String name) {
        this(name, true);
    }

    public ReceiveThreadContext(String name, boolean encoded) {
        this.name = name;
        this.encoded = encoded;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean getEncoded() {
        return this.encoded;
    }

    public void setEncoded(boolean encoded) {
        this.encoded = encoded;
    }

    public void intercept(SOAPMessage message, Context context) {
        Element headerElement = message.getHeaderElement(this.name);
        if (headerElement == null) {
            ThreadContext.setProperty(this.name, null);
            return;
        }
        ISchemaConstants reader = null;
        reader = this.encoded ? new EncodedReader(headerElement) : new LiteralReader(headerElement);
        try {
            Object property = reader.readObject();
            ThreadContext.setProperty(this.name, property);
        }
        catch (IOException exception) {
            message.setException(exception);
        }
    }
}

