/*
 * Decompiled with CFR 0.152.
 */
package electric.util.http;

import electric.util.encoding.StringEncodings;
import electric.util.product.Product;

public interface IHTTPConstants {
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    public static final String CHARSET = "charset=";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_LOCATION = "Content-Location";
    public static final String CONTENT_ID = "Content-ID";
    public static final String CHUNKED = "chunked";
    public static final String BOUNDARY = "boundary";
    public static final String START = "start";
    public static final String EXPECT_HEADER = "Expect";
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    public static final String CONTENT_LANGUAGE = "Content-Language";
    public static final String KEEP_ALIVE = "Keep-Alive";
    public static final String HOST = "Host";
    public static final String RANGE = "Range";
    public static final String CONNECTION = "Connection";
    public static final String CLOSE = "Close";
    public static final String SERVER = "Server";
    public static final String HTTP_1_0 = "HTTP/1.0";
    public static final String HTTP_1_1 = "HTTP/1.1";
    public static final String COOKIE_LISTENER = "cookieListener";
    public static final String SET_COOKIE_0 = "Set-Cookie";
    public static final String SET_COOKIE_1 = "Set-Cookie2";
    public static final String COOKIE = "Cookie";
    public static final String SERVER_PREFIX = "TME-GLUE";
    public static final String SERVER_TYPE = "TME-GLUE/" + Product.getProductConfig().getProductInfo().getVersion();
    public static final String USER_AGENT = "User-Agent";
    public static final String POST = "POST";
    public static final String GET = "GET";
    public static final String DATE = "Date";
    public static final int DEFAULT_HTTPS_PORT = 443;
    public static final String GLUE_SESSION = "TME-GLUE-Session";
    public static final String AUTHORIZATION = "Authorization";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String BASIC = "Basic";
    public static final String DIGEST = "Digest";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String CONNECT = "CONNECT";
    public static final String OK = "OK";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String ACCEPT_RANGES = "Accept-Ranges";
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String APPLICATION_BINARY = "application/binary";
    public static final String MULTIPART_CONTENT_TYPE = "Multipart/Related";
    public static final String TEXT_XML = "text/xml";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_XML_UTF_8 = "text/xml; charset=UTF-8";
    public static final String FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String DEFAULT_CONTENT_TYPE = "text/plain";
    public static final String DEFAULT_MIME_TYPE = "text/plain";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String MIME_BOUNDARY = "MIME_boundary";
    public static final String MIME_VERSION = "MIME-Version";
    public static final String CONTINUE_EXPECTATION = "100-continue";
    public static final String EXPECT = "Expect";
    public static final String ASCII = "ASCII";
    public static final String DEFAULT_HTTP_CHARSET = "ISO-8859-1";
    public static final String MD5_HASH = "MD5";
    public static final byte[] CONTINUATION_STATUS = StringEncodings.toProtocolEncoding("HTTP/1.1 100 Continue\r\n\r\n");
    public static final byte[] SEPARATOR = StringEncodings.toProtocolEncoding(": ");
    public static final byte[] SLASH = StringEncodings.toProtocolEncoding("/");
    public static final byte[] EOL = StringEncodings.toProtocolEncoding("\r\n");
    public static final int DEFAULT_PROXY_PORT = 8000;
    public static final int SC_PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final int SC_OK = 200;
    public static final int SC_UNAUTHORIZED = 401;
    public static final int SC_CONTINUE = 100;
    public static final int SC_MOVED = 302;
    public static final int SC_MOVED_PERMANENTLY = 301;
}

