/*
 * Decompiled with CFR 0.152.
 */
package electric.util.codegen;

import electric.util.array.ArrayUtil;
import electric.util.codegen.IJVMConstants;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;

public final class ClassWriter
implements IJVMConstants {
    public short majorVersion = (short)45;
    public short minorVersion = (short)3;
    public short constantPoolIndex = 1;
    public Hashtable classConstants = new Hashtable();
    public Hashtable utf8Constants = new Hashtable();
    public ByteArrayOutputStream constantPoolBytes = new ByteArrayOutputStream();
    public DataOutputStream constantPool = new DataOutputStream(this.constantPoolBytes);
    public short methodsCount = 0;
    public ByteArrayOutputStream methodsBytes = new ByteArrayOutputStream();
    public DataOutputStream methods = new DataOutputStream(this.methodsBytes);
    public short fieldsCount = 0;
    public ByteArrayOutputStream fieldsBytes = new ByteArrayOutputStream();
    public DataOutputStream fields = new DataOutputStream(this.fieldsBytes);
    public short accessFlags = (short)33;
    public short thisClass;
    public short superClass = 0;
    public short[] interfaces = new short[0];

    public void setMajorVersion(short majorVersion) {
        this.majorVersion = majorVersion;
    }

    public void setMinorVersion(short minorVersion) {
        this.minorVersion = minorVersion;
    }

    public void setAccessFlags(short accessFlags) {
        this.accessFlags = accessFlags;
    }

    public void setClass(String name) throws IOException {
        this.thisClass = this.addConstantClass(name);
    }

    public void setSuperClass(String name) throws IOException {
        this.superClass = this.addConstantClass(name);
    }

    public void addInterface(String name) throws IOException {
        short index = this.addConstantClass(name);
        this.interfaces = (short[])ArrayUtil.addElement((Object)this.interfaces, new Short(index));
    }

    public short addField(short accessFlags, String name, Class type) throws IOException {
        this.fieldsCount = (short)(this.fieldsCount + 1);
        short nameIndex = this.addConstantUTF8(name);
        short descriptorIndex = this.addConstantUTF8(this.getClassDescriptor(type));
        this.fields.writeShort(accessFlags);
        this.fields.writeShort(nameIndex);
        this.fields.writeShort(descriptorIndex);
        this.fields.writeShort(0);
        return this.fieldsCount;
    }

    public void addMethod(short accessFlags, String name, Class[] parameters, Class returnType, Class[] exceptions, byte[] code, short maxStack, short maxLocals) throws IOException {
        this.methodsCount = (short)(this.methodsCount + 1);
        this.methods.writeShort(accessFlags);
        this.methods.writeShort(this.addConstantUTF8(name));
        this.methods.writeShort(this.addConstantUTF8(this.getMethodDescriptor(parameters, returnType)));
        if (exceptions.length > 0) {
            this.methods.writeShort(1 + (code != null ? 1 : 0));
            this.methods.writeShort(this.addConstantUTF8("Exceptions"));
            this.methods.writeInt(2 + exceptions.length * 2);
            this.methods.writeShort(exceptions.length);
            int i = 0;
            while (i < exceptions.length) {
                this.methods.writeShort(this.addConstantClass(exceptions[i].getName()));
                ++i;
            }
        } else {
            this.methods.writeShort(code != null ? 1 : 0);
        }
        if (code != null) {
            this.methods.writeShort(this.addConstantUTF8("Code"));
            this.methods.writeInt(code.length + 12);
            this.methods.writeShort(maxStack);
            this.methods.writeShort(maxLocals);
            this.methods.writeInt(code.length);
            this.methods.write(code);
            this.methods.writeShort(0);
            this.methods.writeShort(0);
        }
    }

    public String getMethodDescriptor(Class[] parameters, Class returnType) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        int i = 0;
        while (i < parameters.length) {
            buffer.append(this.getClassDescriptor(parameters[i]));
            ++i;
        }
        buffer.append(")");
        buffer.append(this.getClassDescriptor(returnType));
        return buffer.toString();
    }

    public String getClassDescriptor(Class type) {
        if (type == Byte.TYPE) {
            return "B";
        }
        if (type == Character.TYPE) {
            return "C";
        }
        if (type == Double.TYPE) {
            return "D";
        }
        if (type == Float.TYPE) {
            return "F";
        }
        if (type == Integer.TYPE) {
            return "I";
        }
        if (type == Long.TYPE) {
            return "J";
        }
        if (type == Short.TYPE) {
            return "S";
        }
        if (type == Void.TYPE) {
            return "V";
        }
        if (type == Boolean.TYPE) {
            return "Z";
        }
        if (type.isArray()) {
            return "[" + this.getClassDescriptor(type.getComponentType());
        }
        return "L" + type.getName().replace('.', '/') + ";";
    }

    public short addConstantMethod(String type, String name, Class[] parameters, Class returnType) throws IOException {
        short classIndex = this.addConstantClass(type);
        String descriptor = this.getMethodDescriptor(parameters, returnType);
        short nameAndTypeIndex = this.addConstantNameAndType(name, descriptor);
        short s = this.constantPoolIndex;
        this.constantPoolIndex = (short)(s + 1);
        short index = s;
        this.constantPool.writeByte(10);
        this.constantPool.writeShort(classIndex);
        this.constantPool.writeShort(nameAndTypeIndex);
        return index;
    }

    public short addConstantField(String type, String name, Class fieldType) throws IOException {
        short classIndex = this.addConstantClass(type);
        String descriptor = this.getClassDescriptor(fieldType);
        short nameAndTypeIndex = this.addConstantNameAndType(name, descriptor);
        short s = this.constantPoolIndex;
        this.constantPoolIndex = (short)(s + 1);
        short index = s;
        this.constantPool.writeByte(9);
        this.constantPool.writeShort(classIndex);
        this.constantPool.writeShort(nameAndTypeIndex);
        return index;
    }

    public short addConstantNameAndType(String name, String descriptor) throws IOException {
        short nameIndex = this.addConstantUTF8(name);
        short typeIndex = this.addConstantUTF8(descriptor);
        short s = this.constantPoolIndex;
        this.constantPoolIndex = (short)(s + 1);
        short index = s;
        this.constantPool.writeByte(12);
        this.constantPool.writeShort(nameIndex);
        this.constantPool.writeShort(typeIndex);
        return index;
    }

    public short addConstantClass(String name) throws IOException {
        Short value = (Short)this.classConstants.get(name);
        if (value != null) {
            return value;
        }
        short nameIndex = this.addConstantUTF8(name.replace('.', '/'));
        short s = this.constantPoolIndex;
        this.constantPoolIndex = (short)(s + 1);
        short index = s;
        this.constantPool.writeByte(7);
        this.constantPool.writeShort(nameIndex);
        this.classConstants.put(name, new Short(index));
        return index;
    }

    public short addConstantUTF8(String name) throws IOException {
        Short value = (Short)this.utf8Constants.get(name);
        if (value != null) {
            return value;
        }
        short s = this.constantPoolIndex;
        this.constantPoolIndex = (short)(s + 1);
        short index = s;
        this.constantPool.writeByte(1);
        this.constantPool.writeUTF(name);
        this.utf8Constants.put(name, new Short(index));
        return index;
    }

    public byte[] getBytes() throws IOException {
        this.constantPool.flush();
        this.methods.flush();
        this.fields.flush();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(bytes);
        output.writeInt(-889275714);
        output.writeShort(this.minorVersion);
        output.writeShort(this.majorVersion);
        output.writeShort(this.constantPoolIndex);
        output.write(this.constantPoolBytes.toByteArray());
        output.writeShort(this.accessFlags);
        output.writeShort(this.thisClass);
        output.writeShort(this.superClass);
        output.writeShort(this.interfaces.length);
        int i = 0;
        while (i < this.interfaces.length) {
            output.writeShort(this.interfaces[i]);
            ++i;
        }
        output.writeShort(this.fieldsCount);
        output.write(this.fieldsBytes.toByteArray());
        output.writeShort(this.methodsCount);
        output.write(this.methodsBytes.toByteArray());
        output.writeShort(0);
        output.flush();
        return bytes.toByteArray();
    }
}

