/*
 * Decompiled with CFR 0.152.
 */
package electric.util.classloader;

import electric.util.Context;
import electric.util.array.ArrayUtil;
import electric.util.classloader.ClassLoaders;
import electric.util.classloader.filters.IClassFilter;
import electric.util.classpath.IClassPathSource;
import electric.util.io.Streams;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class TrackingClassLoader
extends ClassLoader
implements ILoggingConstants {
    private static final String CLASS_LOADERS = "classloaders";
    private IClassPathSource classPathSource;
    private Hashtable classCache = new Hashtable();
    private Hashtable classNotFoundCache = new Hashtable();
    private String[] previousClasspath = null;
    private Vector fileCache = new Vector();
    private ClassLoader parent;
    private String[] archivesInUse = new String[0];
    private IClassFilter[] filters;
    static /* synthetic */ Class array$Ljava$io$File;
    static /* synthetic */ Class class$java$lang$String;

    public TrackingClassLoader(IClassPathSource classPathSource) {
        this(classPathSource, null, null);
    }

    public TrackingClassLoader(IClassPathSource classPathSource, IClassFilter[] filters) {
        this(classPathSource, null, filters);
    }

    public TrackingClassLoader(IClassPathSource classPathSource, ClassLoader parent) {
        this(classPathSource, parent, null);
    }

    public TrackingClassLoader(IClassPathSource classPathSource, ClassLoader parent, IClassFilter[] filters) {
        this.parent = parent;
        this.classPathSource = classPathSource;
        this.filters = filters;
    }

    public boolean usesFiles(File[] files) {
        if (files == null || files.length == 0) {
            return false;
        }
        int i = 0;
        while (i < files.length) {
            String path = files[i].getAbsolutePath();
            if (ArrayUtil.contains(path, this.archivesInUse)) {
                return true;
            }
            if (this.fileCache.contains(path)) {
                return true;
            }
            ++i;
        }
        try {
            Method usesFilesMethod = this.parent.getClass().getMethod("usesFiles", array$Ljava$io$File == null ? (array$Ljava$io$File = TrackingClassLoader.class$("[Ljava.io.File;")) : array$Ljava$io$File);
            Boolean boolObj = (Boolean)usesFilesMethod.invoke((Object)this.parent, new Object[]{files});
            return boolObj;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private synchronized String[] getClassPath() {
        String[] classpath = this.classPathSource.getClassPath();
        if (this.previousClasspath == null) {
            this.previousClasspath = classpath;
            return classpath;
        }
        if (this.previousClasspath == classpath) {
            return classpath;
        }
        this.classNotFoundCache = new Hashtable();
        this.previousClasspath = classpath;
        return classpath;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        Class classObj;
        if (name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("sun.")) {
            try {
                return ClassLoader.getSystemClassLoader().loadClass(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((classObj = (Class)this.classCache.get(name)) != null) {
            return classObj;
        }
        if (this.filters != null) {
            int i = 0;
            while (i < this.filters.length) {
                if (this.filters[i].accept(name)) {
                    classObj = this.loadFromParent(name);
                    if (classObj == null) break;
                    return classObj;
                }
                ++i;
            }
        }
        if (!this.classNotFoundCache.containsKey(name) && (classObj = this.loadFromClasspath(name)) != null) {
            return classObj;
        }
        this.classNotFoundCache.put(name, name);
        ClassLoader contextClassLoader = ClassLoaders.getContextClassLoader();
        if (contextClassLoader != null && contextClassLoader != this) {
            try {
                return contextClassLoader.loadClass(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((classObj = this.loadFromParent(name)) != null) {
            return classObj;
        }
        return ClassLoader.getSystemClassLoader().loadClass(name);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        return this.loadClass(name);
    }

    private Class loadFromParent(String name) {
        if (this.parent == null) {
            return null;
        }
        Class classObj = null;
        try {
            if (this.parent.getClass().getName().equals(this.getClass().getName())) {
                try {
                    Method loadFromClassPathMethod = this.parent.getClass().getMethod("loadFromClasspath", class$java$lang$String == null ? (class$java$lang$String = TrackingClassLoader.class$("java.lang.String")) : class$java$lang$String);
                    classObj = (Class)loadFromClassPathMethod.invoke((Object)this.parent, name);
                }
                catch (Exception e) {
                    return null;
                }
                if (classObj == null) {
                    return null;
                }
            } else {
                classObj = this.parent.loadClass(name);
            }
            if (classObj.getClassLoader() == this.parent) {
                this.storeClassLoader(this.parent);
            }
            return classObj;
        }
        catch (ClassNotFoundException exception) {
            return null;
        }
    }

    public Class loadFromClasspath(String name) {
        Class<?> classObj = (Class<?>)this.classCache.get(name);
        if (classObj != null) {
            return classObj;
        }
        byte[] classBytes = this.getResourceBytes(TrackingClassLoader.toClassFile(name));
        if (classBytes == null) {
            return null;
        }
        classObj = this.defineClass(name.replace('/', '.'), classBytes, 0, classBytes.length);
        this.classCache.put(name, classObj);
        this.storeClassLoader(this);
        return classObj;
    }

    private final void storeClassLoader(ClassLoader classLoader) {
        Vector loaders = (Vector)Context.thread().getProperty(CLASS_LOADERS);
        if (loaders != null && !loaders.contains(classLoader)) {
            loaders.addElement(classLoader);
        }
    }

    private static String toClassFile(String name) {
        return name.replace('.', '/') + ".class";
    }

    public URL getResource(String name) {
        String[] classpath = this.getClassPath();
        if (classpath == null) {
            return null;
        }
        name = name.replace('\\', '/');
        int i = 0;
        while (i < classpath.length) {
            if (this.isArchive(classpath[i])) {
                try {
                    String path = classpath[i].replace('\\', '/');
                    String urlString = "jar:file:/" + path + "!/" + name;
                    URL url = new URL(urlString);
                    InputStream istr = url.openStream();
                    istr.close();
                    return url;
                }
                catch (Throwable exception) {}
            } else {
                try {
                    URL url = new URL("file:" + classpath[i] + "/" + name);
                    InputStream istr = url.openStream();
                    istr.close();
                    return new URL(url.toString());
                }
                catch (Throwable exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        this.classNotFoundCache.put(name, name);
        if (this.parent != null) {
            return this.parent.getResource(name);
        }
        ClassLoader thisClassLoader = this.getClass().getClassLoader();
        if (thisClassLoader == null) {
            thisClassLoader = ClassLoader.getSystemClassLoader();
        }
        return thisClassLoader.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        InputStream stream;
        byte[] resourceBytes = this.getResourceBytes(name);
        if (resourceBytes != null) {
            return new ByteArrayInputStream(resourceBytes);
        }
        if (this.parent != null && (stream = this.parent.getResourceAsStream(name)) != null) {
            return stream;
        }
        ClassLoader thisClassLoader = this.getClass().getClassLoader();
        if (thisClassLoader == null) {
            thisClassLoader = ClassLoader.getSystemClassLoader();
        }
        return thisClassLoader.getResourceAsStream(name);
    }

    protected byte[] getResourceBytes(String resource) {
        String[] classpath = this.getClassPath();
        if (classpath != null) {
            int i = 0;
            while (i < classpath.length) {
                byte[] bytes = null;
                bytes = this.isArchive(classpath[i]) ? this.loadFromArchive(resource, classpath[i]) : this.loadFromDirectory(resource, classpath[i]);
                if (bytes != null) {
                    return bytes;
                }
                ++i;
            }
        }
        if (Log.isLogging(ILoggingConstants.CLASSLOADER_EVENT)) {
            Log.log(ILoggingConstants.CLASSLOADER_EVENT, (Object)("unable to find resource " + resource + " in classloader " + this));
        }
        return null;
    }

    private boolean isArchive(String file) {
        return (file = file.toLowerCase()).endsWith(".jar") || file.endsWith(".ear") || file.endsWith(".zip") || file.endsWith(".war");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] loadFromArchive(String resource, String archive) {
        ZipFile zipFile = null;
        zipFile = new ZipFile(archive);
        ZipEntry entry = zipFile.getEntry(resource);
        if (entry == null) {
            entry = zipFile.getEntry(resource.replace('/', '\\'));
        }
        byte[] bytes = Streams.readFully(zipFile.getInputStream(entry), (int)entry.getSize());
        if (Log.isLogging(ILoggingConstants.CLASSLOADER_EVENT)) {
            Log.log(ILoggingConstants.CLASSLOADER_EVENT, (Object)("loaded resource " + resource + " from " + zipFile.getName()));
        }
        if (!ArrayUtil.contains(archive, this.archivesInUse)) {
            this.archivesInUse = (String[])ArrayUtil.addElement(this.archivesInUse, archive);
        }
        byte[] byArray = bytes;
        Object var8_8 = null;
        if (zipFile == null) return byArray;
        try {
            zipFile.close();
            return byArray;
        }
        catch (IOException exception2) {
            // empty catch block
        }
        return byArray;
        catch (Exception exception) {
            try {
                Object var8_9 = null;
                if (zipFile == null) return null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (zipFile == null) throw throwable;
                try {
                    zipFile.close();
                    throw throwable;
                }
                catch (IOException exception2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                zipFile.close();
                return null;
            }
            catch (IOException exception2) {}
            return null;
        }
    }

    private byte[] loadFromDirectory(String resource, String directory) {
        File file = new File(directory, resource);
        if (!file.exists()) {
            return null;
        }
        if (Log.isLogging(ILoggingConstants.CLASSLOADER_EVENT)) {
            Log.log(ILoggingConstants.CLASSLOADER_EVENT, (Object)("loaded resource " + resource + " from " + file.getAbsolutePath()));
        }
        this.fileCache.addElement(file.getAbsolutePath());
        try {
            return Streams.readFully(file);
        }
        catch (IOException exception) {
            return null;
        }
    }

    public String toString() {
        String[] args = this.getClassPath();
        StringBuffer buffer = new StringBuffer();
        buffer.append("TrackingClassLoader( ");
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(args[i]);
                ++i;
            }
        }
        buffer.append(" )");
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

