/*
 * Decompiled with CFR 0.152.
 */
package electric.util;

import electric.util.array.ArrayUtil;
import electric.util.context.IContextHolder;
import electric.util.context.IContextListener;
import electric.util.dictionary.IdentityHashtable;
import electric.util.string.Strings;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Context {
    private static final Enumeration NONE = new Vector().elements();
    private static Context applicationContext = new Context();
    private static final IdentityHashtable threadToContext = new IdentityHashtable();
    private static final Hashtable objectToContext = new Hashtable();
    private Hashtable nameToVector;
    private transient IContextListener[] listeners;

    public Context() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context(Context context) {
        Context context2 = context;
        synchronized (context2) {
            if (context.nameToVector != null) {
                this.nameToVector = new Hashtable();
                Enumeration enumeration = context.nameToVector.keys();
                while (enumeration.hasMoreElements()) {
                    String name = (String)enumeration.nextElement();
                    Vector vector = (Vector)context.nameToVector.get(name);
                    this.nameToVector.put(name, vector.clone());
                }
            }
        }
    }

    public String toString() {
        if (this.nameToVector == null) {
            return "Context()";
        }
        return "Context( " + this.nameToVector + " )";
    }

    public synchronized void setProperty(String name, Object value) {
        if (this.nameToVector == null) {
            this.nameToVector = new Hashtable();
        }
        Vector<Object> properties = new Vector<Object>();
        properties.addElement(value);
        this.nameToVector.put(name, properties);
        if (this.listeners != null) {
            int i = 0;
            while (i < this.listeners.length) {
                this.listeners[i].addProperty(name, value, this);
                ++i;
            }
        }
    }

    public synchronized void addProperty(String name, Object value) {
        Vector<Object> properties;
        if (this.nameToVector == null) {
            this.nameToVector = new Hashtable();
        }
        if ((properties = (Vector<Object>)this.nameToVector.get(name)) == null) {
            properties = new Vector<Object>();
            this.nameToVector.put(name, properties);
        }
        properties.addElement(value);
        if (this.listeners != null) {
            int i = 0;
            while (i < this.listeners.length) {
                this.listeners[i].addProperty(name, value, this);
                ++i;
            }
        }
    }

    public synchronized Object getProperty(String name) {
        if (this.nameToVector == null) {
            return null;
        }
        Vector properties = (Vector)this.nameToVector.get(name);
        return properties == null ? null : properties.firstElement();
    }

    public synchronized Object getProperty(String name, Object defaultValue) {
        if (this.nameToVector == null) {
            return defaultValue;
        }
        Vector properties = (Vector)this.nameToVector.get(name);
        return properties == null ? defaultValue : properties.firstElement();
    }

    public synchronized Enumeration getProperties(String name) {
        if (this.nameToVector == null) {
            return NONE;
        }
        Vector properties = (Vector)this.nameToVector.get(name);
        return properties == null ? NONE : properties.elements();
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        return Strings.getBoolean((String)this.getProperty(name), defaultValue);
    }

    public String getStringProperty(String name) {
        return (String)this.getProperty(name);
    }

    public String getStringProperty(String name, String defaultValue) {
        String value = this.getStringProperty(name);
        return value != null ? value : defaultValue;
    }

    public int getIntProperty(String name, int defaultValue) {
        try {
            return Integer.parseInt((String)this.getProperty(name));
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public synchronized Enumeration getPropertyNames() {
        return this.nameToVector == null ? NONE : this.nameToVector.keys();
    }

    public synchronized Object removeProperty(String name, Object value) {
        if (this.nameToVector == null) {
            return null;
        }
        Vector properties = (Vector)this.nameToVector.get(name);
        if (properties == null) {
            return null;
        }
        int index = properties.indexOf(value);
        if (index == -1) {
            return null;
        }
        Object element = properties.elementAt(index);
        properties.removeElementAt(index);
        if (properties.isEmpty()) {
            this.nameToVector.remove(name);
        }
        if (this.listeners != null) {
            int i = 0;
            while (i < this.listeners.length) {
                this.listeners[i].removeProperty(name, element, this);
                ++i;
            }
        }
        return element;
    }

    public synchronized Object removeProperty(String name) {
        if (this.nameToVector == null) {
            return null;
        }
        Vector properties = (Vector)this.nameToVector.get(name);
        if (properties == null) {
            return null;
        }
        Object property = properties.elementAt(0);
        properties.removeElementAt(0);
        if (properties.isEmpty()) {
            this.nameToVector.remove(name);
        }
        if (this.listeners != null) {
            int i = 0;
            while (i < this.listeners.length) {
                this.listeners[i].removeProperty(name, property, this);
                ++i;
            }
        }
        return property;
    }

    public synchronized Enumeration removeProperties(String name) {
        if (this.nameToVector == null) {
            return NONE;
        }
        Vector properties = (Vector)this.nameToVector.remove(name);
        if (properties == null) {
            return NONE;
        }
        if (this.listeners != null) {
            int i = 0;
            while (i < this.listeners.length) {
                int j = 0;
                while (j < properties.size()) {
                    this.listeners[i].removeProperty(name, properties.elementAt(j), this);
                    ++j;
                }
                ++i;
            }
        }
        return properties.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addContext(Context context) {
        if (context == this) {
            return;
        }
        Context context2 = context;
        synchronized (context2) {
            Enumeration keys = context.getPropertyNames();
            while (keys.hasMoreElements()) {
                String name = (String)keys.nextElement();
                Enumeration values = context.getProperties(name);
                while (values.hasMoreElements()) {
                    this.addProperty(name, values.nextElement());
                }
            }
        }
    }

    public static synchronized Context thread() {
        Thread thread = Thread.currentThread();
        Context context = (Context)threadToContext.get(thread);
        if (context == null) {
            context = new Context();
            threadToContext.put(thread, context);
        }
        return context;
    }

    public static synchronized void removeThreadContext() {
        threadToContext.remove(Thread.currentThread());
    }

    public static Context application() {
        return applicationContext;
    }

    public static synchronized Context of(Object object) {
        Context context = (Context)objectToContext.get(object);
        if (context == null) {
            context = new Context();
            objectToContext.put(object, context);
        }
        return context;
    }

    public static synchronized void set(Object object, Context context) {
        objectToContext.put(object, context);
    }

    public static synchronized Context get(Object object) {
        return (Context)objectToContext.get(object);
    }

    public static synchronized Context remove(Object object) {
        return (Context)objectToContext.remove(object);
    }

    public static Context getContext(Object object) {
        if (object instanceof IContextHolder) {
            return ((IContextHolder)object).getContext();
        }
        return null;
    }

    public static void setContext(Object object, Context context) {
        if (!(object instanceof IContextHolder)) {
            throw new IllegalArgumentException(object + " is not an instance of IContextHolder");
        }
        ((IContextHolder)object).setContext(context);
    }

    public synchronized void addListener(IContextListener listener) {
        this.listeners = this.listeners == null ? new IContextListener[]{listener} : (IContextListener[])ArrayUtil.addElement(this.listeners, listener);
    }

    public synchronized void removeListener(IContextListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners = (IContextListener[])ArrayUtil.removeElement(this.listeners, listener);
        if (this.listeners.length == 0) {
            this.listeners = null;
        }
    }

    public static String getSystemProperty(String name) {
        try {
            SecurityManager manager = System.getSecurityManager();
            if (manager != null) {
                manager.checkPropertyAccess(name);
            }
            return System.getProperty(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getSystemProperty(String name, String defaultValue) {
        try {
            SecurityManager manager = System.getSecurityManager();
            if (manager != null) {
                manager.checkPropertyAccess(name);
            }
            return System.getProperty(name, defaultValue);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static Object getProperty(Context context, String name) {
        Object value = context.getProperty(name);
        if (value != null) {
            return value;
        }
        return applicationContext.getProperty(name);
    }

    public static Object getProperty(Context context, String name, Object defaultValue) {
        Object value = context.getProperty(name);
        if (value != null) {
            return value;
        }
        value = applicationContext.getProperty(name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }
}

