/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi.tools;

import electric.glue.IGLUELoggingConstants;
import electric.server.http.HTTP;
import electric.uddi.server.IUDDIStorage;
import electric.uddi.server.UDDIServer;
import electric.uddi.server.file.FileUDDIStorage;
import electric.uddi.server.sql.SQLUDDIStorage;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.string.Strings;
import electric.util.tool.ToolUtil;

public final class UDDI
implements IGLUELoggingConstants {
    private static final String DEFAULT_INQUIRY_URL = "http://localhost:8004/uddi/inquiry";
    private static final String DEFAULT_PUBLICATION_URL = "http://localhost:8005/uddi/publication";
    private static final String DEFAULT_SITE_OPERATOR = "glue.uddi";
    private static final String READ_PATH = "/uddi/read/";
    private static final String WRITE_PATH = "/uddi/write/";
    private static String inquiryURL = "http://localhost:8004/uddi/inquiry";
    private static String publicationURL = "http://localhost:8005/uddi/publication";
    private static String siteOperator = "glue.uddi";
    private static String root;
    private static String dbName;
    private static boolean deleteContents;
    private static boolean sqlPersistence;

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            UDDI.printUsage();
            return;
        }
        try {
            UDDI.processArgs(args);
            UDDI.uddi();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            UDDI.printUsage();
            System.exit(-1);
        }
    }

    private static void printUsage() {
        System.out.println("usage: uddi [-Dname=value]* -r root [-d] [-h] [-i url] [-o operator] [-p url]");
        System.out.println();
        System.out.println("where:");
        System.out.println("  -Dname=value = set java system property");
        System.out.println("  -d           = delete previous contents (default is no)");
        System.out.println("  -h           = print this message and exit");
        System.out.println("  -i url       = inquiry endpoint (default is http://localhost:8004/uddi/inquiry)");
        System.out.println("  -o operator  = site operator (default is glue.uddi)");
        System.out.println("  -p url       = publication endpoint (default is http://localhost:8005/uddi/publication)");
        System.out.println("  -r root      = root directory for XML storage");
        System.out.println();
        System.out.println("examples:");
        System.out.println();
        System.out.println("uddi -r \\uddi");
        System.out.println("  starts uddi server on ports 8004/8005 with \\uddi as storage root, using previous contents");
        System.out.println();
        System.out.println("uddi -r \\uddi -d");
        System.out.println("  starts uddi server on ports 8004/8005 with \\uddi as storage root, deleting previous contents");
        System.out.println();
        System.out.println("uddi -r \\uddi -d -p https://localhost:8004/myhost/publication -i http://localhost:8004/myhost/inquiry");
        System.out.println("  starts uddi server with specified inquiry and publication urls");
    }

    private static void processArgs(String[] args) throws Throwable {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.length() == 1) {
                throw new IllegalArgumentException("a plain - is not a valid argument");
            }
            switch (arg.charAt(1)) {
                case 'D': {
                    ToolUtil.setProperty(arg);
                    break;
                }
                case 'd': {
                    deleteContents = true;
                    break;
                }
                case 's': {
                    sqlPersistence = true;
                    dbName = Strings.getString("s", args, ++i);
                    break;
                }
                case 'h': {
                    UDDI.printUsage();
                    System.exit(-1);
                }
                case 'i': {
                    inquiryURL = Strings.getString("i", args, ++i);
                    break;
                }
                case 'o': {
                    siteOperator = Strings.getString("o", args, ++i);
                    break;
                }
                case 'p': {
                    publicationURL = Strings.getString("p", args, ++i);
                    break;
                }
                case 'r': {
                    root = Strings.getString("r", args, ++i);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal argument " + arg.charAt(1));
                }
            }
            ++i;
        }
        if (root == null && !sqlPersistence) {
            throw new IllegalArgumentException("missing root argument when using file based persistence");
        }
    }

    private static void uddi() throws Exception {
        Log.log(ILoggingConstants.COMMENT_EVENT, (Object)"starting Glue UDDI server");
        int lastInquirySlash = inquiryURL.lastIndexOf(47);
        String inquiryName = inquiryURL.substring(lastInquirySlash + 1);
        String inquiryContext = inquiryURL.substring(0, lastInquirySlash);
        String inquiryPath = READ_PATH + inquiryName;
        int lastPublicationSlash = publicationURL.lastIndexOf(47);
        String publicationName = publicationURL.substring(lastPublicationSlash + 1);
        String publicationContext = publicationURL.substring(0, lastPublicationSlash);
        String publicationPath = WRITE_PATH + publicationName;
        String adminPath = "/uddi/write/admin";
        HTTP.startup(inquiryContext, READ_PATH);
        HTTP.startup(publicationContext, WRITE_PATH);
        IUDDIStorage storage = sqlPersistence ? new SQLUDDIStorage(dbName, deleteContents) : new FileUDDIStorage(root, deleteContents);
        UDDIServer server = new UDDIServer(inquiryPath, publicationPath, adminPath, storage);
        server.setOperator(siteOperator);
        Log.log(ILoggingConstants.COMMENT_EVENT, (Object)("inquiry URL = " + inquiryURL));
        Log.log(ILoggingConstants.COMMENT_EVENT, (Object)("publication URL = " + publicationURL));
        Log.log(ILoggingConstants.COMMENT_EVENT, (Object)("admin WSDL = " + publicationContext + "/admin.wsdl"));
    }

    static {
        deleteContents = false;
        sqlPersistence = false;
    }
}

