/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi.server.sql;

import electric.sql.ConnectionPool;
import electric.sql.ConnectionPoolManager;
import electric.sql.SQLClient;
import electric.sql.mapping.ITable;
import electric.sql.mapping.ObjectMapper;
import electric.uddi.server.IUDDIStorage;
import electric.uddi.server.UDDIDictionary;
import electric.uddi.server.sql.AssertionTable;
import electric.uddi.server.sql.BindingTable;
import electric.uddi.server.sql.BusinessTable;
import electric.uddi.server.sql.ServiceTable;
import electric.uddi.server.sql.SubscriptionTable;
import electric.uddi.server.sql.TModelTable;
import electric.uddi.server.sql.UserTable;
import electric.util.dictionary.sql.SQLDictionary;
import electric.util.dictionary.transactional.TransactionalDictionary;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import java.sql.SQLException;
import java.util.Hashtable;

public class SQLUDDIStorage
implements IUDDIStorage,
ILoggingConstants {
    private final String databaseName;
    private final Hashtable nameToTable = new Hashtable();
    private ObjectMapper mapper;
    private boolean delete;

    public SQLUDDIStorage(String databaseName, boolean delete) {
        this.databaseName = databaseName;
        this.initialize(delete);
    }

    public SQLUDDIStorage(String driverName, String url, String user, String password, int maxSize, boolean delete) throws Exception {
        this.databaseName = "uddi";
        ConnectionPool pool = new ConnectionPool(driverName, url, user, password, maxSize);
        this.checkForDatabaseSchema(pool);
        ConnectionPoolManager.addPool(this.databaseName, pool);
        this.initialize(delete);
    }

    private void checkForDatabaseSchema(ConnectionPool pool) throws Exception {
        SQLClient client = new SQLClient(pool);
        String pingStmt = "select * from BUSINESS";
        try {
            client.select(pingStmt);
        }
        catch (SQLException exception) {
            this.createDatabase(client);
        }
    }

    private void initialize(boolean delete) {
        ITable table = new UserTable(this.databaseName);
        this.nameToTable.put("Users", table);
        table = new BusinessTable(this.databaseName);
        this.nameToTable.put("Business", table);
        table = new ServiceTable(this.databaseName);
        this.nameToTable.put("Service", table);
        table = new BindingTable(this.databaseName);
        this.nameToTable.put("Binding", table);
        table = new TModelTable(this.databaseName);
        this.nameToTable.put("TModel", table);
        table = new AssertionTable(this.databaseName);
        this.nameToTable.put("Assertion", table);
        table = new SubscriptionTable(this.databaseName);
        this.nameToTable.put("Subscription", table);
        this.mapper = new ObjectMapper(this.databaseName, this.nameToTable);
        this.delete = delete;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public boolean doesDictionaryExist(Class type) {
        return false;
    }

    public UDDIDictionary newDictionary(Class type, boolean encoded) {
        String tablename = this.convertToTableName(type);
        SQLDictionary persistentDictionary = new SQLDictionary(tablename, this.mapper, this.delete);
        TransactionalDictionary dictionary = new TransactionalDictionary(persistentDictionary);
        return new UDDIDictionary(dictionary);
    }

    private String convertToTableName(Class type) {
        String fullyQualifiedName = type.getName();
        if (fullyQualifiedName.indexOf(".") == -1) {
            return fullyQualifiedName;
        }
        Package pack = type.getPackage();
        String localName = fullyQualifiedName.substring(pack.getName().length() + 1);
        return localName.equals("User") ? "Users" : localName;
    }

    private void createDatabase(SQLClient sqlClient) throws Exception {
        if (Log.isLogging(ILoggingConstants.SQL_EVENT)) {
            Log.log(ILoggingConstants.SQL_EVENT, (Object)"creating uddi database tables");
        }
        String[] createScripts = new String[]{"CREATE TABLE ACCESS_POINT (ADDRESS\t\tVARCHAR(50) NOT NULL,URL_TYPE\t\tVARCHAR(10),BINDING_KEY\t\tVARCHAR(50),CONSTRAINT ACCESSPT_PRIMARY_KEY PRIMARY KEY (ADDRESS))", "CREATE TABLE ADDRESS (ADDRESSID\t\tINTEGER NOT NULL,CONTACTID\t\tINTEGER NOT NULL,USE_TYPE\t\tVARCHAR(20),SORT_CODE\t\tVARCHAR(15),CONSTRAINT ADDRESS_PRIMARY_KEY PRIMARY KEY (ADDRESSID) )", "CREATE TABLE ADDRESS_LINES (ADDRESSID\t\tINTEGER NOT NULL,LINE\t\t\tVARCHAR(50) NOT NULL,CONSTRAINT LINE_PRIMARY_KEY PRIMARY KEY ( ADDRESSID, LINE ) )", "CREATE TABLE ADDRESS_SEQUENCE (ADDRESS_SEQ\t\tINTEGER NOT NULL,STATUS\t\tVARCHAR(10) )", "CREATE TABLE ASSERTION (ASSERTION_KEY\t\tVARCHAR(150) NOT NULL,FROM_KEY\t\t\tVARCHAR(50),TO_KEY\t\t\tVARCHAR(50),FROM_USERNAME\t\tVARCHAR(50),TO_USERNAME\t\t\tVARCHAR(50),USER_NAME\t\t\tVARCHAR(50),CONSTRAINT ASSERTION_PRIMARY_KEY PRIMARY KEY ( ASSERTION_KEY ))", "CREATE TABLE ASSERTION_KEYS (USERID\t\tINTEGER NOT NULL,ASSERTION_KEY\t\tVARCHAR(250) NOT NULL,CONSTRAINT ASSERTION_KEYS_PRIMARY_KEY PRIMARY KEY (USERID, ASSERTION_KEY))", "CREATE TABLE BINDING (BINDING_KEY         \tVARCHAR(50) NOT NULL,SERVICE_KEY         \tVARCHAR(50),HOSTING_REDIRECTOR  \tVARCHAR(50),USER_NAME\t      \tVARCHAR(50),CONSTRAINT BINDING_PRIMARY_KEY PRIMARY KEY (BINDING_KEY))", "CREATE TABLE BINDING_KEYS (USERID\t\tINTEGER NOT NULL,BINDING_KEY\t\tVARCHAR(250) NOT NULL,CONSTRAINT BINDING_KEYS_PRIMARY_KEY PRIMARY KEY (USERID, BINDING_KEY))", "CREATE TABLE BUSINESS (BUSINESS_KEY        \tVARCHAR(50) NOT NULL,AUTHORIZED_NAME     \tVARCHAR(50),SITE_OPERATOR      \tVARCHAR(50),TIME\t\t     \tTIMESTAMP,USER_NAME\t\tVARCHAR(50),CONSTRAINT BUSINESS_PRIMARY_KEY PRIMARY KEY (BUSINESS_KEY) )", "CREATE TABLE BUSINESS_KEYS (USERID\t\tINTEGER NOT NULL,BUSINESS_KEY\tVARCHAR(250) NOT NULL,CONSTRAINT BUSINESS_KEYS_PRIMARY_KEY PRIMARY KEY (USERID, BUSINESS_KEY))", "CREATE TABLE CATEGORY  (CATEGORY_KEY\t\tVARCHAR(50) NOT NULL,NAME            \tVARCHAR(30) NOT NULL,VALUE           \tVARCHAR(30),TMODEL_KEY         \tVARCHAR(50),CONSTRAINT CATEGORY_PRIMARY_KEY PRIMARY KEY ( CATEGORY_KEY, NAME, VALUE ))", "CREATE TABLE CONTACT (CONTACTID\t      INTEGER NOT NULL,NAME                VARCHAR(30),BUSINESS_KEY        VARCHAR(50),USE_TYPE            VARCHAR(20),CONSTRAINT CONTACT_PRIMARY_KEY PRIMARY KEY (CONTACTID) )", "CREATE TABLE CONTACT_SEQUENCE (CONTACT_SEQ\t\tINTEGER NOT NULL,STATUS\t\tVARCHAR(10) )", "CREATE TABLE DESCRIPTION  (DESCRIPTION_KEY\tVARCHAR(50) NOT NULL,TEXT            \tVARCHAR(255) NOT NULL,LANGUAGE\t\tVARCHAR(20),CONSTRAINT DESCRIPTION_PRIMARY_KEY PRIMARY KEY ( DESCRIPTION_KEY ) )", "CREATE TABLE DISCOVERY_URL (URL                 VARCHAR(250),USE_TYPE            VARCHAR(20),BUSINESS_KEY        VARCHAR(50),CONSTRAINT DISCOVERY_URLS_PRIMARY_KEY PRIMARY KEY (URL) )", "CREATE TABLE EMAIL (ADDRESS\t\tVARCHAR(50) NOT NULL,USE_TYPE\t\tVARCHAR(20),CONTACTID\t\tINTEGER NOT NULL )", "CREATE TABLE IDENTIFIER (IDENTIFIER_KEY\t\tVARCHAR(250) NOT NULL,NAME\t\t\tVARCHAR(50) NOT NULL,VALUE\t\t\tVARCHAR(200) NOT NULL,TMODEL_KEY\t\tVARCHAR(50),CONSTRAINT IDENTIFIER_PRIMARY_KEY PRIMARY KEY ( IDENTIFIER_KEY ) )", "CREATE TABLE NAME (BUSINESS_KEY\t\tVARCHAR(50),TEXT\t\t\tVARCHAR(50),LANGUAGE\t\tVARCHAR(20) )", "CREATE TABLE OVERVIEW (OVERVIEW_URL\t     VARCHAR(255),TMODEL_KEY          VARCHAR(255) NOT NULL )", "CREATE TABLE PHONE (PHONE_NUMBER\t\tVARCHAR(20) NOT NULL,USE_TYPE\t\tVARCHAR(20),CONTACTID\t\tINTEGER NOT NULL)", "CREATE TABLE SERVICE (SERVICE_KEY         \tVARCHAR(50) NOT NULL,BUSINESS_KEY        \tVARCHAR(50),NAME\t             \tVARCHAR(40),USER_NAME\t\tVARCHAR(50),CONSTRAINT SERVICE_PRIMARY_KEY PRIMARY KEY (SERVICE_KEY) )", "CREATE TABLE SERVICE_KEYS (USERID\t\tINTEGER NOT NULL,SERVICE_KEY\t\tVARCHAR(250) NOT NULL,CONSTRAINT SERVICE_KEYS_PRIMARY_KEY PRIMARY KEY (USERID, SERVICE_KEY))", "CREATE TABLE SUBSCRIPTION (SUBSCRIPTION_KEY    VARCHAR(50) NOT NULL,BRIEF\t\t     VARCHAR(5),MAX_ENTITIES\t     INTEGER,BINDING_KEY         VARCHAR(50),CONSTRAINT SUBSCRIPTION_PRIMARY_KEY PRIMARY KEY (SUBSCRIPTION_KEY) )", "CREATE TABLE TMODEL  (TMODEL_KEY          \tVARCHAR(255) NOT NULL,NAME                \tVARCHAR(128),AUTHORIZED_NAME     \tVARCHAR(64),SITE_OPERATOR\t     \tVARCHAR(48),CHECKED\t     \tVARCHAR(5),USER_NAME\t\tVARCHAR(50), CONSTRAINT TMODEL_PRIMARY_KEY PRIMARY KEY (TMODEL_KEY))", "CREATE TABLE TMODEL_KEYS (USERID\t\tINTEGER NOT NULL,TMODEL_KEY\t\tVARCHAR(250) NOT NULL,CONSTRAINT TMODEL_KEYS_PRIMARY_KEY PRIMARY KEY (USERID, TMODEL_KEY))", "CREATE TABLE TMODEL_INSTANCE (TMODEL_KEY\t\tVARCHAR(50) NOT NULL,BINDING_KEY\t\tVARCHAR(50),PARAMS\t\tVARCHAR(50),CONSTRAINT TMODEL_INST_PRIMARY_KEY PRIMARY KEY (TMODEL_KEY))", "CREATE TABLE USERS (USERID\t     \tINTEGER NOT NULL,USERS_KEY\t\tVARCHAR(30),NAME               \tVARCHAR(30),PASSWORD\t     \tVARCHAR(15),PUBLISH\t     \tVARCHAR(15),ADMIN\t\t     \tVARCHAR(15),MAX_BUSINESSES\tINTEGER,MAX_SERVICES\t     \tINTEGER,MAX_BINDINGS\t     \tINTEGER,MAX_TMODELS\t     \tINTEGER,MAX_ASSERTIONS\tINTEGER,MAX_MESSAGE_SIZE    \tINTEGER,CONSTRAINT USER_PRIMARY_KEY PRIMARY KEY (USERID))", "CREATE TABLE USER_SEQUENCE (USER_SEQ\t\tINTEGER NOT NULL,STATUS\t\t\tVARCHAR(10));", "INSERT INTO ADDRESS_SEQUENCE ( ADDRESS_SEQ, STATUS ) VALUES ( 0, 'next' )", "INSERT INTO CONTACT_SEQUENCE ( CONTACT_SEQ, STATUS ) VALUES ( 0, 'next' )", "INSERT INTO USER_SEQUENCE ( USER_SEQ, STATUS ) VALUES ( 0, 'next' )"};
        sqlClient.execute(createScripts);
        if (Log.isLogging(ILoggingConstants.SQL_EVENT)) {
            Log.log(ILoggingConstants.SQL_EVENT, (Object)"completed creating uddi database tables");
        }
    }
}

