/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.Category;
import electric.uddi.Description;
import electric.uddi.ICategorized;
import electric.uddi.IIdentified;
import electric.uddi.IUDDIConstants;
import electric.uddi.Identifier;
import electric.uddi.Overview;
import electric.uddi.util.UDDIUtil;
import electric.util.array.ArrayUtil;
import electric.util.named.INamed;
import electric.util.string.Strings;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.ISerializable;
import electric.xml.io.IWriter;
import electric.xml.io.literal.LiteralWriter;
import java.io.IOException;

public final class TModel
implements ISerializable,
INamed,
ICategorized,
IIdentified,
IUDDIConstants {
    private String tModelKey = "";
    private String name;
    private boolean checked = false;
    private Description[] descriptions = new Description[0];
    private Overview overview;
    private Identifier[] identifiers = new Identifier[0];
    private Category[] categories = new Category[0];
    private boolean hidden;
    private String authorizedName;
    private String siteOperator;
    private String userName;
    static /* synthetic */ Class class$electric$uddi$Identifier;
    static /* synthetic */ Class class$electric$uddi$Category;

    public TModel() {
    }

    public TModel(String name) {
        this.name = name;
    }

    public TModel(String name, String tModelKey, String description, boolean checked) {
        this.name = name;
        this.tModelKey = tModelKey;
        this.descriptions = new Description[]{new Description(description)};
        this.checked = checked;
    }

    public String toString() {
        try {
            LiteralWriter writer = new LiteralWriter(new Element("TModel"));
            this.write(writer);
            return writer.getElement().toString();
        }
        catch (IOException exception) {
            return exception.toString();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof TModel)) {
            return false;
        }
        TModel tModel = (TModel)object;
        return this.tModelKey.equals(tModel.getTModelKey());
    }

    public void setTModelKey(String tModelKey) {
        this.tModelKey = tModelKey;
    }

    public String getTModelKey() {
        return this.tModelKey;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setAuthorizedName(String authorizedName) {
        this.authorizedName = authorizedName;
    }

    public String getAuthorizedName() {
        return this.authorizedName;
    }

    public void setOperator(String siteOperator) {
        this.siteOperator = siteOperator;
    }

    public String getOperator() {
        return this.siteOperator;
    }

    public void setOverview(Overview overview) {
        this.overview = overview;
    }

    public Overview getOverview() {
        return this.overview;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public Description[] getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(Description[] descriptions) {
        this.descriptions = descriptions;
    }

    public void addDescription(Description description) {
        this.descriptions = (Description[])ArrayUtil.addElement(this.descriptions, description);
    }

    public void removeDescription(Description description) {
        this.descriptions = (Description[])ArrayUtil.removeElement(this.descriptions, description);
    }

    public void addIdentifier(Identifier identifier) {
        this.identifiers = (Identifier[])ArrayUtil.addElement(this.identifiers, identifier);
    }

    public void removeIdentifier(Identifier identifier) {
        this.identifiers = (Identifier[])ArrayUtil.removeElement(this.identifiers, identifier);
    }

    public Identifier[] getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(Identifier[] identifiers) {
        this.identifiers = identifiers;
    }

    public void addCategory(Category category) {
        this.categories = (Category[])ArrayUtil.addElement(this.categories, category);
    }

    public void removeCategory(Category category) {
        this.categories = (Category[])ArrayUtil.removeElement(this.categories, category);
    }

    public Category[] getCategories() {
        return this.categories;
    }

    public void setCategories(Category[] categories) {
        this.categories = categories;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void write(IWriter writer) throws IOException {
        this.write(writer, true);
    }

    public void write(IWriter writer, boolean includeUserName) throws IOException {
        IWriter entity = writer.writeElement("tModel");
        entity.writeAttribute("tModelKey", this.tModelKey);
        if (this.authorizedName != null) {
            entity.writeAttribute("authorizedName", this.authorizedName);
        }
        if (this.siteOperator != null) {
            entity.writeAttribute("operator", this.siteOperator);
        }
        if (includeUserName && this.userName != null) {
            entity.writeAttribute("userName", this.userName);
        }
        entity.writeString("name", this.name);
        Description.writeList(entity, this.descriptions);
        if (this.overview != null) {
            this.overview.write(entity);
        }
        if (this.identifiers.length > 0) {
            Identifier.writeList(entity, this.identifiers);
        }
        if (this.categories.length > 0) {
            Category.writeList(entity, this.categories);
        }
        if (this.hidden) {
            entity.writeAttribute("hidden", "true");
        }
    }

    public void read(IReader reader) throws IOException {
        this.tModelKey = reader.readAttributeValue("tModelKey");
        this.authorizedName = reader.readAttributeValue("authorizedName");
        this.siteOperator = reader.readAttributeValue("operator");
        this.userName = reader.readAttributeValue("userName");
        this.checked = Strings.getBoolean(reader.readAttributeValue("checked"), false);
        this.name = reader.readString("name");
        this.descriptions = Description.readList(reader);
        IReader overviewDocXML = reader.getReader("overviewDoc");
        if (overviewDocXML != null) {
            this.overview = new Overview();
            this.overview.read(overviewDocXML);
        }
        this.identifiers = (Identifier[])UDDIUtil.readList(reader.getReader("identifierBag"), class$electric$uddi$Identifier == null ? (class$electric$uddi$Identifier = TModel.class$("electric.uddi.Identifier")) : class$electric$uddi$Identifier);
        this.categories = (Category[])UDDIUtil.readList(reader.getReader("categoryBag"), class$electric$uddi$Category == null ? (class$electric$uddi$Category = TModel.class$("electric.uddi.Category")) : class$electric$uddi$Category);
        this.hidden = Strings.getBoolean(reader.readAttributeValue("hidden"), false);
    }

    public static String[] readKeyList(IReader reader) {
        if (reader == null) {
            return new String[0];
        }
        IReader[] readers = reader.getReaders();
        String[] keys = new String[readers.length];
        int i = 0;
        while (i < readers.length) {
            keys[i] = readers[i].readString();
            ++i;
        }
        return keys;
    }

    public static void writeKeyList(IWriter writer, String[] typeKeys) {
        IWriter itemWriter = writer.writeElement("tModelBag");
        int i = 0;
        while (i < typeKeys.length) {
            itemWriter.writeString("tModelKey", typeKeys[i]);
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

