/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.http.OutboundHTTPRequest;
import electric.transaction.Transaction;
import electric.uddi.Authorization;
import electric.uddi.Business;
import electric.uddi.Businesses;
import electric.uddi.DeleteServices;
import electric.uddi.DiscoveryURL;
import electric.uddi.IPublicationCommand;
import electric.uddi.IUDDIServer;
import electric.uddi.SaveServices;
import electric.uddi.Service;
import electric.uddi.UDDIException;
import electric.uddi.admin.User;
import electric.uddi.util.UDDIUtil;
import electric.util.Context;
import electric.util.UUID;
import electric.xml.Document;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.literal.LiteralReader;
import java.io.IOException;

public final class SaveBusinesses
implements IPublicationCommand {
    private Business[] businesses;
    private String[] urls;
    static /* synthetic */ Class class$electric$uddi$Business;

    public SaveBusinesses() {
    }

    public SaveBusinesses(Business[] businesses) {
        this.businesses = businesses;
    }

    public SaveBusinesses(String[] urls) {
        this.urls = urls;
    }

    public String toString() {
        return UDDIUtil.toString(this);
    }

    public String getVersion() {
        if (this.businesses != null) {
            int i = 0;
            while (i < this.businesses.length) {
                if (this.businesses[i].getNames().length > 1) {
                    return "2.0";
                }
                ++i;
            }
        }
        return "1.0";
    }

    public boolean needsAuthorization() {
        return true;
    }

    public Object invoke(IUDDIServer server, Authorization authorization) throws UDDIException {
        if (this.urls != null) {
            return this.saveBusinesses(server, authorization, this.getBusinesses(this.urls));
        }
        return this.saveBusinesses(server, authorization, this.businesses);
    }

    private Business[] getBusinesses(String[] urls) throws UDDIException {
        Business[] businesses = new Business[urls.length];
        int i = 0;
        while (i < urls.length) {
            businesses[i] = new Business();
            try {
                byte[] bytes = new OutboundHTTPRequest().get(urls[i], new Context());
                Document document = new Document(bytes);
                businesses[i].read(new LiteralReader(document.getRoot()));
            }
            catch (Exception exception) {
                throw new UDDIException(exception.toString());
            }
            ++i;
        }
        return businesses;
    }

    private Businesses saveBusinesses(IUDDIServer server, Authorization authorization, Business[] businesses) throws UDDIException {
        try {
            Transaction.begin();
            User user = server.getPublisher(authorization);
            Business[] results = new Business[businesses.length];
            int i = 0;
            while (i < businesses.length) {
                results[i] = this.saveBusiness(server, businesses[i], user);
                ++i;
            }
            server.checkLimits(user);
            Transaction.commit();
            return new Businesses(results);
        }
        catch (UDDIException exception) {
            Transaction.rollback();
            throw exception;
        }
        catch (Throwable throwable) {
            Transaction.rollback();
            throw new UDDIException(throwable);
        }
    }

    private Business saveBusiness(IUDDIServer server, Business newBusiness, User user) throws UDDIException {
        if (newBusiness.getBusinessKey() == null) {
            newBusiness.setBusinessKey("");
        }
        this.saveBusinessPhase1(server, newBusiness, user);
        this.saveBusinessPhase2(server, newBusiness, user);
        return newBusiness;
    }

    private void saveBusinessPhase1(IUDDIServer server, Business newBusiness, User user) throws UDDIException {
        if (newBusiness.getBusinessKey().length() > 0 && !server.ownsBusiness(newBusiness.getBusinessKey(), user)) {
            throw new UDDIException(10140);
        }
        Service[] newServices = newBusiness.getServices();
        int i = 0;
        while (i < newServices.length) {
            SaveServices.saveServicePhase1(server, newServices[i], user);
            ++i;
        }
    }

    private void saveBusinessPhase2(IUDDIServer server, Business newBusiness, User user) throws UDDIException {
        newBusiness.setUserName(user.getName());
        if (newBusiness.getBusinessKey().length() == 0) {
            String key = new UUID().getKey();
            newBusiness.setBusinessKey(key);
            String url = server.getInquiryServletPath() + "/?businessKey=" + key;
            DiscoveryURL discoveryURL = new DiscoveryURL(url, "businessEntity");
            newBusiness.addDiscoveryURL(discoveryURL);
        } else {
            String[] oldServiceKeys = server.getServiceKeysForBusiness(newBusiness.getBusinessKey());
            int i = 0;
            while (i < oldServiceKeys.length) {
                if (newBusiness.getService(oldServiceKeys[i]) == null) {
                    DeleteServices.deleteService(server, oldServiceKeys[i], user);
                }
                ++i;
            }
        }
        Service[] newServices = newBusiness.getServices();
        int i = 0;
        while (i < newServices.length) {
            SaveServices.saveServicePhase2(server, newServices[i], user);
            ++i;
        }
        newBusiness.setOperator(server.getOperator());
        server.writeBusiness(newBusiness);
    }

    public void write(IWriter writer) throws IOException {
        IWriter query = writer.writeElement("save_business");
        if (this.businesses != null) {
            int i = 0;
            while (i < this.businesses.length) {
                this.businesses[i].write(query, true, true, false);
                ++i;
            }
        } else {
            UDDIUtil.writeStringList(query, "uploadRegister", this.urls);
        }
    }

    public void read(IReader reader) throws IOException {
        if (reader.readElement("businessEntity") != null) {
            IReader[] readers = reader.getReaders("businessEntity");
            this.businesses = (Business[])UDDIUtil.readList(readers, class$electric$uddi$Business == null ? (class$electric$uddi$Business = SaveBusinesses.class$("electric.uddi.Business")) : class$electric$uddi$Business);
        } else {
            this.urls = UDDIUtil.getTexts(reader, "uploadRegister");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

