/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.IUDDIConstants;
import electric.xml.io.IReader;
import electric.xml.io.ISerializable;
import electric.xml.io.IWriter;
import java.io.IOException;

public class KeyedReference
implements ISerializable,
IUDDIConstants {
    protected String name;
    protected String value;
    protected String tModelKey;

    public KeyedReference() {
    }

    public KeyedReference(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public KeyedReference(String name, String value, String tModelKey) {
        this.name = name;
        this.value = value;
        this.tModelKey = tModelKey;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof KeyedReference)) {
            return false;
        }
        KeyedReference reference = (KeyedReference)object;
        if (this.tModelKey != null && reference.tModelKey != null && !this.tModelKey.toLowerCase().equals(reference.tModelKey.toLowerCase())) {
            return false;
        }
        return this.name.equals(reference.name) && this.value.equals(reference.value);
    }

    public int hashCode() {
        return this.name.hashCode() + this.value.hashCode();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setTModelKey(String tModelKey) {
        this.tModelKey = tModelKey;
    }

    public String getTModelKey() {
        return this.tModelKey;
    }

    public void write(IWriter writer) throws IOException {
        IWriter child = writer.writeElement("keyedReference");
        child.writeAttribute("keyName", this.name);
        child.writeAttribute("keyValue", this.value);
        if (this.tModelKey != null) {
            child.writeAttribute("tModelKey", this.tModelKey);
        }
    }

    public void read(IReader reader) throws IOException {
        this.name = reader.readAttributeValue("keyName");
        this.value = reader.readAttributeValue("keyValue");
        this.tModelKey = reader.readAttributeValue("tModelKey");
    }
}

