/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.Authorization;
import electric.uddi.Business;
import electric.uddi.BusinessInfo;
import electric.uddi.IPublicationCommand;
import electric.uddi.IUDDIServer;
import electric.uddi.Registered;
import electric.uddi.ServiceInfo;
import electric.uddi.TModel;
import electric.uddi.TModelInfo;
import electric.uddi.UDDIException;
import electric.uddi.admin.User;
import electric.uddi.util.UDDIUtil;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import java.io.IOException;

public final class GetRegistered
implements IPublicationCommand {
    public String toString() {
        return UDDIUtil.toString(this);
    }

    public String getVersion() {
        return "1.0";
    }

    public boolean needsAuthorization() {
        return true;
    }

    public Object invoke(IUDDIServer server, Authorization authorization) throws UDDIException {
        User user = server.getPublisher(authorization);
        Business[] businesses = server.getBusinessesForUser(user);
        BusinessInfo[] businessInfos = new BusinessInfo[businesses.length];
        int i = 0;
        while (i < businesses.length) {
            Business business = businesses[i];
            String[] serviceKeys = server.getServiceKeysForBusiness(business.getBusinessKey());
            ServiceInfo[] serviceInfos = new ServiceInfo[serviceKeys.length];
            int j = 0;
            while (j < serviceInfos.length) {
                serviceInfos[j] = new ServiceInfo(server.readService(serviceKeys[j]));
                ++j;
            }
            businessInfos[i] = new BusinessInfo(business, serviceInfos);
            ++i;
        }
        TModel[] tModels = server.getTModelsForUser(user);
        TModelInfo[] tModelInfos = new TModelInfo[tModels.length];
        int i2 = 0;
        while (i2 < tModels.length) {
            tModelInfos[i2] = new TModelInfo(tModels[i2]);
            ++i2;
        }
        return new Registered(businessInfos, tModelInfos);
    }

    public void write(IWriter writer) throws IOException {
        writer.writeElement("get_registeredInfo");
    }

    public void read(IReader reader) throws IOException {
    }
}

