/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.Authorization;
import electric.uddi.Business;
import electric.uddi.Businesses;
import electric.uddi.GetServices;
import electric.uddi.IInquiryCommand;
import electric.uddi.ISubscriptionFilter;
import electric.uddi.IUDDIServer;
import electric.uddi.Service;
import electric.uddi.UDDIException;
import electric.uddi.selectors.BusinessKeySelector;
import electric.uddi.selectors.OrSelector;
import electric.uddi.util.UDDIUtil;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import java.io.IOException;

public class GetBusinesses
implements IInquiryCommand,
ISubscriptionFilter {
    protected String[] businessKeys;
    private transient OrSelector selector;

    public GetBusinesses() {
    }

    public GetBusinesses(String[] businessKeys) {
        this.businessKeys = businessKeys;
    }

    public String toString() {
        return UDDIUtil.toString(this);
    }

    public String getVersion() {
        return "1.0";
    }

    public boolean needsAuthorization() {
        return false;
    }

    public Object invoke(IUDDIServer server, Authorization authorization) throws UDDIException {
        Business[] businesses = new Business[this.businessKeys.length];
        int i = 0;
        while (i < businesses.length) {
            businesses[i] = this.getBusiness(server, this.businessKeys[i]);
            ++i;
        }
        return new Businesses(businesses);
    }

    private Business getBusiness(IUDDIServer server, String businessKey) throws UDDIException {
        Business business = new Business(server.readBusiness(businessKey));
        String[] serviceKeys = server.getServiceKeysForBusiness(businessKey);
        Service[] fullServices = new Service[serviceKeys.length];
        int i = 0;
        while (i < serviceKeys.length) {
            fullServices[i] = GetServices.getService(server, serviceKeys[i]);
            ++i;
        }
        business.setServices(fullServices);
        return business;
    }

    public synchronized OrSelector getSelector() {
        if (this.selector != null) {
            return this.selector;
        }
        this.selector = new OrSelector();
        int i = 0;
        while (i < this.businessKeys.length) {
            this.selector.addSelector(new BusinessKeySelector(this.businessKeys[i]));
            ++i;
        }
        return this.selector;
    }

    public void write(IWriter writer) throws IOException {
        IWriter query = writer.writeElement("get_businessDetail");
        int i = 0;
        while (i < this.businessKeys.length) {
            query.writeString("businessKey", this.businessKeys[i]);
            ++i;
        }
    }

    public void read(IReader reader) throws IOException {
        this.businessKeys = UDDIUtil.getTexts(reader, "businessKey");
    }
}

