/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.Authorization;
import electric.uddi.Binding;
import electric.uddi.Bindings;
import electric.uddi.IInquiryCommand;
import electric.uddi.ISubscriptionFilter;
import electric.uddi.IUDDIServer;
import electric.uddi.UDDIException;
import electric.uddi.util.UDDIUtil;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import java.io.IOException;

public final class GetBindings
implements IInquiryCommand,
ISubscriptionFilter {
    private String[] bindingKeys;

    public GetBindings() {
    }

    public GetBindings(String[] bindingKeys) {
        this.bindingKeys = bindingKeys;
    }

    public String toString() {
        return UDDIUtil.toString(this);
    }

    public String getVersion() {
        return "1.0";
    }

    public boolean needsAuthorization() {
        return false;
    }

    public Object invoke(IUDDIServer server, Authorization authorization) throws UDDIException {
        Binding[] results = new Binding[this.bindingKeys.length];
        int i = 0;
        while (i < results.length) {
            results[i] = server.readBinding(this.bindingKeys[i]);
            ++i;
        }
        return new Bindings(results);
    }

    public void write(IWriter writer) throws IOException {
        IWriter query = writer.writeElement("get_bindingDetail");
        int i = 0;
        while (i < this.bindingKeys.length) {
            query.writeString("bindingKey", this.bindingKeys[i]);
            ++i;
        }
    }

    public void read(IReader reader) throws IOException {
        this.bindingKeys = UDDIUtil.getTexts(reader, "bindingKey");
    }
}

