/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.Assertion;
import electric.uddi.Assertions;
import electric.uddi.Authorization;
import electric.uddi.IPublicationCommand;
import electric.uddi.IUDDIServer;
import electric.uddi.Identifier;
import electric.uddi.UDDIException;
import electric.uddi.admin.User;
import electric.uddi.selectors.AssertionSelector;
import electric.uddi.util.UDDIUtil;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public final class GetAssertions
implements IPublicationCommand {
    public String toString() {
        return UDDIUtil.toString(this);
    }

    public String getVersion() {
        return "2.0";
    }

    public boolean needsAuthorization() {
        return true;
    }

    public Object invoke(IUDDIServer server, Authorization authorization) throws UDDIException {
        return GetAssertions.getAssertions(server, authorization);
    }

    public static Assertions getAssertions(IUDDIServer server, Authorization authorization) throws UDDIException {
        User user = server.getPublisher(authorization);
        Assertions assertions = new Assertions();
        assertions.list = server.getAssertionsForUser(user);
        return assertions;
    }

    public static Assertion[] getAssertions(IUDDIServer server, String businessKey, String status, Identifier keyedReference) throws UDDIException {
        String[] businessKeys = new String[]{businessKey};
        AssertionSelector selector = new AssertionSelector(status, businessKeys, keyedReference);
        Vector<Assertion> list = new Vector<Assertion>();
        Enumeration enumeration = server.getAssertions();
        while (enumeration.hasMoreElements()) {
            Assertion assertion = (Assertion)enumeration.nextElement();
            if (!selector.selects(server, assertion)) continue;
            list.addElement(assertion);
        }
        Object[] assertions = new Assertion[list.size()];
        list.copyInto(assertions);
        return assertions;
    }

    public void write(IWriter writer) throws IOException {
        IWriter iWriter = writer.writeElement("get_publisherAssertions");
    }

    public void read(IReader reader) throws IOException {
    }
}

