/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.Assertion;
import electric.uddi.Authorization;
import electric.uddi.Business;
import electric.uddi.GetAssertions;
import electric.uddi.IInquiryCommand;
import electric.uddi.ISubscriptionFilter;
import electric.uddi.IUDDIServer;
import electric.uddi.Identifier;
import electric.uddi.Qualifier;
import electric.uddi.RelatedBusinessInfo;
import electric.uddi.RelatedBusinessInfos;
import electric.uddi.UDDIException;
import electric.uddi.util.UDDIUtil;
import electric.util.array.ArrayUtil;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import java.io.IOException;
import java.util.Hashtable;

public final class FindRelatedBusinesses
implements IInquiryCommand,
ISubscriptionFilter {
    private String businessKey;
    private Identifier keyedReference;
    private Qualifier qualifier = Qualifier.DEFAULT;

    public FindRelatedBusinesses() {
    }

    public FindRelatedBusinesses(String businessKey, Identifier keyedReference, Qualifier qualifier) {
        this.businessKey = businessKey;
        this.keyedReference = keyedReference;
        this.qualifier = qualifier != null ? qualifier : Qualifier.DEFAULT;
    }

    public String toString() {
        return UDDIUtil.toString(this);
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public Identifier getKeyedReference() {
        return this.keyedReference;
    }

    public void setKeyedReference(Identifier keyedReference) {
        this.keyedReference = keyedReference;
    }

    public Qualifier getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(Qualifier qualifier) {
        this.qualifier = qualifier;
    }

    public String getVersion() {
        return "2.0";
    }

    public boolean needsAuthorization() {
        return false;
    }

    public Object invoke(IUDDIServer server, Authorization authorization) throws UDDIException {
        server.readBusiness(this.businessKey);
        if (this.keyedReference != null) {
            server.readTModel(this.keyedReference.getTModelKey());
        }
        RelatedBusinessInfo[] infos = new RelatedBusinessInfo[]{};
        Hashtable<String, RelatedBusinessInfo> relatedBusinessInfos = new Hashtable<String, RelatedBusinessInfo>();
        Assertion[] assertions = GetAssertions.getAssertions(server, this.businessKey, "status:complete", this.keyedReference);
        int i = 0;
        while (i < assertions.length) {
            String relatedBusinessKey = assertions[i].getRelatedKey(this.businessKey);
            RelatedBusinessInfo info = (RelatedBusinessInfo)relatedBusinessInfos.get(relatedBusinessKey);
            if (info == null) {
                Business business = server.readBusiness(relatedBusinessKey);
                info = new RelatedBusinessInfo(business, assertions[i].getKeyedReference());
                infos = (RelatedBusinessInfo[])ArrayUtil.addElement(infos, info);
                relatedBusinessInfos.put(relatedBusinessKey, info);
            } else {
                info.addRelationship(assertions[i].getKeyedReference());
            }
            ++i;
        }
        return new RelatedBusinessInfos(infos, false);
    }

    public void write(IWriter writer) throws IOException {
        IWriter query = writer.writeElement("find_relatedBusinesses");
        query.writeString("businessKey", this.businessKey);
        this.qualifier.write(query);
        if (this.keyedReference != null) {
            this.keyedReference.write(query);
        }
    }

    public void read(IReader reader) throws IOException {
        this.businessKey = reader.readString("businessKey");
        this.qualifier = Qualifier.readQualifier(reader);
        this.keyedReference = Identifier.readIdentifier(reader);
    }
}

