/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.transaction.Transaction;
import electric.uddi.Authorization;
import electric.uddi.IPublicationCommand;
import electric.uddi.IUDDIServer;
import electric.uddi.UDDIException;
import electric.uddi.admin.User;
import electric.uddi.util.UDDIUtil;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import java.io.IOException;

public final class DeleteBindings
implements IPublicationCommand {
    private String[] bindingKeys;

    public DeleteBindings() {
    }

    public DeleteBindings(String[] bindingKeys) {
        this.bindingKeys = bindingKeys;
    }

    public String toString() {
        return UDDIUtil.toString(this);
    }

    public String getVersion() {
        return "1.0";
    }

    public boolean needsAuthorization() {
        return true;
    }

    public Object invoke(IUDDIServer server, Authorization authorization) throws UDDIException {
        try {
            Transaction.begin();
            User user = server.getPublisher(authorization);
            int i = 0;
            while (i < this.bindingKeys.length) {
                DeleteBindings.deleteBinding(server, this.bindingKeys[i], user);
                ++i;
            }
            server.checkLimits(user);
            Transaction.commit();
            return null;
        }
        catch (UDDIException exception) {
            Transaction.rollback();
            throw exception;
        }
        catch (Throwable throwable) {
            Transaction.rollback();
            throw new UDDIException(throwable);
        }
    }

    public static void deleteBinding(IUDDIServer server, String bindingKey, User user) throws UDDIException {
        if (!server.ownsBinding(bindingKey, user)) {
            throw new UDDIException(10140);
        }
        server.eraseBinding(bindingKey);
    }

    public void write(IWriter writer) throws IOException {
        IWriter query = writer.writeElement("delete_binding");
        UDDIUtil.writeStringList(query, "bindingKey", this.bindingKeys);
    }

    public void read(IReader reader) throws IOException {
        this.bindingKeys = UDDIUtil.getTexts(reader, "bindingKey");
    }
}

