/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.Address;
import electric.uddi.Description;
import electric.uddi.Email;
import electric.uddi.IUDDIConstants;
import electric.uddi.Name;
import electric.uddi.Phone;
import electric.uddi.util.UDDIUtil;
import electric.util.array.ArrayUtil;
import electric.xml.io.IReader;
import electric.xml.io.ISerializable;
import electric.xml.io.IWriter;
import java.io.IOException;

public final class Contact
implements ISerializable,
IUDDIConstants {
    private Name[] personNames = new Name[0];
    private String useType;
    private Description[] descriptions = new Description[0];
    private Phone[] phones = new Phone[0];
    private Email[] emails = new Email[0];
    private Address[] addresses = new Address[0];
    static /* synthetic */ Class class$electric$uddi$Phone;
    static /* synthetic */ Class class$electric$uddi$Email;
    static /* synthetic */ Class class$electric$uddi$Address;

    public Contact() {
    }

    public Contact(String personName) {
        this.addPersonName(new Name(personName));
    }

    public String toString() {
        return "Contact( name: " + this.getPersonName() + " )";
    }

    public Name[] getPersonNames() {
        return this.personNames;
    }

    public void setPersonNames(Name[] names) {
        this.personNames = names;
    }

    public void addPersonName(Name name) {
        this.personNames = (Name[])ArrayUtil.addElement(this.personNames, name);
    }

    public void removePersonName(Name name) {
        this.personNames = (Name[])ArrayUtil.removeElement(this.personNames, name);
    }

    public String getPersonName() {
        return this.personNames.length == 0 ? null : this.personNames[0].getText();
    }

    public void setPersonName(String text) {
        this.personNames = new Name[]{new Name(text)};
    }

    public void setUseType(String useType) {
        this.useType = useType;
    }

    public String getUseType() {
        return this.useType;
    }

    public Description[] getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(Description[] descriptions) {
        this.descriptions = descriptions;
    }

    public void addDescription(Description description) {
        this.descriptions = (Description[])ArrayUtil.addElement(this.descriptions, description);
    }

    public void removeDescription(Description description) {
        this.descriptions = (Description[])ArrayUtil.removeElement(this.descriptions, description);
    }

    public void addPhone(Phone phone) {
        this.phones = (Phone[])ArrayUtil.addElement(this.phones, phone);
    }

    public void removePhone(Phone phone) {
        this.phones = (Phone[])ArrayUtil.removeElement(this.phones, phone);
    }

    public Phone[] getPhones() {
        return this.phones;
    }

    public void addEmail(Email email) {
        this.emails = (Email[])ArrayUtil.addElement(this.emails, email);
    }

    public void removeEmail(Email email) {
        this.emails = (Email[])ArrayUtil.removeElement(this.emails, email);
    }

    public Email[] getEmails() {
        return this.emails;
    }

    public void addAddress(Address address) {
        this.addresses = (Address[])ArrayUtil.addElement(this.addresses, address);
    }

    public void removeAddress(Address address) {
        this.addresses = (Address[])ArrayUtil.removeElement(this.addresses, address);
    }

    public Address[] getAddresses() {
        return this.addresses;
    }

    public void write(IWriter writer) throws IOException {
        IWriter entity = writer.writeElement("contact");
        if (this.useType != null) {
            entity.writeAttribute("useType", this.useType);
        }
        Description.writeList(entity, this.descriptions);
        int i = 0;
        while (i < this.personNames.length) {
            IWriter name = entity.writeElement("personName");
            if (this.personNames[i].hasLanguage()) {
                name.writeAttribute("xml:lang", this.personNames[i].getLanguage());
            }
            name.writeString(this.personNames[i].getText());
            ++i;
        }
        UDDIUtil.writeList(entity, this.phones);
        UDDIUtil.writeList(entity, this.emails);
        UDDIUtil.writeList(entity, this.addresses);
    }

    public void read(IReader reader) throws IOException {
        this.useType = reader.readAttributeValue("useType");
        this.descriptions = Description.readList(reader);
        IReader[] readers = reader.getReaders("personName");
        this.personNames = new Name[readers.length];
        int i = 0;
        while (i < this.personNames.length) {
            this.personNames[i] = new Name();
            this.personNames[i].read(readers[i]);
            ++i;
        }
        this.phones = (Phone[])UDDIUtil.readList(reader.getReaders("phone"), class$electric$uddi$Phone == null ? (class$electric$uddi$Phone = Contact.class$("electric.uddi.Phone")) : class$electric$uddi$Phone);
        this.emails = (Email[])UDDIUtil.readList(reader.getReaders("email"), class$electric$uddi$Email == null ? (class$electric$uddi$Email = Contact.class$("electric.uddi.Email")) : class$electric$uddi$Email);
        this.addresses = (Address[])UDDIUtil.readList(reader.getReaders("address"), class$electric$uddi$Address == null ? (class$electric$uddi$Address = Contact.class$("electric.uddi.Address")) : class$electric$uddi$Address);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

