/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.Category;
import electric.uddi.Contact;
import electric.uddi.Description;
import electric.uddi.DiscoveryURL;
import electric.uddi.ICategorized;
import electric.uddi.IIdentified;
import electric.uddi.IUDDIConstants;
import electric.uddi.Identifier;
import electric.uddi.Name;
import electric.uddi.Service;
import electric.uddi.util.UDDIUtil;
import electric.util.array.ArrayUtil;
import electric.util.named.INamed;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.ISerializable;
import electric.xml.io.IWriter;
import electric.xml.io.literal.LiteralWriter;
import java.io.IOException;

public class Business
implements ISerializable,
INamed,
ICategorized,
IIdentified,
IUDDIConstants {
    private String businessKey = "";
    private Name[] names = new Name[0];
    private Service[] services = new Service[0];
    private DiscoveryURL[] discoveryURLs = new DiscoveryURL[0];
    private Description[] descriptions = new Description[0];
    private Contact[] contacts = new Contact[0];
    private Identifier[] identifiers = new Identifier[0];
    private Category[] categories = new Category[0];
    private String authorizedName;
    private String siteOperator;
    private String userName;
    static /* synthetic */ Class class$electric$uddi$DiscoveryURL;
    static /* synthetic */ Class class$electric$uddi$Contact;
    static /* synthetic */ Class class$electric$uddi$Service;
    static /* synthetic */ Class class$electric$uddi$Identifier;
    static /* synthetic */ Class class$electric$uddi$Category;

    public Business() {
    }

    public Business(String name) {
        this.addName(new Name(name));
    }

    public Business(Name name) {
        this.addName(name);
    }

    public Business(Business business) {
        this.businessKey = business.businessKey;
        this.names = business.names;
        this.services = business.services;
        this.authorizedName = business.authorizedName;
        this.siteOperator = business.siteOperator;
        this.discoveryURLs = business.discoveryURLs;
        this.descriptions = business.descriptions;
        this.contacts = business.contacts;
        this.identifiers = business.identifiers;
        this.categories = business.categories;
        this.userName = business.userName;
    }

    public String toString() {
        try {
            LiteralWriter writer = new LiteralWriter(new Element("Business"));
            this.write(writer, true, false, false);
            return writer.getElement().toString();
        }
        catch (IOException exception) {
            return exception.toString();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Business)) {
            return false;
        }
        Business business = (Business)object;
        return this.businessKey.equals(business.getBusinessKey());
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
        int i = 0;
        while (i < this.services.length) {
            this.services[i].setBusinessKey(businessKey);
            ++i;
        }
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public Name[] getNames() {
        return this.names;
    }

    public void setNames(Name[] names) {
        this.names = names;
    }

    public void addName(Name name) {
        this.names = (Name[])ArrayUtil.addElement(this.names, name);
    }

    public void removeName(Name name) {
        this.names = (Name[])ArrayUtil.removeElement(this.names, name);
    }

    public String getName() {
        return this.names.length == 0 ? null : this.names[0].getText();
    }

    public void setName(String text) {
        this.names = new Name[]{new Name(text)};
    }

    public void setAuthorizedName(String authorizedName) {
        this.authorizedName = authorizedName;
    }

    public String getAuthorizedName() {
        return this.authorizedName;
    }

    public void setOperator(String siteOperator) {
        this.siteOperator = siteOperator;
    }

    public String getOperator() {
        return this.siteOperator;
    }

    public Description[] getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(Description[] descriptions) {
        this.descriptions = descriptions;
    }

    public void addDescription(Description description) {
        this.descriptions = (Description[])ArrayUtil.addElement(this.descriptions, description);
    }

    public void removeDescription(Description description) {
        this.descriptions = (Description[])ArrayUtil.removeElement(this.descriptions, description);
    }

    public void addDiscoveryURL(DiscoveryURL discoveryURL) {
        this.discoveryURLs = (DiscoveryURL[])ArrayUtil.addElement(this.discoveryURLs, discoveryURL);
    }

    public void removeDiscoveryURL(DiscoveryURL discoveryURL) {
        this.discoveryURLs = (DiscoveryURL[])ArrayUtil.removeElement(this.discoveryURLs, discoveryURL);
    }

    public DiscoveryURL[] getDiscoveryURLs() {
        return this.discoveryURLs;
    }

    public void addContact(Contact contact) {
        this.contacts = (Contact[])ArrayUtil.addElement(this.contacts, contact);
    }

    public void removeContact(Contact contact) {
        this.contacts = (Contact[])ArrayUtil.removeElement(this.contacts, contact);
    }

    public Contact[] getContacts() {
        return this.contacts;
    }

    public void setContacts(Contact[] contacts) {
        this.contacts = contacts;
    }

    public void addService(Service service) {
        this.removeService(service.getServiceKey());
        service.setBusinessKey(this.businessKey);
        this.services = (Service[])ArrayUtil.addElement(this.services, service);
    }

    public void removeService(Service service) {
        this.removeService(service.getServiceKey());
    }

    public void removeService(String serviceKey) {
        int i = 0;
        while (i < this.services.length) {
            if (serviceKey.equals(this.services[i].getServiceKey())) {
                this.services = (Service[])ArrayUtil.removeElementAt(this.services, i);
                return;
            }
            ++i;
        }
    }

    public Service[] getServices() {
        return this.services;
    }

    public String[] getServiceKeys() {
        String[] serviceKeys = new String[this.services.length];
        int i = 0;
        while (i < this.services.length) {
            serviceKeys[i] = this.services[i].getServiceKey();
            ++i;
        }
        return serviceKeys;
    }

    public Service getService(String serviceKey) {
        int i = 0;
        while (i < this.services.length) {
            if (serviceKey.equals(this.services[i].getServiceKey())) {
                return this.services[i];
            }
            ++i;
        }
        return null;
    }

    public void setServices(Service[] services) {
        this.services = services;
    }

    public void addIdentifier(Identifier identifier) {
        this.identifiers = (Identifier[])ArrayUtil.addElement(this.identifiers, identifier);
    }

    public void removeIdentifier(Identifier identifier) {
        this.identifiers = (Identifier[])ArrayUtil.removeElement(this.identifiers, identifier);
    }

    public Identifier[] getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(Identifier[] identifiers) {
        this.identifiers = identifiers;
    }

    public void addCategory(Category category) {
        this.categories = (Category[])ArrayUtil.addElement(this.categories, category);
    }

    public void removeCategory(Category category) {
        this.categories = (Category[])ArrayUtil.removeElement(this.categories, category);
    }

    public Category[] getCategories() {
        return this.categories;
    }

    public void setCategories(Category[] categories) {
        this.categories = categories;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void write(IWriter writer) throws IOException {
        this.write(writer, false, false, true);
    }

    public void write(IWriter writer, boolean includeServices, boolean publishing, boolean includeUserName) throws IOException {
        int i;
        IWriter entity = writer.writeElement("businessEntity");
        entity.writeAttribute("businessKey", this.businessKey);
        if (!publishing && this.authorizedName != null) {
            entity.writeAttribute("authorizedName", this.authorizedName);
        }
        if (!publishing && this.siteOperator != null) {
            entity.writeAttribute("operator", this.siteOperator);
        }
        if (includeUserName && this.userName != null) {
            entity.writeAttribute("userName", this.userName);
        }
        if (this.discoveryURLs.length > 0) {
            IWriter urls = entity.writeElement("discoveryURLs");
            i = 0;
            while (i < this.discoveryURLs.length) {
                this.discoveryURLs[i].write(urls);
                ++i;
            }
        }
        Name.writeList(entity, this.names);
        Description.writeList(entity, this.descriptions);
        if (this.contacts.length > 0) {
            UDDIUtil.writeList(entity, "contacts", this.contacts);
        }
        if (includeServices && this.services.length > 0) {
            IWriter businessServices = entity.writeElement("businessServices");
            i = 0;
            while (i < this.services.length) {
                this.services[i].write(businessServices, true, includeUserName);
                ++i;
            }
        }
        if (this.identifiers.length > 0) {
            Identifier.writeList(entity, this.identifiers);
        }
        if (this.categories.length > 0) {
            Category.writeList(entity, this.categories);
        }
    }

    public void read(IReader reader) throws IOException {
        this.businessKey = reader.readAttributeValue("businessKey");
        this.authorizedName = reader.readAttributeValue("authorizedName");
        this.siteOperator = reader.readAttributeValue("operator");
        this.userName = reader.readAttributeValue("userName");
        this.names = Name.readList(reader);
        this.discoveryURLs = (DiscoveryURL[])UDDIUtil.readList(reader.getReader("discoveryURLs"), class$electric$uddi$DiscoveryURL == null ? (class$electric$uddi$DiscoveryURL = Business.class$("electric.uddi.DiscoveryURL")) : class$electric$uddi$DiscoveryURL);
        this.descriptions = Description.readList(reader);
        this.contacts = (Contact[])UDDIUtil.readList(reader.getReader("contacts"), class$electric$uddi$Contact == null ? (class$electric$uddi$Contact = Business.class$("electric.uddi.Contact")) : class$electric$uddi$Contact);
        Service[] services = (Service[])UDDIUtil.readList(reader.getReader("businessServices"), class$electric$uddi$Service == null ? (class$electric$uddi$Service = Business.class$("electric.uddi.Service")) : class$electric$uddi$Service);
        int i = 0;
        while (i < services.length) {
            this.addService(services[i]);
            ++i;
        }
        this.identifiers = (Identifier[])UDDIUtil.readList(reader.getReader("identifierBag"), class$electric$uddi$Identifier == null ? (class$electric$uddi$Identifier = Business.class$("electric.uddi.Identifier")) : class$electric$uddi$Identifier);
        this.categories = (Category[])UDDIUtil.readList(reader.getReader("categoryBag"), class$electric$uddi$Category == null ? (class$electric$uddi$Category = Business.class$("electric.uddi.Category")) : class$electric$uddi$Category);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

