/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.AccessPoint;
import electric.uddi.Description;
import electric.uddi.IUDDIConstants;
import electric.uddi.TModelInstance;
import electric.uddi.util.UDDIUtil;
import electric.util.array.ArrayUtil;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.ISerializable;
import electric.xml.io.IWriter;
import electric.xml.io.literal.LiteralWriter;
import java.io.IOException;

public final class Binding
implements ISerializable,
IUDDIConstants {
    private String bindingKey = "";
    private String serviceKey;
    private Description[] descriptions = new Description[0];
    private AccessPoint accessPoint;
    private String hostingRedirector;
    private TModelInstance[] tModelInstances = new TModelInstance[0];
    private String userName;
    static /* synthetic */ Class class$electric$uddi$TModelInstance;

    public String toString() {
        try {
            LiteralWriter writer = new LiteralWriter(new Element("Binding"));
            this.write(writer, false);
            return writer.getElement().toString();
        }
        catch (IOException exception) {
            return exception.toString();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Binding)) {
            return false;
        }
        Binding binding = (Binding)object;
        return this.bindingKey.equals(binding.getBindingKey());
    }

    public void setBindingKey(String bindingKey) {
        this.bindingKey = bindingKey;
    }

    public String getBindingKey() {
        return this.bindingKey;
    }

    public void setServiceKey(String serviceKey) {
        this.serviceKey = serviceKey;
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public Description[] getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(Description[] descriptions) {
        this.descriptions = descriptions;
    }

    public void addDescription(Description description) {
        this.descriptions = (Description[])ArrayUtil.addElement(this.descriptions, description);
    }

    public void removeDescription(Description description) {
        this.descriptions = (Description[])ArrayUtil.removeElement(this.descriptions, description);
    }

    public void setAccessPoint(AccessPoint accessPoint) {
        this.accessPoint = accessPoint;
    }

    public AccessPoint getAccessPoint() {
        return this.accessPoint;
    }

    public void setHostingRedirector(String hostingRedirector) {
        this.hostingRedirector = hostingRedirector;
    }

    public String getHostingRedirector() {
        return this.hostingRedirector;
    }

    public void addTModelInstance(TModelInstance tModelInstance) {
        this.tModelInstances = (TModelInstance[])ArrayUtil.addElement(this.tModelInstances, tModelInstance);
    }

    public void removeTModelInstance(TModelInstance tModelInstance) {
        this.tModelInstances = (TModelInstance[])ArrayUtil.removeElement(this.tModelInstances, tModelInstance);
    }

    public TModelInstance[] getTModelInstances() {
        return this.tModelInstances;
    }

    public void setTModelInstances(TModelInstance[] tModelInstances) {
        this.tModelInstances = tModelInstances;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void write(IWriter writer) throws IOException {
        this.write(writer, true);
    }

    public void write(IWriter writer, boolean includeUserName) throws IOException {
        IWriter entity = writer.writeElement("bindingTemplate");
        entity.writeAttribute("bindingKey", this.bindingKey);
        entity.writeAttribute("serviceKey", this.serviceKey);
        if (includeUserName && this.userName != null) {
            entity.writeAttribute("userName", this.userName);
        }
        Description.writeList(entity, this.descriptions);
        if (this.accessPoint != null) {
            this.accessPoint.write(entity);
        }
        if (this.hostingRedirector != null) {
            entity.writeElement("hostingRedirector").writeAttribute("bindingKey", this.hostingRedirector);
        }
        if (this.tModelInstances.length > 0) {
            UDDIUtil.writeList(entity, "tModelInstanceDetails", this.tModelInstances);
        }
    }

    public void read(IReader reader) throws IOException {
        IReader hostingRedirectorXML;
        this.bindingKey = reader.readAttributeValue("bindingKey");
        this.serviceKey = reader.readAttributeValue("serviceKey");
        this.userName = reader.readAttributeValue("userName");
        this.descriptions = Description.readList(reader);
        IReader accessPointXML = reader.getReader("accessPoint");
        if (accessPointXML != null) {
            this.accessPoint = new AccessPoint();
            this.accessPoint.read(accessPointXML);
        }
        if ((hostingRedirectorXML = reader.getReader("hostingRedirector")) != null) {
            this.hostingRedirector = hostingRedirectorXML.readAttributeValue("bindingKey");
        }
        this.tModelInstances = (TModelInstance[])UDDIUtil.readList(reader.getReader("tModelInstanceDetails"), class$electric$uddi$TModelInstance == null ? (class$electric$uddi$TModelInstance = Binding.class$("electric.uddi.TModelInstance")) : class$electric$uddi$TModelInstance);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

