/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.Assertion;
import electric.uddi.IUDDIConstants;
import electric.uddi.IUDDIServer;
import electric.uddi.UDDIException;
import electric.uddi.admin.User;
import electric.util.array.ArrayUtil;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.ISerializable;
import electric.xml.io.IWriter;
import electric.xml.io.literal.LiteralWriter;
import java.io.IOException;

public final class AssertionStatus
implements ISerializable,
IUDDIConstants {
    private Assertion assertion;
    private String status;
    private boolean ownsFromKey;
    private boolean ownsToKey;

    public AssertionStatus() {
    }

    public AssertionStatus(IUDDIServer server, String status, Assertion assertion, User user) throws UDDIException {
        this.status = status;
        this.assertion = assertion;
        this.ownsFromKey = assertion.getFromKey() != null && server.ownsBusiness(assertion.getFromKey(), user);
        this.ownsToKey = assertion.getToKey() != null && server.ownsBusiness(assertion.getToKey(), user);
    }

    public String toString() {
        try {
            LiteralWriter writer = new LiteralWriter(new Element("assertionStatusItem"));
            this.write(writer);
            return writer.getElement().getFirstElement().toString();
        }
        catch (IOException exception) {
            return exception.toString();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AssertionStatus)) {
            return false;
        }
        AssertionStatus assertionStatus = (AssertionStatus)object;
        if (!ArrayUtil.equals(this.assertion, assertionStatus.assertion)) {
            return false;
        }
        if (!ArrayUtil.equals(this.status, assertionStatus.status)) {
            return false;
        }
        if (this.ownsFromKey != assertionStatus.ownsFromKey) {
            return false;
        }
        return this.ownsToKey == assertionStatus.ownsToKey;
    }

    public Assertion getAssertion() {
        return this.assertion;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean ownsFromKey() {
        return this.ownsFromKey;
    }

    public boolean ownsToKey() {
        return this.ownsToKey;
    }

    public static boolean isValidStatus(String status) {
        if (status == null) {
            return true;
        }
        if (status.equals("status:complete")) {
            return true;
        }
        if (status.equals("status:fromKey_incomplete")) {
            return true;
        }
        return status.equals("status:toKey_incomplete");
    }

    public void write(IWriter writer) throws IOException {
        IWriter item = writer.writeElement("assertionStatusItem");
        item.writeAttribute("completionStatus", this.status);
        this.assertion.write(item, false, false);
        IWriter keysOwned = item.writeElement("keysOwned");
        if (this.ownsFromKey) {
            keysOwned.writeString("fromKey", this.assertion.getFromKey());
        }
        if (this.ownsToKey) {
            keysOwned.writeString("toKey", this.assertion.getToKey());
        }
    }

    public void read(IReader reader) throws IOException {
        this.status = reader.getElement().getAttributeValue("completionStatus");
        IReader assertionReader = reader.getReader("publisherAssertion");
        this.assertion = new Assertion();
        this.assertion.read(assertionReader);
        Element keysOwned = reader.readElement("keysOwned");
        this.ownsFromKey = keysOwned.getElement("fromKey") != null;
        this.ownsToKey = keysOwned.getElement("toKey") != null;
    }
}

