/*
 * Decompiled with CFR 0.152.
 */
package electric.transaction;

import electric.transaction.ITransactional;
import electric.transaction.TransactionException;
import electric.util.Context;
import electric.util.array.ArrayUtil;

public class Transaction {
    private static final String TRANSACTION = "transaction";
    private ITransactional[] participants = new ITransactional[0];

    private Transaction() {
    }

    public ITransactional[] getParticipants() {
        return this.participants;
    }

    public void addParticipant(ITransactional participant) {
        this.participants = (ITransactional[])ArrayUtil.addElement(this.participants, participant);
    }

    public void removeParticipant(ITransactional participant) {
        this.participants = (ITransactional[])ArrayUtil.removeElement(this.participants, participant);
    }

    public void commitTransaction() {
        int i = 0;
        while (i < this.participants.length) {
            try {
                this.participants[i].commit();
            }
            catch (TransactionException exception) {
                // empty catch block
            }
            ++i;
        }
    }

    public void rollbackTransaction() {
        int i = 0;
        while (i < this.participants.length) {
            try {
                this.participants[i].rollback();
            }
            catch (TransactionException exception) {
                // empty catch block
            }
            ++i;
        }
    }

    public static Transaction current() {
        return (Transaction)Context.thread().getProperty(TRANSACTION);
    }

    public static Transaction begin() throws TransactionException {
        Context context = Context.thread();
        if (context.getProperty(TRANSACTION) != null) {
            throw new TransactionException("already in transaction");
        }
        Transaction transaction = new Transaction();
        context.setProperty(TRANSACTION, transaction);
        return transaction;
    }

    public static Transaction commit() throws TransactionException {
        Transaction transaction = (Transaction)Context.thread().removeProperty(TRANSACTION);
        if (transaction == null) {
            throw new TransactionException("not in transaction");
        }
        transaction.commitTransaction();
        return transaction;
    }

    public static Transaction rollback() throws TransactionException {
        Transaction transaction = (Transaction)Context.thread().removeProperty(TRANSACTION);
        if (transaction == null) {
            throw new TransactionException("not in transaction");
        }
        transaction.rollbackTransaction();
        return transaction;
    }
}

