/*
 * Decompiled with CFR 0.152.
 */
package electric.sql.mapping;

import electric.sql.SQLClient;
import electric.sql.mapping.ITable;
import electric.util.log.ILoggingConstants;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ObjectMapper
implements ILoggingConstants {
    private Hashtable nameToTable;
    private SQLClient command;

    public ObjectMapper(String databaseName, Hashtable nameToTable) {
        this.nameToTable = nameToTable;
        this.command = new SQLClient(databaseName);
    }

    public Object select(Object key, String tablename) throws SQLException {
        return this.getTable(tablename).select(key);
    }

    public void insert(Object value, String tablename) throws SQLException {
        this.getTable(tablename).insert(value);
    }

    public void delete(Object key, String tablename) throws SQLException {
        this.getTable(tablename).delete(key);
    }

    public void clearTable(String tablename) throws SQLException {
        this.getTable(tablename).clear();
    }

    public ITable getTable(String tablename) {
        return (ITable)this.nameToTable.get(tablename);
    }

    public Enumeration getKeys(String table) throws SQLException {
        String query = "SELECT " + table + "_key from " + table;
        StringBuffer buffer = new StringBuffer();
        ResultSet rs = this.command.select(query);
        while (rs.next()) {
            buffer.append(rs.getString(1)).append(" ");
        }
        return new StringTokenizer(buffer.toString());
    }

    public boolean isEmpty(String table) throws SQLException {
        int count = 0;
        String query = "SELECT count(*) from " + table;
        ResultSet rs = this.command.select(query);
        if (rs.next()) {
            count = rs.getInt(1);
        }
        return count == 0;
    }
}

