/*
 * Decompiled with CFR 0.152.
 */
package electric.sql;

import electric.sql.ISQLConstants;
import electric.util.Context;
import electric.util.classloader.ClassLoaders;
import electric.util.license.Enabler;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.Product;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Vector;

public class ConnectionPool
implements ISQLConstants,
ILoggingConstants {
    private static boolean enabled;
    private static boolean allowEnable;
    private int maxSize;
    private String driver;
    private String url;
    private String user;
    private String password;
    private Vector connections = new Vector();

    public ConnectionPool(String driverName, String url, String user, String password) throws Exception {
        this(driverName, url, user, password, 10);
    }

    public ConnectionPool(String driverName, String url, String user, String password, int maxSize) throws Exception {
        this.checkEnabled();
        this.maxSize = maxSize;
        this.driver = driverName;
        this.url = url;
        this.user = user;
        this.password = password;
        this.initialize();
    }

    public ConnectionPool(Context context) throws Exception {
        this(context.getStringProperty("driver"), context.getStringProperty("databaseURL"), context.getStringProperty("user"), context.getStringProperty("password"), context.getIntProperty("maxSize", 10));
    }

    private void initialize() throws Exception {
        Class driverClass = ClassLoaders.loadClass(this.driver);
        DriverManager.registerDriver((Driver)driverClass.newInstance());
        int i = 0;
        while (i < this.maxSize) {
            this.connections.add(this.getConnection());
            ++i;
        }
    }

    private Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.url, this.user, this.password);
    }

    public synchronized Connection checkOutConnection() throws SQLException {
        if (this.connections.size() > 0) {
            return (Connection)this.connections.remove(0);
        }
        return this.getConnection();
    }

    public synchronized void checkInConnection(Connection connection) {
        if (this.connections.size() < this.maxSize) {
            this.connections.add(connection);
        } else {
            this.closeConnection(connection);
        }
    }

    private void closeConnection(Connection connection) {
        block2: {
            try {
                connection.close();
            }
            catch (SQLException exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block2;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
        }
    }

    public void connectionClosed() throws SQLException {
        try {
            Connection connection = this.checkOutConnection();
            if (connection == null || connection.isClosed()) {
                connection = DriverManager.getConnection(this.url, this.user, this.password);
                this.connections.clear();
                this.initialize();
            }
        }
        catch (Exception exception) {
            throw new SQLException("database server is down");
        }
    }

    public static void enable() {
        if (enabled) {
            return;
        }
        if (!allowEnable) {
            throw new IllegalStateException("connection pooling cannot be enabled once it is disabled");
        }
        enabled = Enabler.enable();
        if (!enabled && Log.isLogging(ILoggingConstants.WARNING_EVENT)) {
            Log.log(ILoggingConstants.WARNING_EVENT, (Object)"connection pooling feature cannot be enabled");
        }
    }

    public static void disable() {
        enabled = false;
        allowEnable = false;
        Log.log(ILoggingConstants.WARNING_EVENT, (Object)"Connection Pooling is disabled.  This feature requires GLUE Professional");
    }

    private void checkEnabled() {
        if (!enabled) {
            throw new IllegalStateException("ConnectionPool is disabled");
        }
    }

    static {
        allowEnable = true;
        Product.startup();
    }
}

