/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.wsdl;

import electric.glue.IGLUEContextConstants;
import electric.glue.IGLUELoggingConstants;
import electric.service.descriptor.MethodDescriptor;
import electric.soap.ISOAPAction;
import electric.soap.ISOAPConstants;
import electric.soap.wsdl.SOAP12Binding;
import electric.soap.wsdl.SOAP12Operation;
import electric.soap.wsdl.SOAPBinding;
import electric.soap.wsdl.SOAPMessageDecl;
import electric.soap.wsdl.SOAPOperation;
import electric.soap.wsdl.SOAPWriterFactory;
import electric.soap.wsdl.personality.ISOAPPersonality;
import electric.util.Context;
import electric.util.array.ArrayUtil;
import electric.util.dime.IDIMEConstants;
import electric.util.license.Enabler;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.mime.IMIMEConstants;
import electric.wsdl.IWSDLConstants;
import electric.wsdl.MessageDecl;
import electric.wsdl.Operation;
import electric.wsdl.WSDL;
import electric.wsdl.WSDLException;
import electric.wsdl.loader.WSDLLoader;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.io.schema.SchemaException;
import java.lang.reflect.Method;

public class SOAPOperationFactory
implements ISOAPConstants,
IWSDLConstants,
IGLUEContextConstants,
IDIMEConstants,
IMIMEConstants,
IGLUELoggingConstants {
    private static boolean enabled;
    private static boolean allowEnable;

    public static SOAPOperation getSOAPOperation(SOAPBinding binding, Element soapOperation) throws WSDLException, SchemaException {
        Element outputElement;
        String name = soapOperation.getAttributeValue("name");
        Operation[] operations = binding.getPortType().getOperationsWithName(name);
        Element inputElement = soapOperation.getElement("input");
        Operation operation = SOAPOperationFactory.getOperation(binding, name, inputElement, outputElement = soapOperation.getElement("output"));
        if (operation == null) {
            throw new WSDLException("could not find operation " + name);
        }
        Element soapElement = soapOperation.getElement("operation");
        String soapAction = null;
        String style = null;
        if (soapElement != null) {
            soapAction = "\"" + soapElement.getAttributeValue("soapAction") + "\"";
            style = soapElement.getAttributeValue("style");
        } else {
            soapAction = "\"\"";
        }
        if (style == null) {
            style = binding.getStyle();
        }
        SOAPMessageDecl input = null;
        if (inputElement != null) {
            input = new SOAPMessageDecl(inputElement, operation.getInput(), "input");
        }
        SOAPMessageDecl output = null;
        if (outputElement != null) {
            output = new SOAPMessageDecl(outputElement, operation.getOutput(), "output");
        }
        SOAPMessageDecl[] faults = null;
        if (Operation.processFaults()) {
            faults = SOAPOperationFactory.getSOAPFaults(operation, soapOperation);
        }
        SOAPOperation soapOper = new SOAPOperation();
        soapOper.setBinding(binding);
        soapOper.setNamespaces(binding.getNamespaces());
        soapOper.setInput(input);
        soapOper.setOutput(output);
        if (Operation.processFaults()) {
            soapOper.setFaults(faults);
        }
        soapOper.setOperation(operation);
        boolean polymorphic = operations.length > 1;
        soapOper.setPolymorphic(polymorphic);
        soapOper.setSoapAction(soapAction);
        soapOper.setWriter(SOAPWriterFactory.getWriter(soapOper, soapOperation));
        soapOper.setParameterFlags();
        return soapOper;
    }

    private static SOAPMessageDecl[] getSOAPFaults(Operation operation, Element soapOperation) throws WSDLException {
        SOAPMessageDecl[] faults = null;
        Elements faultElements = soapOperation.getElements("fault");
        if (faultElements != null && faultElements.size() > 0) {
            faults = new SOAPMessageDecl[]{};
            while (faultElements.hasMoreElements()) {
                Element faultElement = (Element)faultElements.nextElement();
                SOAPMessageDecl soapFaultDecl = SOAPOperationFactory.getSOAPFault(operation, faultElement);
                if (soapFaultDecl == null) continue;
                faults = (SOAPMessageDecl[])ArrayUtil.addElement(faults, soapFaultDecl);
            }
        }
        return faults;
    }

    private static SOAPMessageDecl getSOAPFault(Operation operation, Element faultElement) throws WSDLException {
        MessageDecl[] faultDecls;
        Element soapFaultElement = faultElement.getElement("fault");
        if (soapFaultElement == null) {
            return null;
        }
        String faultName = soapFaultElement.getAttribute("name");
        if (faultName == null) {
            faultName = faultElement.getAttribute("name");
        }
        if ((faultDecls = operation.getFaults()) == null) {
            return null;
        }
        MessageDecl faultDecl = null;
        int i = 0;
        while (i < faultDecls.length) {
            MessageDecl decl = faultDecls[i];
            if (decl.getName().equals(faultName)) {
                faultDecl = decl;
                break;
            }
            ++i;
        }
        if (faultDecl != null) {
            return new SOAPMessageDecl(faultElement, faultDecl, "fault");
        }
        return null;
    }

    private static Operation getOperation(SOAPBinding binding, String name, Element inputElement, Element outputElement) {
        Operation operation = null;
        Operation[] operations = binding.getPortType().getOperationsWithName(name);
        int i = 0;
        while (i < operations.length) {
            Operation candidate = operations[i];
            if (binding.getSOAPOperation(candidate) == null && SOAPOperationFactory.isCompatible(inputElement, candidate.getInput()) && SOAPOperationFactory.isCompatible(outputElement, candidate.getOutput())) {
                operation = candidate;
                break;
            }
            ++i;
        }
        return operation;
    }

    public static SOAPOperation getSOAPOperation(SOAPBinding binding, MethodDescriptor[] methods, int index, Object operationNamespace, String use, Object action, Context serviceContext) throws WSDLException, SchemaException {
        Method method = methods[index].getMethod();
        String style = binding.getStyle();
        SOAPOperation soapOperation = null;
        String messageDeclNamespace = null;
        if (binding instanceof SOAP12Binding) {
            soapOperation = new SOAP12Operation();
            messageDeclNamespace = "http://schemas.xmlsoap.org/wsdl/soap12/";
        } else {
            soapOperation = new SOAPOperation();
            messageDeclNamespace = "http://schemas.xmlsoap.org/wsdl/soap/";
        }
        soapOperation.setMethod(method);
        soapOperation.setBinding(binding);
        soapOperation.setNamespaces(binding.getNamespaces());
        WSDL wsdl = binding.getWSDL();
        boolean rpc = style == null || style.equalsIgnoreCase("rpc");
        soapOperation.setOperation(new Operation(wsdl, binding.getNamespace(), methods[index], index, "", methods[index].getReturnName(), rpc));
        String methodName = soapOperation.getMethodName();
        boolean first = true;
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getMethod().getName().equals(methodName)) {
                if (first) {
                    first = false;
                } else {
                    soapOperation.setPolymorphic(true);
                }
            }
            ++i;
        }
        MessageDecl outputType = soapOperation.getOperation().getOutput();
        String operationNamespaceString = null;
        if (operationNamespace instanceof String) {
            operationNamespaceString = (String)operationNamespace;
        } else if (rpc && operationNamespace instanceof ISOAPPersonality) {
            operationNamespaceString = ((ISOAPPersonality)operationNamespace).getOperationNamespace(soapOperation);
        }
        String encodingStyle = binding instanceof SOAP12Binding ? "http://www.w3.org/2003/05/soap-encoding" : "http://schemas.xmlsoap.org/soap/encoding/";
        soapOperation.setInput(new SOAPMessageDecl(soapOperation.getOperation().getInput(), operationNamespaceString, use, encodingStyle, "input", messageDeclNamespace));
        String attachmentStyle = (String)serviceContext.getProperty("attachmentStyle");
        if (attachmentStyle != null) {
            soapOperation.getInput().setAttachmentStyle(attachmentStyle);
        }
        if (!outputType.isVoid()) {
            soapOperation.setOutput(new SOAPMessageDecl(outputType, operationNamespaceString, use, encodingStyle, "output", messageDeclNamespace));
            if (attachmentStyle != null) {
                soapOperation.getOutput().setAttachmentStyle(attachmentStyle);
            }
        }
        MessageDecl[] faultDecls = null;
        if (Operation.processFaults()) {
            faultDecls = soapOperation.getOperation().getFaults();
        }
        if (faultDecls != null) {
            SOAPMessageDecl[] faults = new SOAPMessageDecl[]{};
            int i2 = 0;
            while (i2 < faultDecls.length) {
                MessageDecl faultDecl = faultDecls[i2];
                SOAPMessageDecl soapFaultDecl = new SOAPMessageDecl(faultDecl, operationNamespaceString, use, "http://schemas.xmlsoap.org/soap/encoding/", "fault", messageDeclNamespace);
                faults = (SOAPMessageDecl[])ArrayUtil.addElement(faults, soapFaultDecl);
                ++i2;
            }
            soapOperation.setFaults(faults);
        }
        if (action instanceof String) {
            soapOperation.setSoapAction((String)action);
        } else if (action instanceof ISOAPAction) {
            soapOperation.setSoapAction(((ISOAPAction)action).getSOAPAction(soapOperation));
        }
        soapOperation.setWriter(SOAPWriterFactory.getWriter(soapOperation, style, use, encodingStyle));
        soapOperation.setParameterFlags();
        return soapOperation;
    }

    private static boolean isCompatible(Element element, MessageDecl messageDecl) {
        if (element == null && messageDecl == null || element == null && messageDecl.isVoid()) {
            return true;
        }
        if (element == null && messageDecl != null || element != null && messageDecl == null) {
            return false;
        }
        String elementName = element.getAttributeValue("name");
        return elementName == null || elementName.equals(messageDecl.getName());
    }

    public static void enable() {
        if (enabled) {
            return;
        }
        if (!allowEnable) {
            throw new IllegalStateException("Virtual Service cannot be enabled once it is disabled");
        }
        enabled = Enabler.enable();
        if (!enabled && Log.isLogging(ILoggingConstants.WARNING_EVENT)) {
            Operation.setProcessFaults(false);
            Log.log(ILoggingConstants.WARNING_EVENT, (Object)"SOAP/WSDL faults feature cannot be enabled");
        }
    }

    public static void disable() {
        enabled = false;
        allowEnable = false;
        Operation.setProcessFaults(false);
        WSDLLoader.clearCache();
        Log.log(ILoggingConstants.WARNING_EVENT, (Object)"SOAP/WSDL faults feature disabled");
    }

    private static void checkEnabled() {
    }

    static {
        allowEnable = true;
    }
}

