/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.wsdl;

import electric.glue.IGLUELoggingConstants;
import electric.soap.ISOAPConstants;
import electric.soap.SOAPException;
import electric.soap.SOAPMessage;
import electric.soap.SOAPOptimizations;
import electric.soap.rpc.Parameter;
import electric.soap.rpc.Return;
import electric.soap.util.SOAPAttachments;
import electric.soap.wsdl.ISOAPWriter;
import electric.soap.wsdl.SOAPBinding;
import electric.soap.wsdl.SOAPFault;
import electric.soap.wsdl.SOAPMessageDecl;
import electric.util.Value;
import electric.util.array.ArrayUtil;
import electric.util.dime.IDIMEConstants;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.reflect.IOperation;
import electric.wsdl.IWSDLConstants;
import electric.wsdl.Operation;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Namespaces;
import electric.xml.io.Type;
import electric.xml.io.encoded.EncodedWriter;
import electric.xml.io.mime.MIMEType;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaProperties;
import java.io.IOException;
import java.lang.reflect.Method;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;

public class SOAPOperation
implements ISOAPConstants,
IOperation,
IGLUELoggingConstants,
IWSDLConstants,
IDIMEConstants {
    private SOAPBinding binding;
    private SOAPMessageDecl input;
    private SOAPMessageDecl output;
    private SOAPMessageDecl[] faults;
    private Operation operation;
    private String soapAction;
    private boolean soapActionRequired = true;
    private int inArgCount;
    private int outArgCount;
    private int attachmentCount;
    public Parameter[] parameters;
    private Return returnValue;
    private Class[] argClasses;
    private Class[] inArgClasses;
    private boolean polymorphic;
    private Method method;
    private Namespaces namespaces;
    private ISOAPWriter writer;

    public String toString() {
        return "SOAPOperation( " + this.getOperation() + " )";
    }

    public String getMethodName() {
        return this.getOperation().getName();
    }

    public boolean isAsync() {
        return this.getOutput() == null;
    }

    public boolean isRPC() {
        return this.writer.isRPC();
    }

    public void setParameterFlags() throws SchemaException {
        int i = 0;
        while (i < this.parameters.length) {
            Parameter parameter = this.parameters[i];
            if (parameter.isInput()) {
                this.setInArgCount(this.inArgCount + 1);
            }
            if (parameter.isOutput()) {
                this.setOutArgCount(this.outArgCount + 1);
            }
            if (parameter.getType() instanceof MIMEType) {
                this.setAttachmentCount(this.attachmentCount + 1);
            }
            ++i;
        }
        if (this.getReturnValue() != null && this.getReturnValue().getType() instanceof MIMEType) {
            this.setAttachmentCount(this.attachmentCount + 1);
        }
    }

    public String getSOAPAction() {
        return this.getSoapAction();
    }

    public boolean isSoapActionRequired() {
        if (this.binding.getBindingNamespace().equals("http://schemas.xmlsoap.org/wsdl/soap/")) {
            return true;
        }
        return this.soapActionRequired;
    }

    public void setSoapActionRequired(boolean soapActionRequired) {
        this.soapActionRequired = soapActionRequired;
    }

    public boolean hasAttachments() {
        return this.getAttachmentCount() > 0;
    }

    public String getVersion() {
        return this.getNamespaces().getVersion();
    }

    public int getInArgCount() {
        return this.inArgCount;
    }

    public int getOutArgCount() {
        return this.outArgCount;
    }

    public synchronized Class[] getArgClasses() throws ClassNotFoundException {
        if (this.argClasses != null) {
            return this.argClasses;
        }
        this.argClasses = new Class[this.parameters.length];
        int i = 0;
        while (i < this.parameters.length) {
            this.argClasses[i] = this.parameters[i].getJavaClass();
            ++i;
        }
        return this.argClasses;
    }

    public synchronized Class[] getInArgClasses() throws ClassNotFoundException {
        if (this.inArgClasses != null) {
            return this.inArgClasses;
        }
        this.inArgClasses = new Class[0];
        int i = 0;
        while (i < this.parameters.length) {
            if (this.parameters[i].isInput()) {
                try {
                    Type type = this.parameters[i].getType();
                    Class javaClass = type.getJavaClassWithCheck();
                    this.inArgClasses = (Class[])ArrayUtil.addElement(this.inArgClasses, javaClass);
                }
                catch (SchemaException exception) {
                    if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                        Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
                    }
                    throw new ClassNotFoundException(exception.toString());
                }
            }
            ++i;
        }
        return this.inArgClasses;
    }

    public void removeParameters() {
        this.setInArgCount(0);
        this.setOutArgCount(0);
        this.parameters = new Parameter[0];
        this.setArgClasses(null);
        this.setInArgClasses(null);
    }

    public void addParameter(Parameter parameter) {
        this.parameters = (Parameter[])ArrayUtil.addElement(this.parameters, parameter);
    }

    public int getParameterCount() {
        return this.parameters.length;
    }

    void writeWSDL(Element binding) {
        String wsdlPrefix = binding.getNamespacePrefix("http://schemas.xmlsoap.org/wsdl/");
        Element operationElement = binding.addElement(wsdlPrefix, "operation");
        operationElement.setAttribute("name", this.getOperation().getName());
        Element soapOperation = operationElement.addElement("soap", "operation");
        soapOperation.setAttribute("soapAction", this.getSoapAction());
        this.writer.writeStyle(soapOperation);
        if (this.getInput() != null) {
            this.getInput().writeWSDL(operationElement);
        }
        if (this.getOutput() != null) {
            this.getOutput().writeWSDL(operationElement);
        }
        if (this.faults != null) {
            int i = 0;
            while (i < this.faults.length) {
                this.faults[i].writeWSDL(operationElement);
                ++i;
            }
        }
    }

    public void writeRequest(SOAPMessage request, SOAPOptimizations optimizations, Object[] args) throws MarshalException {
        if (this.binding.getBindingNamespace().equals("http://schemas.xmlsoap.org/wsdl/soap12/")) {
            request.setSoapVersion("http://www.w3.org/2003/05/soap-envelope");
        } else {
            request.setSoapVersion("http://schemas.xmlsoap.org/soap/envelope/");
        }
        if (this.hasAttachments()) {
            request.setAttachmentStyle(this.getInput().getAttachmentStyle());
            SOAPAttachments.addRequestAttachments(request, this.parameters, args);
        }
        this.writer.setDocument(request, optimizations);
        if (this.isAsync()) {
            Element async = new Element();
            String prefix = async.getPrefix(SchemaProperties.getTmeNamespace(), "tme");
            async.setName(prefix, "async");
            request.addHeaderElement(async);
        }
        try {
            IWriter writer = this.writer.getRequestWriter(request);
            int i = 0;
            while (i < this.parameters.length) {
                this.parameters[i].writeRequest(writer, args[i]);
                ++i;
            }
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
            throw new MarshalException(exception.toString());
        }
    }

    public Value readResponse(SOAPMessage response, Object[] args) throws UnmarshalException {
        if (this.getOutArgCount() == 0 && this.getReturnValue() == null) {
            return Value.NULL;
        }
        try {
            IReader reader = this.writer.getReader(response);
            if (response.hasAttachments()) {
                SOAPAttachments.registerAttachments(response, reader);
            }
            int i = 0;
            while (i < this.parameters.length) {
                this.parameters[i].readResponse(reader, args[i]);
                ++i;
            }
            return this.getReturnValue() == null ? Value.NULL : this.getReturnValue().readResponse(reader, null);
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
            throw new UnmarshalException(exception.toString());
        }
    }

    public void writeResponse(SOAPMessage response, SOAPOptimizations requestOptimizations, Object[] args, Value result) throws MarshalException {
        if (this.hasAttachments()) {
            response.setAttachmentStyle(this.getOutput().getAttachmentStyle());
            SOAPAttachments.addResponseAttachments(response, this.parameters, this.getReturnValue(), args, result);
        }
        this.writer.setDocument(response, requestOptimizations);
        try {
            IWriter writer = this.writer.getResponseWriter(response);
            if (this.getReturnValue() != null) {
                this.getReturnValue().writeResponse(writer, result.getObject());
            }
            int i = 0;
            while (i < this.parameters.length) {
                this.parameters[i].writeResponse(writer, args[i]);
                ++i;
            }
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
            throw new MarshalException(exception.toString());
        }
    }

    public Object[] getArgs(SOAPMessage request) throws UnmarshalException {
        Object[] args = new Object[this.parameters.length];
        IReader reader = null;
        if (this.getInArgCount() > 0) {
            reader = this.writer.getReader(request);
            if (request.hasAttachments()) {
                SOAPAttachments.registerAttachments(request, reader);
            }
        }
        try {
            int i = 0;
            while (i < this.parameters.length) {
                args[i] = this.parameters[i].readRequest(reader).getObject();
                ++i;
            }
        }
        catch (IOException exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
            throw new UnmarshalException(exception.toString());
        }
        return args;
    }

    public Namespaces getNamespaces() {
        if (this.namespaces != null) {
            return this.namespaces;
        }
        if (this.getBinding() != null) {
            this.namespaces = this.getBinding().getNamespaces();
            return this.namespaces;
        }
        return null;
    }

    public ISOAPWriter getWriter() {
        return this.writer;
    }

    public void setWriter(ISOAPWriter writer) {
        this.writer = writer;
    }

    public SOAPOptimizations selectOptimizations(SOAPOptimizations optimizations) {
        return this.writer.selectOptimizations(optimizations);
    }

    public SOAPBinding getBinding() {
        return this.binding;
    }

    public void setBinding(SOAPBinding binding) {
        this.binding = binding;
    }

    public SOAPMessageDecl getInput() {
        return this.input;
    }

    public void setInput(SOAPMessageDecl input) {
        this.input = input;
    }

    public SOAPMessageDecl getOutput() {
        return this.output;
    }

    public void setOutput(SOAPMessageDecl output) {
        this.output = output;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public int getAttachmentCount() {
        return this.attachmentCount;
    }

    public void setAttachmentCount(int attachmentCount) {
        this.attachmentCount = attachmentCount;
    }

    public Return getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(Return returnValue) {
        this.returnValue = returnValue;
    }

    public void setInArgCount(int inArgCount) {
        this.inArgCount = inArgCount;
    }

    public void setOutArgCount(int outArgCount) {
        this.outArgCount = outArgCount;
    }

    public void setArgClasses(Class[] argClasses) {
        this.argClasses = argClasses;
    }

    public void setInArgClasses(Class[] inArgClasses) {
        this.inArgClasses = inArgClasses;
    }

    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    public void setPolymorphic(boolean polymorphic) {
        this.polymorphic = polymorphic;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setNamespaces(Namespaces namespaces) {
        this.namespaces = namespaces;
    }

    public SOAPMessageDecl[] getFaults() {
        return this.faults;
    }

    public void setFaults(SOAPMessageDecl[] faults) {
        this.faults = faults;
    }

    public SOAPMessageDecl getMatchingFault(Throwable exception) throws SchemaException {
        if (this.faults == null) {
            return null;
        }
        if (exception instanceof SOAPException) {
            return null;
        }
        SOAPMessageDecl bestMatch = null;
        int i = 0;
        while (i < this.faults.length) {
            SOAPMessageDecl fault = this.faults[i];
            Class faultClass = fault.messageDecl.getMessage().getPart(0).getType().getJavaClass();
            if (faultClass == exception.getClass()) {
                bestMatch = fault;
                break;
            }
            if (faultClass.isAssignableFrom(exception.getClass())) {
                bestMatch = fault;
            }
            ++i;
        }
        return bestMatch;
    }

    public SOAPMessage generateFault(Exception exception, SOAPMessage request) {
        return this.generateSOAP11Fault(exception, request);
    }

    public SOAPMessage generateSOAP11Fault(Exception exception, SOAPMessage request) {
        if (exception instanceof SOAPException) {
            return null;
        }
        try {
            SOAPMessage response = new SOAPMessage();
            SOAPOptimizations optimizations = SOAPOptimizations.NONE;
            this.writer.setDocument(response, optimizations);
            Element body = response.getBody();
            String envPrefix = body.getPrefix("http://schemas.xmlsoap.org/soap/envelope/", "soap");
            SOAPMessageDecl faultDecl = this.getMatchingFault(exception);
            if (faultDecl == null) {
                return null;
            }
            Element faultElement = body.addElement(envPrefix, "Fault");
            EncodedWriter faultElementWriter = new EncodedWriter(faultElement);
            Type declaredFaultType = faultDecl.messageDecl.getMessage().getParts()[0].getType();
            String faultCode = envPrefix + ":Server";
            String faultActor = null;
            if (exception instanceof SOAPException) {
                SOAPException soapException = (SOAPException)exception;
                faultCode = soapException.getSOAPCode();
                faultActor = soapException.getSOAPActor();
            }
            IWriter faultCodeWriter = faultElementWriter.writeElement(envPrefix, "faultcode");
            faultCodeWriter.writeString(faultCode);
            IWriter faultStringWriter = faultElementWriter.writeElement(envPrefix, "faultstring");
            faultStringWriter.writeString(exception.getMessage());
            IWriter faultDetailWriter = faultElementWriter.writeElement(envPrefix, "detail");
            if (faultActor != null) {
                IWriter faultActorWriter = faultElementWriter.writeElement(envPrefix, "faultactor");
                faultActorWriter.writeString(faultActor);
            }
            String faultName = faultDecl.messageDecl.getMessage().getPart(0).getType().getName();
            String faultNamespace = faultDecl.messageDecl.getMessage().getPart(0).getType().getNamespace();
            String faultPrefix = body.getPrefix(faultNamespace);
            IWriter faultWriter = faultDetailWriter.writeElement(faultPrefix, faultName);
            declaredFaultType.writeObject(faultWriter, exception);
            return response;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private SOAPMessageDecl matchFaultToWSDLFault(String faultName) {
        int i = 0;
        while (i < this.faults.length) {
            String declaredFaultName;
            if (this.faults[i] != null && this.faults[i].messageDecl != null && this.faults[i].messageDecl.getMessage() != null && this.faults[i].messageDecl.getMessage().getPartCount() == 1 && faultName.equals(declaredFaultName = this.faults[i].messageDecl.getMessage().getParts()[0].getName())) {
                return this.faults[i];
            }
            ++i;
        }
        return null;
    }

    public RemoteException mapFaultToException(SOAPMessage faultMessage) {
        try {
            if (this.faults == null || faultMessage == null) {
                return null;
            }
            Element faultElement = faultMessage.getFault();
            if (faultElement == null) {
                return null;
            }
            Element detailElement = faultElement.getElement("detail");
            if (detailElement == null) {
                return null;
            }
            Element faultNameElement = detailElement.getFirstElement();
            if (faultNameElement == null) {
                return null;
            }
            String faultName = faultNameElement.getName();
            SOAPMessageDecl fault = this.matchFaultToWSDLFault(faultName);
            if (fault != null) {
                IReader reader = this.getWriter().getReader(faultMessage);
                return SOAPFault.parseFault(fault, faultName, reader);
            }
        }
        catch (Throwable exception) {}
        return null;
    }
}

