/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.wsdl;

import electric.glue.IGLUELoggingConstants;
import electric.service.descriptor.MethodDescriptor;
import electric.soap.SOAPOptimizations;
import electric.soap.wsdl.SOAPBinding;
import electric.soap.wsdl.SOAPOperationFactory;
import electric.util.Context;
import electric.util.license.Enabler;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.wsdl.WSDL;
import electric.wsdl.WSDLException;
import electric.wsdl.loader.WSDLLoader;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.io.schema.SchemaException;

public final class SOAP12Binding
extends SOAPBinding
implements IGLUELoggingConstants {
    private static boolean enabled;
    private static boolean allowEnable;

    public SOAP12Binding(WSDL wsdl, String namespace, Element binding) throws WSDLException, SchemaException {
        super(wsdl, namespace, binding, "http://schemas.xmlsoap.org/wsdl/soap12/");
        this.checkEnabled();
        Element soap = binding.getElement("http://schemas.xmlsoap.org/wsdl/soap12/", "binding");
        this.transport = soap.getAttributeValue("transport");
        if (this.transport == null) {
            this.transport = "http://schemas.xmlsoap.org/soap/http";
        }
        this.style = soap.getAttributeValue("style");
        if (this.style == null) {
            this.style = "document";
        }
        Elements operations = binding.getElements("operation");
        while (operations.hasMoreElements()) {
            this.addSOAPOperation(SOAPOperationFactory.getSOAPOperation(this, operations.next()));
        }
        Element optimizationsElement = binding.getElement("optimizations");
        if (optimizationsElement != null) {
            this.optimizations = SOAPOptimizations.getSOAPOptimizations(optimizationsElement);
        }
    }

    public SOAP12Binding(WSDL wsdl, String namespace, String name, MethodDescriptor[] methods, Context context) throws WSDLException, SchemaException {
        super(wsdl, namespace, name, methods, context);
        this.checkEnabled();
    }

    public Element writeWSDL(Element definitions) {
        this.checkEnabled();
        Element binding = this.writeWSDLBinding(definitions);
        Element soapBinding = binding.addElement("soap12", "binding");
        soapBinding.setAttribute("style", this.style.toLowerCase());
        soapBinding.setAttribute("transport", this.transport);
        if (this.optimizations != null) {
            Element optimizationsElement = binding.addElement("tme", "optimizations");
            this.optimizations.writeSOAPOptimizations(optimizationsElement);
        }
        int i = 0;
        while (i < this.operations.length) {
            this.operations[i].writeWSDL(binding);
            ++i;
        }
        return binding;
    }

    public SOAPOptimizations getOptimizations() {
        return this.optimizations;
    }

    public static void enable() {
        if (enabled) {
            return;
        }
        if (!allowEnable) {
            throw new IllegalStateException("Virtual Service cannot be enabled once it is disabled");
        }
        enabled = Enabler.enable();
        if (!enabled && Log.isLogging(ILoggingConstants.WARNING_EVENT)) {
            Log.log(ILoggingConstants.WARNING_EVENT, (Object)"virtual service feature cannot be enabled");
        }
    }

    public static void disable() {
        enabled = false;
        allowEnable = false;
        WSDLLoader.clearCache();
        Log.log(ILoggingConstants.WARNING_EVENT, (Object)"SOAP 1.2 feature disabled");
    }

    private void checkEnabled() {
        if (!enabled) {
            throw new IllegalStateException("SOAP 1.2 is disabled");
        }
    }

    static {
        allowEnable = true;
    }
}

