/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security.signature.xml;

import electric.glue.IGLUELoggingConstants;
import electric.soap.security.signature.xml.ElementReference;
import electric.soap.security.signature.xml.IKeyInfoProcessor;
import electric.soap.security.signature.xml.IReferenceProcessor;
import electric.soap.security.signature.xml.IXMLSignatureConstants;
import electric.soap.security.signature.xml.XMLSignature;
import electric.soap.security.signature.xml.XMLSignatureException;
import electric.soap.security.signature.xml.canonical.CanonicalizerFactories;
import electric.soap.security.signature.xml.crypto.ISignatureAlgorithm;
import electric.soap.security.signature.xml.crypto.SignatureAlgorithms;
import electric.soap.security.tokens.SecurityToken;
import electric.soap.security.util.SecurityXPathFactory;
import electric.util.log.Log;
import electric.util.string.Base64;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.IXPath;
import electric.xml.NodeWriter;
import electric.xml.Nodes;
import electric.xml.Text;
import electric.xml.canonical.ExclusiveCanonicalizer;
import electric.xml.canonical.ICanonicalizer;
import electric.xml.xpath.NodeSet;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.Vector;

public class XMLSignatureProcessor
implements IXMLSignatureConstants,
IGLUELoggingConstants {
    public static Element addSignature(Document document, XMLSignature signature, Element securityElement, IReferenceProcessor referenceProcessor, IKeyInfoProcessor keyInfoProcessor) throws XMLSignatureException {
        try {
            return XMLSignatureProcessor.addSignatureInternal(document, signature, securityElement, referenceProcessor, keyInfoProcessor);
        }
        catch (XMLSignatureException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new XMLSignatureException("problem with signature", exception);
        }
    }

    private static Element addSignatureInternal(Document document, XMLSignature signature, Element securityElement, IReferenceProcessor referenceProcessor, IKeyInfoProcessor keyInfoProcessor) throws Exception {
        ICanonicalizer canonicalizer;
        Element signatureElement = new Element("ds", "Signature", "http://www.w3.org/2000/09/xmldsig#");
        signatureElement.setNamespace("ds", "http://www.w3.org/2000/09/xmldsig#");
        securityElement.addChild(signatureElement);
        Element signedInfo = new Element("ds", "SignedInfo", "http://www.w3.org/2000/09/xmldsig#");
        signatureElement.addChild(signedInfo);
        Element c14nMethod = new Element("ds", "CanonicalizationMethod", "http://www.w3.org/2000/09/xmldsig#");
        c14nMethod.setAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        signedInfo.addChild(c14nMethod);
        SecurityToken securityToken = signature.getReferencedToken();
        String signatureMethodAlgorithm = signature.getSignatureMethod();
        if (signatureMethodAlgorithm == null) {
            signatureMethodAlgorithm = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        }
        Element signatureMethod = new Element("ds", "SignatureMethod", "http://www.w3.org/2000/09/xmldsig#");
        signatureMethod.setAttribute("Algorithm", signatureMethodAlgorithm);
        String canonicalizationMethod = signature.getCanonicalizationMethod();
        if (canonicalizationMethod == null) {
            canonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n";
        }
        if ((canonicalizer = CanonicalizerFactories.getCanonicalizer(canonicalizationMethod)) == null) {
            throw new XMLSignatureException("canonicalizer not found: " + canonicalizationMethod);
        }
        signedInfo.addChild(signatureMethod);
        Enumeration references = signature.getReferences();
        while (references.hasMoreElements()) {
            ElementReference reference = (ElementReference)references.nextElement();
            XMLSignatureProcessor.addReference(document, reference, signedInfo, referenceProcessor, canonicalizer);
        }
        String allFilter = "(//. | //@* | //namespace::*)";
        IXPath xpathAll = SecurityXPathFactory.createXPath(allFilter);
        Nodes allNodesList = xpathAll.getNodes(document);
        NodeSet allNodes = new NodeSet(allNodesList);
        ExclusiveCanonicalizer cizer = new ExclusiveCanonicalizer();
        byte[] c14n = cizer.canonicalize(allNodes, signedInfo);
        ISignatureAlgorithm signatureAlgorithm = SignatureAlgorithms.getSignatureAlgorithm(signatureMethodAlgorithm);
        if (signatureAlgorithm == null) {
            throw new XMLSignatureException("signature algorithm not found:" + signatureMethod);
        }
        byte[] signatureBytes = signatureAlgorithm.sign(signature, securityToken, c14n);
        String signature64 = Base64.toBase64(signatureBytes);
        Element signatureValue = new Element("ds", "SignatureValue", "http://www.w3.org/2000/09/xmldsig#");
        signatureValue.setText(signature64);
        signatureElement.addChild(signatureValue);
        keyInfoProcessor.addKeyInfo(signature, signatureElement);
        return signatureElement;
    }

    private static void dumpXMLToFile(Element root, String fileName) throws IOException {
        FileOutputStream fostr = new FileOutputStream(fileName);
        OutputStreamWriter ostrw = new OutputStreamWriter(fostr);
        NodeWriter wrt = new NodeWriter(ostrw, -1, false);
        root.write(wrt);
        ((Writer)ostrw).flush();
        fostr.close();
    }

    private static void addReference(Document document, ElementReference reference, Element signedInfo, IReferenceProcessor referenceProcessor, ICanonicalizer canonicalizer) throws Exception {
        Element element = referenceProcessor.resolveReference(document.getRoot(), reference);
        Element referenceElement = referenceProcessor.addReference(document, reference);
        signedInfo.addChild(referenceElement);
        Element transforms = new Element("ds", "Transforms", "http://www.w3.org/2000/09/xmldsig#");
        referenceElement.addChild(transforms);
        Element transform = new Element("ds", "Transform", "http://www.w3.org/2000/09/xmldsig#");
        transform.setAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        transforms.addChild(transform);
        Element digestMethod = new Element("ds", "DigestMethod", "http://www.w3.org/2000/09/xmldsig#");
        digestMethod.setAttribute("Algorithm", "http://www.w3.org/2000/09/xmldsig#sha1");
        referenceElement.addChild(digestMethod);
        Element digestValue = new Element("ds", "DigestValue", "http://www.w3.org/2000/09/xmldsig#");
        referenceElement.addChild(digestValue);
        String allFilter = "(//. | //@* | //namespace::*)";
        IXPath xpathAll = SecurityXPathFactory.createXPath(allFilter);
        Nodes allNodesList = xpathAll.getNodes(element);
        NodeSet allNodes = new NodeSet(allNodesList);
        byte[] c14n = canonicalizer.canonicalize(allNodes, element);
        MessageDigest md = MessageDigest.getInstance("SHA1");
        byte[] digest = md.digest(c14n);
        String digest64 = Base64.toBase64(digest);
        digestValue.setText(digest64);
    }

    public static boolean verifySignature(Element rootElement, Element signatureElement, Vector securityTokens, XMLSignature signature, IReferenceProcessor referenceProcessor, IKeyInfoProcessor keyInfoProcessor) throws XMLSignatureException {
        try {
            return XMLSignatureProcessor.verifySignatureInternal(rootElement, signatureElement, securityTokens, signature, referenceProcessor, keyInfoProcessor);
        }
        catch (Exception exception) {
            throw new XMLSignatureException("problem verifying signature", exception);
        }
    }

    public static boolean verifySignatureInternal(Element rootElement, Element signatureElement, Vector securityTokens, XMLSignature signature, IReferenceProcessor referenceProcessor, IKeyInfoProcessor keyInfoProcessor) throws Exception {
        String referencePath = ".//ds:Reference";
        IXPath xpathReference = SecurityXPathFactory.createXPath(referencePath);
        xpathReference.setNamespace("ds", "http://www.w3.org/2000/09/xmldsig#");
        Elements referenceElements = xpathReference.getElements(signatureElement);
        while (referenceElements.hasMoreElements()) {
            Element referenceElement = (Element)referenceElements.nextElement();
            boolean r = XMLSignatureProcessor.verifyReference(rootElement, referenceElement, signature, referenceProcessor);
            if (r) continue;
            if (Log.isLogging(IGLUELoggingConstants.SECURITY_DEBUG_EVENT)) {
                Log.log(IGLUELoggingConstants.SECURITY_DEBUG_EVENT, (Object)"VerifyMS.verifySignature():reference validation failure");
            }
            return false;
        }
        boolean r = XMLSignatureProcessor.verifySignedInfo(rootElement, signatureElement, securityTokens, signature, keyInfoProcessor);
        return r;
    }

    private static boolean verifyReference(Element rootElement, Element referenceElement, XMLSignature signature, IReferenceProcessor referenceProcessor) throws Exception {
        ElementReference reference = referenceProcessor.elementToReference(rootElement, referenceElement);
        signature.addReference(reference);
        Element referencedElement = referenceProcessor.resolveReference(rootElement, reference);
        String allFilter = "(//. | //@* | //namespace::*)";
        IXPath xpathAll = SecurityXPathFactory.createXPath(allFilter);
        Nodes allNodesList = xpathAll.getNodes(referencedElement);
        NodeSet allNodes = new NodeSet(allNodesList);
        ExclusiveCanonicalizer cizer = new ExclusiveCanonicalizer();
        byte[] c14n = cizer.canonicalize(allNodes, referencedElement);
        MessageDigest md = MessageDigest.getInstance("SHA1");
        byte[] calcDigest = md.digest(c14n);
        String calcDigest64 = Base64.toBase64(calcDigest);
        String digestValuePath = ".//ds:DigestValue";
        IXPath digestValueXPath = SecurityXPathFactory.createXPath(digestValuePath);
        digestValueXPath.setNamespace("ds", "http://www.w3.org/2000/09/xmldsig#");
        Element digestValueElement = digestValueXPath.getElement(referenceElement);
        Text text = (Text)digestValueElement.getFirstChild();
        String msgDigest64 = text.getData().trim();
        return calcDigest64.equals(msgDigest64);
    }

    private static byte[] calcSignedInfo(Element signatureElement) throws Exception {
        String path = ".//ds:SignedInfo";
        IXPath xpath = SecurityXPathFactory.createXPath(path);
        xpath.setNamespace("ds", "http://www.w3.org/2000/09/xmldsig#");
        Element element = xpath.getElement(signatureElement);
        String allFilter = "(//. | //@* | //namespace::*)";
        IXPath xpathAll = SecurityXPathFactory.createXPath(allFilter);
        Nodes allNodesList = xpathAll.getNodes(element);
        NodeSet allNodes = new NodeSet(allNodesList);
        ExclusiveCanonicalizer cizer = new ExclusiveCanonicalizer();
        byte[] c14n = cizer.canonicalize(allNodes, element);
        return c14n;
    }

    private static void dumpBytesToFile(byte[] c14n, String fileName) throws IOException {
        FileOutputStream saveTmp = new FileOutputStream(fileName);
        saveTmp.write(c14n);
        saveTmp.close();
    }

    private static byte[] getSignatureBytes(Element signatureElement) {
        String path = "ds:SignatureValue";
        IXPath xpath = SecurityXPathFactory.createXPath(path);
        xpath.setNamespace("ds", "http://www.w3.org/2000/09/xmldsig#");
        Element element = (Element)xpath.getNode(signatureElement);
        Text text = (Text)element.getFirstChild();
        String data = text.getData();
        byte[] sigData = Base64.fromBase64(data);
        return sigData;
    }

    private static Element getKeyInfo(Element signatureElement) {
        String path = "ds:KeyInfo";
        IXPath xpath = SecurityXPathFactory.createXPath(path);
        xpath.setNamespace("ds", "http://www.w3.org/2000/09/xmldsig#");
        return (Element)xpath.getNode(signatureElement);
    }

    private static String getSignatureAlgorithm(Element signatureElement) {
        String path = "ds:SignedInfo/ds:SignatureMethod";
        IXPath xpath = SecurityXPathFactory.createXPath(path);
        xpath.setNamespace("ds", "http://www.w3.org/2000/09/xmldsig#");
        Element signatureMethodElement = (Element)xpath.getNode(signatureElement);
        if (signatureMethodElement == null) {
            return null;
        }
        String algorithmId = signatureMethodElement.getAttribute("Algorithm");
        if (algorithmId == null) {
            return null;
        }
        return algorithmId;
    }

    private static boolean verifySignedInfo(Element rootElement, Element signatureElement, Vector securityTokens, XMLSignature signature, IKeyInfoProcessor keyInfoProcessor) throws Exception {
        Element keyInfoElement = XMLSignatureProcessor.getKeyInfo(signatureElement);
        SecurityToken securityToken = keyInfoProcessor.findToken(securityTokens, keyInfoElement, rootElement);
        if (securityToken == null) {
            return false;
        }
        String path = "ds:SignedInfo/ds:SignatureMethod";
        IXPath xpath = SecurityXPathFactory.createXPath(path);
        xpath.setNamespace("ds", "http://www.w3.org/2000/09/xmldsig#");
        String algorithmId = XMLSignatureProcessor.getSignatureAlgorithm(signatureElement);
        ISignatureAlgorithm signatureAlgorithm = SignatureAlgorithms.getSignatureAlgorithm(algorithmId);
        if (signatureAlgorithm == null) {
            return false;
        }
        byte[] sigData = XMLSignatureProcessor.getSignatureBytes(signatureElement);
        byte[] c14n = XMLSignatureProcessor.calcSignedInfo(signatureElement);
        boolean r = signatureAlgorithm.verify(signature, securityToken, c14n, sigData);
        return r;
    }
}

