/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security.signature;

import electric.soap.security.IWSSConstants;
import electric.soap.security.signature.xml.ElementReference;
import electric.soap.security.signature.xml.IReferenceProcessor;
import electric.soap.security.signature.xml.IXMLSignatureConstants;
import electric.soap.security.util.SecurityXPathFactory;
import electric.util.UUID;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.IXPath;

public class WSSReferenceProcessor
implements IReferenceProcessor,
IXMLSignatureConstants,
IWSSConstants {
    public Element resolveReference(Element rootElement, ElementReference reference) {
        Element envelope = rootElement;
        if (reference.getPath().startsWith("#")) {
            String id = reference.getPath().substring(1);
            String referencePath = "//*[@wsu:Id=\"" + id + '\"' + "]";
            IXPath xpathReference = SecurityXPathFactory.createXPath(referencePath);
            xpathReference.setNamespace("wsu", "http://schemas.xmlsoap.org/ws/2002/07/utility");
            Element referencedElement = xpathReference.getElement(envelope.getDocument());
            return referencedElement;
        }
        IXPath xpath = SecurityXPathFactory.createXPath(reference);
        Element element = (Element)xpath.getNode(envelope.getDocument());
        return element;
    }

    public Element addReference(Document document, ElementReference reference) {
        String Id2 = new UUID().getKey();
        Id2 = "electric-id-" + Id2;
        IXPath xpath = SecurityXPathFactory.createXPath(reference);
        Element element = (Element)xpath.getNode(document);
        element.setNamespace("wsu", "http://schemas.xmlsoap.org/ws/2002/07/utility");
        element.setAttributeNS("http://schemas.xmlsoap.org/ws/2002/07/utility", "wsu:Id", Id2);
        Element referenceElement = new Element("ds", "Reference", "http://www.w3.org/2000/09/xmldsig#");
        referenceElement.setAttribute("URI", "#" + Id2);
        return referenceElement;
    }

    public ElementReference elementToReference(Element rootElement, Element referenceElement) {
        String URI2 = referenceElement.getAttribute("URI");
        ElementReference reference = new ElementReference(URI2);
        return reference;
    }
}

