/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security.signature;

import electric.soap.security.IWSSConstants;
import electric.soap.security.signature.xml.IKeyInfoProcessor;
import electric.soap.security.signature.xml.IXMLSignatureConstants;
import electric.soap.security.signature.xml.XMLSignature;
import electric.soap.security.tokens.SecurityToken;
import electric.xml.Element;
import java.util.Vector;

public class WSSKeyInfoProcessor
implements IKeyInfoProcessor,
IWSSConstants,
IXMLSignatureConstants {
    public SecurityToken findToken(Vector securityTokens, Element keyInfoElement, Element rootElement) {
        Element keyInfoToken = keyInfoElement.getElement("http://schemas.xmlsoap.org/ws/2002/12/secext", "SecurityTokenReference");
        if (keyInfoToken == null) {
            return null;
        }
        Element keyInfoReference = keyInfoToken.getElement("http://schemas.xmlsoap.org/ws/2002/12/secext", "Reference");
        if (keyInfoReference == null) {
            return null;
        }
        String URI2 = keyInfoReference.getAttribute("URI");
        if (URI2 == null) {
            return null;
        }
        String tokenId = URI2.substring(1);
        SecurityToken securityToken = null;
        int i = 0;
        while (i < securityTokens.size()) {
            securityToken = (SecurityToken)securityTokens.elementAt(i);
            if (tokenId.equals(securityToken.getId())) break;
            ++i;
        }
        return securityToken;
    }

    public void addKeyInfo(XMLSignature signature, Element signatureElement) {
        SecurityToken referencedToken = signature.getReferencedToken();
        String tokenId = referencedToken.getId();
        Element keyInfo = new Element("ds", "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
        signatureElement.addChild(keyInfo);
        Element securityTokRef = new Element("wsse", "SecurityTokenReference", "http://schemas.xmlsoap.org/ws/2002/12/secext");
        keyInfo.addChild(securityTokRef);
        Element keyReference = new Element("wsse", "Reference", "http://schemas.xmlsoap.org/ws/2002/12/secext");
        keyReference.setAttribute("URI", "#" + tokenId);
        securityTokRef.addChild(keyReference);
    }
}

